/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.htmlbrowser.BrowserContext;
import ice.htmlbrowser.Document;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ewt.event.ListenerManager;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;

public class ICEBrowser
extends Panel
implements HTMLBrowser,
BrowserContext {
    private Hashtable _documents;
    private Document _activeDocument;
    private URL _activeUrl;
    private ListenerManager _urlListeners;
    private ListenerManager _popupListeners;
    private _mouseAdapter _popupAdapter = new _mouseAdapter();

    public ICEBrowser() {
        this.setLayout(new BorderLayout());
        this._documents = new Hashtable();
    }

    public void setURL(URL uRL) {
        boolean bl = true;
        if (this._activeDocument != null) {
            this._activeDocument.hideDocument();
            this.remove((Component)this._activeDocument);
        }
        this._activeDocument = (Document)this._documents.get(uRL.toString());
        if (this._activeDocument == null) {
            int n;
            Component[] componentArray;
            if (this._documents.size() >= 20) {
                componentArray = this._documents.keys();
                n = 0;
                while (componentArray.hasMoreElements()) {
                    String string = (String)componentArray.nextElement();
                    Document document = (Document)this._documents.get(string);
                    if (document == this._activeDocument) continue;
                    document.removeMouseListener(this._popupAdapter);
                    this._documents.remove(string);
                    if (++n != 5) continue;
                    return;
                }
            }
            this._activeDocument = new Document(uRL);
            this._activeDocument.setMarginWidth(20);
            this._activeDocument.setMarginHeight(20);
            this._documents.put(uRL.toString(), this._activeDocument);
            componentArray = this._activeDocument.getComponents();
            n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Panel) {
                    componentArray[n].addMouseListener(this._popupAdapter);
                }
                ++n;
            }
            bl = false;
        }
        this._activeUrl = uRL;
        this.add((Component)this._activeDocument, "Center");
        this.validateTree();
        this._dispatchURLEvent(new URLEvent(uRL));
    }

    public URL getURL() {
        return this._activeUrl;
    }

    public void reloadURL() {
    }

    public void print() {
        Frame frame = this._getFrame();
        if (frame == null) {
            return;
        }
        PrintJob printJob = this.getToolkit().getPrintJob(frame, "Help Topic", null);
        if (printJob != null) {
            this._activeDocument.printDoc(printJob);
            printJob.end();
        }
    }

    public void printURL(URL uRL) {
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void addURLListener(URLListener uRLListener) {
        if (this._urlListeners == null) {
            this._urlListeners = new ListenerManager();
        }
        this._urlListeners.addListener(uRLListener);
    }

    public void removeURLListener(URLListener uRLListener) {
        if (this._urlListeners != null) {
            this._urlListeners.addListener(uRLListener);
        }
    }

    public void addPopupListener(PopupListener popupListener) {
        if (this._popupListeners == null) {
            this._popupListeners = new ListenerManager();
        }
        this._popupListeners.addListener(popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this._popupListeners.removeListener(popupListener);
    }

    public String getCharset() {
        return null;
    }

    public void setCharset(String string) {
    }

    public void gotoLocation(URL uRL, String string, String string2) {
        this.setURL(uRL);
    }

    public void updateTitle(String string) {
    }

    public void updateCurrentURL() {
        this.reloadURL();
    }

    public boolean isMemoryCaching() {
        return true;
    }

    public URL getReferer() {
        return null;
    }

    public void setReferer(URL uRL) {
    }

    private Frame _getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void _dispatchURLEvent(URLEvent uRLEvent) {
        Enumeration enumeration;
        if (this._urlListeners != null && (enumeration = this._urlListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                URLListener uRLListener = (URLListener)enumeration.nextElement();
                uRLListener.urlChanged(uRLEvent);
            }
        }
    }

    private void _dispatchPopupEvent(PopupEvent popupEvent) {
        Enumeration enumeration;
        if (this._popupListeners != null && (enumeration = this._popupListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PopupListener popupListener = (PopupListener)enumeration.nextElement();
                popupListener.showPopup(popupEvent);
            }
        }
    }

    static /* synthetic */ void access$0(ICEBrowser iCEBrowser, PopupEvent popupEvent) {
        iCEBrowser._dispatchPopupEvent(popupEvent);
    }

    private class _mouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                ICEBrowser iCEBrowser = ICEBrowser.this;
                PopupEvent popupEvent = new PopupEvent((Component)mouseEvent.getSource(), mouseEvent);
                iCEBrowser._dispatchPopupEvent(popupEvent);
            }
        }

        _mouseAdapter() {
            ICEBrowser.this = ICEBrowser.this;
        }
    }
}

