/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.topicWindow.SyncGoMenu;
import oracle.help.util.MenuDefs;

public class NavigatorMenuBar
extends MenuBar
implements ItemListener,
SyncGoMenu {
    private Menu _fileUndocked;
    private Menu _viewUndocked;
    private Menu _toolsUndocked;
    private Menu _fileDocked;
    private Menu _viewDocked;
    private Menu _toolsDocked;
    private Menu _goDocked;
    private Menu _editDocked;
    private Menu _help;
    private MenuItem _display;
    private MenuItem _displayNew;
    private MenuItem _printTree;
    private MenuItem _printTopic;
    private MenuItem _close;
    private MenuItem _exit;
    private MenuItem _expand;
    private MenuItem _collapse;
    private MenuItem _expandAll;
    private MenuItem _collapseAll;
    private MenuItem _back;
    private MenuItem _forward;
    private CheckboxMenuItem _contents;
    private CheckboxMenuItem _index;
    private MenuItem _search;
    private MenuItem _preferences;
    private MenuItem _undock;
    private MenuItem _helponhelp;
    private MenuItem _about;
    private boolean _docked = true;
    private NavigatorWindow _window;
    static String[] FILE_LABELS = new String[]{"File", "Display", "Display_New", "-", "PrintTree", "-", "Close", "Exit"};
    static final int FILE_DISPLAY_INDEX = 0;
    static final int FILE_DISPLAY_NEW_INDEX = 1;
    static final int FILE_PRINT_TREE_INDEX = 3;
    static final int FILE_CLOSE_INDEX = 5;
    static final int FILE_EXIT_INDEX = 6;
    static String[] DOCKED_FILE_LABELS = new String[]{"File", "Display", "Display_New", "-", "PrintTree", "PrintTopic", "-", "Close", "Exit"};
    static final int DFILE_DISPLAY_INDEX = 0;
    static final int DFILE_DISPLAY_NEW_INDEX = 1;
    static final int DFILE_PRINT_TREE_INDEX = 3;
    static final int DFILE_PRINT_TOPIC_INDEX = 4;
    static final int DFILE_CLOSE_INDEX = 6;
    static final int DFILE_EXIT_INDEX = 7;
    static String[] EDIT_LABELS = new String[]{"Edit", "Copy"};
    static String[] VIEW_LABELS = new String[]{"View", "Contents", "Index", "-", "Expand", "Collapse", "Expand_All", "Collapse_All", "-"};
    static final int VIEW_CONTENTS_INDEX = 0;
    static final int VIEW_INDEX_INDEX = 1;
    static final int VIEW_EXPAND_INDEX = 3;
    static final int VIEW_COLLAPSE_INDEX = 4;
    static final int VIEW_EXPAND_ALL_INDEX = 5;
    static final int VIEW_COLLAPSE_ALL_INDEX = 6;
    static String[] GO_LABELS = new String[]{"Go", "Back", "Forward"};
    static final int GO_BACK_INDEX = 0;
    static final int GO_FORWARD_INDEX = 1;
    static String[] TOOLS_LABELS = new String[]{"Tools", "Search", "Preferences"};
    static final int TOOLS_SEARCH_INDEX = 0;
    static final int TOOLS_PREFERENCES_INDEX = 1;
    static String[] DOCKED_TOOLS_LABELS = new String[]{"Tools", "Search", "Preferences", "Undock"};
    static final int DTOOLS_SEARCH_INDEX = 0;
    static final int DTOOLS_PREFERENCES_INDEX = 1;
    static final int DTOOLS_UNDOCK_INDEX = 2;
    static String[] HELP_LABELS = new String[]{"Help", "HelpOnHelp", "About"};
    static final int HELP_HELP_INDEX = 0;
    static final int HELP_ABOUT_INDEX = 1;
    static final Object MENU_LOCK = new Object();

    public NavigatorMenuBar(NavigatorWindow navigatorWindow) {
        this(navigatorWindow, false);
    }

    public NavigatorMenuBar(NavigatorWindow navigatorWindow, boolean bl) {
        this.setName("NavigatorMenuBar");
        this._window = navigatorWindow;
        if (bl) {
            this.setDockedState();
            return;
        }
        this.setUndockedState();
    }

    public void setUndockedState() {
        this._removeMenus();
        if (this._fileUndocked == null) {
            this._createUndockedMenubarItems();
        }
        Object object = MENU_LOCK;
        synchronized (object) {
            this.add(this._fileUndocked);
            this.add(this._viewUndocked);
            this.add(this._toolsUndocked);
            this.add(this._help);
        }
        this.setHelpMenu(this._help);
        this._display = this._fileUndocked.getItem(0);
        this._displayNew = this._fileUndocked.getItem(1);
        this._printTree = this._fileUndocked.getItem(3);
        this._close = this._fileUndocked.getItem(5);
        this._exit = this._fileUndocked.getItem(6);
        this._search = this._toolsUndocked.getItem(0);
        this._preferences = this._toolsUndocked.getItem(1);
        this._contents = (CheckboxMenuItem)this._viewUndocked.getItem(0);
        this._index = (CheckboxMenuItem)this._viewUndocked.getItem(1);
        this._collapse = this._viewUndocked.getItem(4);
        this._collapseAll = this._viewUndocked.getItem(6);
        this._expand = this._viewUndocked.getItem(3);
        this._expandAll = this._viewUndocked.getItem(5);
        this._docked = false;
    }

    public void setDockedState() {
        this._removeMenus();
        if (this._fileDocked == null) {
            this._createDockedMenubarItems();
        }
        Object object = MENU_LOCK;
        synchronized (object) {
            this.add(this._fileDocked);
            this.add(this._viewDocked);
            this.add(this._goDocked);
            this.add(this._toolsDocked);
            this.add(this._help);
        }
        this.setHelpMenu(this._help);
        this._display = this._fileDocked.getItem(0);
        this._displayNew = this._fileDocked.getItem(1);
        this._printTree = this._fileDocked.getItem(3);
        this._printTopic = this._fileDocked.getItem(4);
        this._close = this._fileDocked.getItem(6);
        this._exit = this._fileDocked.getItem(7);
        this._search = this._toolsDocked.getItem(0);
        this._preferences = this._toolsDocked.getItem(1);
        this._undock = this._toolsDocked.getItem(2);
        this._contents = (CheckboxMenuItem)this._viewDocked.getItem(0);
        this._index = (CheckboxMenuItem)this._viewDocked.getItem(1);
        this._collapse = this._viewDocked.getItem(4);
        this._collapseAll = this._viewDocked.getItem(6);
        this._expand = this._viewDocked.getItem(3);
        this._expandAll = this._viewDocked.getItem(5);
        this._back = this._goDocked.getItem(0);
        this._forward = this._goDocked.getItem(1);
        this._docked = true;
    }

    public void setEnableAll(boolean bl) {
        MenuDefs.setEnableAll(this, bl);
        this._about.setEnabled(true);
        this._helponhelp.setEnabled(true);
        if (this._printTopic != null) {
            this._printTopic.setEnabled(true);
        }
        this._close.setEnabled(true);
        this._preferences.setEnabled(true);
        this._exit.setEnabled(true);
    }

    public void setExpandEnabled(boolean bl) {
        this._expand.setEnabled(bl);
    }

    public void setExpandAllEnabled(boolean bl) {
        this._expandAll.setEnabled(bl);
    }

    public void setCollapseEnabled(boolean bl) {
        this._collapse.setEnabled(bl);
    }

    public void setCollapseAllEnabled(boolean bl) {
        this._collapseAll.setEnabled(bl);
    }

    public void setDisplayEnabled(boolean bl) {
        this._display.setEnabled(bl);
        this._displayNew.setEnabled(bl);
    }

    public void setUndockEnabled(boolean bl) {
        this._undock.setEnabled(bl);
    }

    public void setContentsIndexEnabled(boolean bl) {
        this._contents.setEnabled(bl);
        this._index.setEnabled(bl);
    }

    public void setContentsEnabled(boolean bl) {
        this._contents.setEnabled(bl);
        this._printTree.setEnabled(bl);
    }

    public void setContentsState(boolean bl) {
        this._contents.setState(bl);
    }

    public void setIndexEnabled(boolean bl) {
        this._index.setEnabled(bl);
    }

    public void setIndexState(boolean bl) {
        this._index.setState(bl);
    }

    public void setSearchEnabled(boolean bl) {
        this._search.setEnabled(bl);
    }

    public void setBackEnabled(boolean bl) {
        this._back.setEnabled(bl);
    }

    public void setForwardEnabled(boolean bl) {
        this._forward.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._contents) {
            this._window.showContents();
            this._index.setState(false);
            return;
        }
        if (object == this._index) {
            this._window.showIndex();
            this._contents.setState(false);
        }
    }

    private void _createUndockedMenubarItems() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        this._fileUndocked = MenuDefs.createMenu(this._window, FILE_LABELS, resourceBundle);
        this._viewUndocked = MenuDefs.createMenu(this._window, this._window, VIEW_LABELS, resourceBundle, false);
        this._toolsUndocked = MenuDefs.createMenu(this._window, TOOLS_LABELS, resourceBundle);
        if (this._help == null) {
            this._createHelpMenu(resourceBundle);
        }
    }

    private void _createDockedMenubarItems() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        this._fileDocked = MenuDefs.createMenu(this._window, DOCKED_FILE_LABELS, resourceBundle);
        this._viewDocked = MenuDefs.createMenu(this._window, this._window, VIEW_LABELS, resourceBundle, false);
        this._goDocked = MenuDefs.createMenu(this._window, GO_LABELS, resourceBundle);
        this._toolsDocked = MenuDefs.createMenu(this._window, DOCKED_TOOLS_LABELS, resourceBundle);
        if (this._help == null) {
            this._createHelpMenu(resourceBundle);
        }
    }

    private void _createHelpMenu(ResourceBundle resourceBundle) {
        this._help = MenuDefs.createMenu(this._window, HELP_LABELS, resourceBundle);
        this._about = this._help.getItem(1);
        this._helponhelp = this._help.getItem(0);
    }

    private void _removeMenus() {
        Object object = MENU_LOCK;
        synchronized (object) {
            if (this._docked) {
                this.remove(this._fileDocked);
                this.remove(this._viewDocked);
                this.remove(this._goDocked);
                this.remove(this._toolsDocked);
                this.remove(this._help);
            } else {
                this.remove(this._fileUndocked);
                this.remove(this._viewUndocked);
                this.remove(this._toolsUndocked);
                this.remove(this._help);
            }
            return;
        }
    }
}

