/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicWindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.border.SeparatorBorder;
import oracle.ewt.graphics.separator.InsetSeparatorPainter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarButton;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarRadio;
import oracle.ewt.toolBar.ToolBarRadioGroup;
import oracle.ewt.toolBar.ToolBarSeparator;
import oracle.help.HelpBook;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.topicWindow.DocumentStack;
import oracle.help.topicWindow.DocumentStackEvent;
import oracle.help.topicWindow.DocumentStackListener;
import oracle.help.topicWindow.HWToolBarToolTip;
import oracle.help.topicWindow.SyncGoMenu;
import oracle.help.topicWindow.TopicWindow;
import oracle.help.util.ImageLoader;

public class TopicWindowPanel
extends EwtComponent
implements ToolBarActionListener,
DocumentStackListener {
    TopicWindow _window;
    ToolBar _toolbar;
    HTMLBrowser _htmlBrowser;
    ToolBarButton _navigatorButton;
    ToolBarButton _searchButton;
    ToolBarButton _backButton;
    ToolBarSeparator _separator;
    ToolBarButton _forwardButton;
    ToolBarButton _printButton;
    ToolBarRadio _dockButton;
    ToolBarRadio _undockButton;
    boolean _isDocked;
    SyncGoMenu _syncGoMenu;
    NavigatorWindow _navigator;
    DocumentStack _stack;
    public static final int NAVIGATOR = 1;
    public static final int SEARCH = 2;
    public static final int PREVIOUS = 3;
    public static final int NEXT = 4;
    public static final int PRINT = 5;
    public static final int DOCK = 6;
    static Image _navImage;
    static Image _searchImage;
    static Image _larrowImage;
    static Image _rarrowImage;
    static Image _printImage;
    static Image _dockImage;
    static Image _undockImage;

    public TopicWindowPanel(TopicWindow topicWindow, HTMLBrowser hTMLBrowser) {
        this._window = topicWindow;
        ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        this.setBorder(new SeparatorBorder(2, InsetSeparatorPainter.getSeparatorPainter(), 0));
        new MarginBorder(10, 10, 10, 10);
        this._toolbar = new ToolBar();
        this._toolbar.addItem(new ToolBarSeparator());
        if (_navImage == null) {
            this.loadImages();
        }
        this._navigatorButton = new ToolBarButton(1, _navImage);
        this._toolbar.addItem(this._navigatorButton);
        this._navigatorButton.addToolBarActionListener(this);
        this._navigatorButton.setEnabled(true);
        this._searchButton = new ToolBarButton(2, _searchImage);
        this._toolbar.addItem(this._searchButton);
        this._searchButton.addToolBarActionListener(this);
        this._separator = new ToolBarSeparator();
        this._toolbar.addItem(this._separator);
        this._searchButton.setEnabled(false);
        this._backButton = new ToolBarButton(3, _larrowImage);
        this._toolbar.addItem(this._backButton);
        this._backButton.addToolBarActionListener(this);
        this._backButton.setEnabled(false);
        this._forwardButton = new ToolBarButton(3, _rarrowImage);
        this._toolbar.addItem(this._forwardButton);
        this._forwardButton.addToolBarActionListener(this);
        this._toolbar.addItem(new ToolBarSeparator());
        this._forwardButton.setEnabled(false);
        this._printButton = new ToolBarButton(4, _printImage);
        this._toolbar.addItem(this._printButton);
        this._printButton.addToolBarActionListener(this);
        this._toolbar.addItem(new ToolBarSeparator());
        ToolBarRadioGroup toolBarRadioGroup = new ToolBarRadioGroup();
        this._dockButton = new ToolBarRadio(4, _dockImage, toolBarRadioGroup);
        this._toolbar.addItem(this._dockButton);
        this._dockButton.addToolBarActionListener(this);
        this._dockButton.setState(false);
        this._undockButton = new ToolBarRadio(4, _undockImage, toolBarRadioGroup);
        this._toolbar.addItem(this._undockButton);
        this._undockButton.addToolBarActionListener(this);
        this._undockButton.setState(true);
        this._toolbar.setBorder(new SeparatorBorder(2, InsetSeparatorPainter.getSeparatorPainter(), 1));
        this._htmlBrowser = hTMLBrowser;
        this.setLayout(new BorderLayout(1, 4));
        this.add((Component)this._toolbar, "North");
        this.add((Component)((Object)this._htmlBrowser), "Center");
        this._isDocked = false;
        this._stack = new DocumentStack(hTMLBrowser);
        this._stack.addStackListener(this);
        this._toolbar.setToolTipValue(new HWToolBarToolTip(this._toolbar));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        this._navigatorButton.setHelpText(resourceBundle.getString("Navigator"));
        this._searchButton.setHelpText(resourceBundle.getString("Search"));
        this._backButton.setHelpText(resourceBundle.getString("Back"));
        this._forwardButton.setHelpText(resourceBundle.getString("Forward"));
        this._printButton.setHelpText(resourceBundle.getString("PrintTopic").substring(2));
        this._dockButton.setHelpText(resourceBundle.getString("Dock"));
        this._undockButton.setHelpText(resourceBundle.getString("Undock"));
    }

    private synchronized void loadImages() {
        _navImage = ImageLoader.loadImage(this, "images/navigator.gif");
        _searchImage = ImageLoader.loadImage(this, "images/search.gif");
        _larrowImage = ImageLoader.loadImage(this, "images/leftarrow.gif");
        _rarrowImage = ImageLoader.loadImage(this, "images/rightarrow.gif");
        _printImage = ImageLoader.loadImage(this, "images/print.gif");
        _dockImage = ImageLoader.loadImage(this, "images/dock.gif");
        _undockImage = ImageLoader.loadImage(this, "images/undock.gif");
    }

    public Dimension getMinimumSize() {
        return new Dimension(225, 100);
    }

    public void displayUrl(HelpBook helpBook, URL uRL) {
        this._stack.setURL(helpBook, uRL);
    }

    public void setNavigatorEnabled(boolean bl) {
        this._navigatorButton.setEnabled(bl);
    }

    public void setSearchEnabled(boolean bl) {
        this._searchButton.setEnabled(bl);
    }

    public void setDockEnabled(boolean bl) {
        if (bl) {
            this._undockButton.setState(true);
            return;
        }
        this._dockButton.setState(true);
    }

    public void setBackEnabled(boolean bl) {
        this._backButton.setEnabled(bl);
    }

    public void setForwardEnabled(boolean bl) {
        this._forwardButton.setEnabled(bl);
    }

    public void setDocked(boolean bl, TopicWindow topicWindow) {
        this._isDocked = bl;
        if (bl) {
            this.setNavigatorEnabled(false);
            this.setDockEnabled(false);
            this._window = null;
            this._toolbar.removeItem(this._navigatorButton);
            this._toolbar.removeItem(this._searchButton);
            return;
        }
        this._toolbar.addItem(this._navigatorButton, this._separator);
        this._toolbar.addItem(this._searchButton, this._separator);
        this.setDockEnabled(true);
        this._window = topicWindow;
    }

    public void setSyncGoMenu(SyncGoMenu syncGoMenu) {
        this._syncGoMenu = syncGoMenu;
        this.syncBackForward();
    }

    public void setNavigatorWindow(NavigatorWindow navigatorWindow) {
        this._navigator = navigatorWindow;
    }

    public void printTopic() {
        this._htmlBrowser.print();
    }

    public void goBack() {
        this._stack.goBack();
        this.syncBackForward();
    }

    public void goForward() {
        this._stack.goForward();
        this.syncBackForward();
    }

    public URL getURL() {
        return this._stack.getURL();
    }

    public HelpBook getBook() {
        return this._stack.getBook();
    }

    public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
        ToolBarButton toolBarButton = (ToolBarButton)toolBarEvent.getItem();
        if (toolBarButton == this._navigatorButton) {
            this._window.navigator();
            return;
        }
        if (toolBarButton == this._searchButton) {
            this._window.search();
            return;
        }
        if (toolBarButton == this._backButton) {
            this.goBack();
            return;
        }
        if (toolBarButton == this._forwardButton) {
            this.goForward();
            return;
        }
        if (toolBarButton == this._printButton) {
            this.printTopic();
            return;
        }
        if (toolBarButton == this._dockButton) {
            this._window.dockTopicWindow();
            return;
        }
        if (toolBarButton == this._undockButton && this._navigator != null) {
            this._navigator.undockTopicPanel(true, true);
        }
    }

    public void syncBackForward() {
        boolean bl = this._stack.canGoBack();
        boolean bl2 = this._stack.canGoForward();
        this.setBackEnabled(bl);
        this.setForwardEnabled(bl2);
        if (this._syncGoMenu != null) {
            this._syncGoMenu.setBackEnabled(bl);
            this._syncGoMenu.setForwardEnabled(bl2);
        }
    }

    public void documentStackChanged(DocumentStackEvent documentStackEvent) {
        this.syncBackForward();
        if (this._navigator != null) {
            this._navigator.refresh();
            return;
        }
        this._window.refreshNavigator();
    }

    public void setCharset(String string) {
        this._htmlBrowser.setCharset(string);
    }

    public String getCharset() {
        return this._htmlBrowser.getCharset();
    }
}

