/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class TOCParser {
    private static final String TOC_LINE_BRANCH = "BRANCH";
    private static final String TOC_LINE_LEAF = "LEAF";
    private boolean _isTOK = false;

    public TreeRoot parseTOC(String string, boolean bl) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        return this.parseTOC(new BufferedReader(fileReader), bl);
    }

    public TreeRoot parseTOK(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        return this.parseTOK(new BufferedReader(fileReader));
    }

    public TreeRoot parseTOC(URL uRL, boolean bl) throws IOException {
        return this.parseTOC(uRL.openStream(), bl);
    }

    public TreeRoot parseTOK(URL uRL) throws IOException {
        return this.parseTOK(uRL.openStream());
    }

    public TreeRoot parseTOC(URL uRL, String string, boolean bl) throws IOException, MalformedURLException {
        return this.parseTOC(uRL.toString(), string, bl);
    }

    public TreeRoot parseTOC(String string, String string2, boolean bl) throws IOException, MalformedURLException {
        URL uRL = new URL(String.valueOf(string) + string2);
        TreeRoot treeRoot = this.parseTOC(uRL.openStream(), bl);
        treeRoot.setBaseURL(string);
        return treeRoot;
    }

    public TreeRoot parseTOK(URL uRL, String string) throws IOException, MalformedURLException {
        return this.parseTOK(uRL.toString(), string);
    }

    public TreeRoot parseTOK(String string, String string2) throws IOException, MalformedURLException {
        URL uRL = new URL(String.valueOf(string) + string2);
        TreeRoot treeRoot = this.parseTOK(uRL.openStream());
        treeRoot.setBaseURL(string);
        return treeRoot;
    }

    public TreeRoot parseTOC(InputStream inputStream, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parseTOC(bufferedReader, bl);
    }

    public TreeRoot parseTOK(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parseTOK(bufferedReader);
    }

    public TreeRoot parseTOK(BufferedReader bufferedReader) {
        this._isTOK = true;
        return this.parseTOC(bufferedReader, false);
    }

    public TreeRoot parseTOC(BufferedReader bufferedReader, boolean bl) {
        TreeRoot treeRoot = new TreeRoot(bl);
        TreeNode treeNode = treeRoot;
        int n = 0;
        while (true) {
            int n2;
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string = null;
            }
            if (string == null) break;
            if (string.charAt(0) == '#') continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (!stringTokenizer.nextToken().trim().equals("|")) {
                }
            }
            catch (Exception exception) {}
            continue;
            TreeNode treeNode2 = this._parseLine(stringTokenizer);
            if (treeNode2 == null) continue;
            if (n2 == n) {
                treeNode.addChild(treeNode2);
            } else if (n2 == n + 1) {
                if (treeNode.numChildren() > 0) {
                    treeNode = treeNode.getChild(treeNode.numChildren() - 1);
                }
                treeNode.addChild(treeNode2);
            } else {
                if (n2 >= n) continue;
                int n3 = n;
                while (n3 > n2) {
                    treeNode = treeNode.getParent();
                    --n3;
                }
                treeNode.addChild(treeNode2);
            }
            n = n2;
        }
        return treeRoot;
    }

    private TreeNode _parseLine(StringTokenizer stringTokenizer) {
        TreeNode treeNode = null;
        try {
            String string = stringTokenizer.nextToken().trim();
            if (!stringTokenizer.nextToken().trim().equals("|")) {
                return null;
            }
            if (string.equals(TOC_LINE_BRANCH)) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
                    return null;
                }
                String string3 = this._isTOK ? stringTokenizer.nextToken() : stringTokenizer.nextToken().trim();
                treeNode = new TreeNode(string3);
            } else if (string.equals(TOC_LINE_LEAF)) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!string4.equals("|") && !stringTokenizer.nextToken().trim().equals("|")) {
                    return null;
                }
                String string5 = this._isTOK ? stringTokenizer.nextToken() : stringTokenizer.nextToken().trim();
                if (!stringTokenizer.nextToken().trim().equals("|")) {
                    return null;
                }
                String string6 = stringTokenizer.nextToken().trim();
                treeNode = new TreeNode(string5, string6);
            } else {
                treeNode = null;
            }
        }
        catch (Exception exception) {
            treeNode = null;
        }
        return treeNode;
    }
}

