/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.bean.PropertiesEditorPanel;
import sunw.hotjava.bean.SystemProperties;
import sunw.hotjava.misc.Globals;

public class SystemPropertiesEditor
implements PropertyEditor {
    private SystemProperties value;
    private Vector listeners = new Vector();
    private boolean editorShowing = false;

    public void setValue(Object object) {
        this.value = (SystemProperties)object;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return true;
    }

    private boolean userMode() {
        return this.value != null && this.value.editOnlyUserList;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = Globals.localProps.handleGetString("bean.edit.property.text");
        Color color = Globals.mapNamedColor(System.getProperty("bean.edit.property.fg"));
        Color color2 = Globals.mapNamedColor(System.getProperty("bean.edit.property.bg"));
        if (color == null) {
            color = graphics.getColor();
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fill3DRect(0, 0, rectangle.width, rectangle.height, true);
        }
        graphics.setColor(color);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        int n2 = fontMetrics.stringWidth(string);
        int n3 = (rectangle.width - n2) / 2;
        graphics.drawString(string, n3, rectangle.height - n);
    }

    public String getJavaInitializationString() {
        String string = "(new sunw.hotjava.bean.SystemProperties())";
        Hashtable hashtable = this.value.getValues();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string = String.valueOf(string) + "\n                .setValue(" + Globals.javaStringConstant(string2) + ", " + Globals.javaStringConstant(string3) + ")";
        }
        return string;
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        SystemPropertiesEditor systemPropertiesEditor = this;
        synchronized (systemPropertiesEditor) {
            if (this.editorShowing) {
                Label label = new Label(Globals.localProps.handleGetString("bean.customizer.only.one"));
                Object var3_4 = null;
                return label;
            }
            this.editorShowing = true;
        }
        Vector<PropertiesEditorPanel.Field> vector = new Vector<PropertiesEditorPanel.Field>();
        vector.addElement(new PropertiesEditorPanel.Field("http.proxyHost"));
        vector.addElement(new PropertiesEditorPanel.Field("http.proxyPort"));
        vector.addElement(new PropertiesEditorPanel.Field("ftpProxySet", new BooleanConstraint()));
        vector.addElement(new PropertiesEditorPanel.Field("ftpProxyHost"));
        vector.addElement(new PropertiesEditorPanel.Field("ftpProxyPort"));
        vector.addElement(new PropertiesEditorPanel.Field("gopherProxySet", new BooleanConstraint()));
        vector.addElement(new PropertiesEditorPanel.Field("gopherProxyHost"));
        vector.addElement(new PropertiesEditorPanel.Field("gopherProxyPort"));
        if (!this.userMode()) {
            vector.addElement(new PropertiesEditorPanel.Field("fonts.sizes", new FontSizesConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.docfontsize"));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.docfont"));
            vector.addElement(new PropertiesEditorPanel.Field("printfonts.sizes", new FontSizesConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.printfontsize"));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.printfont"));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.docbgcolor", new ColorConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.curcolor", new ColorConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.selcolor", new ColorConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.alttextcolor", new ColorConstraint()));
        }
        vector.addElement(new PropertiesEditorPanel.Field("delayAppletLoading", new BooleanConstraint()));
        vector.addElement(new PropertiesEditorPanel.Field("delayImageLoading", new BooleanConstraint()));
        vector.addElement(new PropertiesEditorPanel.Field("displayBackgroundImages", new BooleanConstraint()));
        if (!this.userMode()) {
            vector.addElement(new PropertiesEditorPanel.Field("anchorStyle"));
            vector.addElement(new PropertiesEditorPanel.Field("http.agent"));
            vector.addElement(new PropertiesEditorPanel.Field("urlpool.expires"));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.enableCookies", new BooleanConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.security.getInterFrameApplets", new BooleanConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("hotjava.security.giveRealFrame", new BooleanConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("trustProxy", new BooleanConstraint()));
            vector.addElement(new PropertiesEditorPanel.Field("package.restrict.access", null, new PackageRestrictConverter()));
            vector.addElement(new PropertiesEditorPanel.Field("package.restrict.definition", null, new PackageRestrictConverter()));
        }
        return new PropertiesEditorPanel(this.value.values, this.value.defaults, vector, this.value.observer, this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public synchronized void editorPanelFinished() {
        this.editorShowing = false;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removeElement(propertyChangeListener);
    }

    private static class FontSizesConstraint
    implements PropertiesEditorPanel.Constraint {
        public String check(String string, String string2) {
            if (string2 == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n");
            int n = 0;
            String string3 = null;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    Integer.valueOf(string3).intValue();
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return String.valueOf(Globals.localProps.handleGetString("bean.edit.fonts.number.format")) + ": " + string3;
            }
            if (n < 13) {
                return Globals.localProps.handleGetString("bean.edit.fonts.too.few");
            }
            return null;
        }

        FontSizesConstraint() {
        }
    }

    private static class ColorConstraint
    implements PropertiesEditorPanel.Constraint {
        public String check(String string, String string2) {
            if (string2 == null) {
                return null;
            }
            Color color = Globals.mapNamedColor(string2);
            if (color == null) {
                return Globals.localProps.handleGetString("bean.edit.bad.color");
            }
            return null;
        }

        ColorConstraint() {
        }
    }

    private static class BooleanConstraint
    implements PropertiesEditorPanel.Constraint {
        public String check(String string, String string2) {
            if (string2 == null) {
                return null;
            }
            if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) {
                return null;
            }
            return Globals.localProps.handleGetString("bean.edit.bad.boolean");
        }

        BooleanConstraint() {
        }
    }

    private static class PackageRestrictConverter
    implements PropertiesEditorPanel.Converter {
        public String get(Hashtable hashtable, String string) {
            string = String.valueOf(string) + ".";
            String string2 = null;
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = (String)hashtable.get(string3);
                    boolean bl = new Boolean(string4);
                    if (!string3.startsWith(string) || !bl) continue;
                    String string5 = string.substring(string.length());
                    if (string2 == null) {
                        string2 = string5;
                        continue;
                    }
                    string2 = String.valueOf(string2) + ", ";
                    string2 = String.valueOf(string2) + string5;
                }
            }
            return string2;
        }

        public void set(Hashtable hashtable, String string, String string2) {
            string = String.valueOf(string) + ".";
            if (string2 == null) {
                string2 = "";
            }
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                Object object;
                Vector<String> vector = new Vector<String>();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string)) continue;
                    vector.addElement(string3);
                }
                int n = 0;
                while (n < vector.size()) {
                    object = (String)vector.elementAt(n);
                    hashtable.remove(object);
                    ++n;
                }
                object = new StringTokenizer(string2, ", \t\n");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    hashtable.put(String.valueOf(string) + string4, "true");
                }
                return;
            }
        }

        PackageRestrictConverter() {
        }
    }
}

