/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.doc.BulletTagItem;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.tags.UL;
import sunw.html.Attributes;

public class LI
extends BulletTagItem
implements ImageObserver,
UpdateClient {
    private Document doc;
    private static final int xOffset = 10;
    private static final int numericRightOffset = 4;
    private static boolean imageLoadingInitiated;
    static final int DISC_IMG_INDEX = 0;
    static final int CIRCLE_IMG_INDEX = 1;
    static final int SQUARE_IMG_INDEX = 2;
    private static Image[] bulletImgs;
    private static String[] bulletNames;
    private static final char[][] romanChars;

    private static synchronized void setupBulletImgs() {
        if (bulletImgs == null) {
            bulletImgs = new Image[3];
            LI.bulletImgs[0] = Globals.getImage("bullet.gif");
            LI.bulletImgs[1] = Globals.getImage("circle.gif");
            LI.bulletImgs[2] = Globals.getImage("square.gif");
        }
    }

    private static Image[] getBulletImgs() {
        if (bulletImgs == null) {
            LI.setupBulletImgs();
        }
        return bulletImgs;
    }

    private static Image getBullet(int n) {
        return LI.getBulletImgs()[n];
    }

    public void updateClient(Object object) {
        Object object2 = Globals.getAwtLock();
        synchronized (object2) {
            Document document = this.doc;
            synchronized (document) {
                int n = this.getIndex();
                this.doc.update(n << 16, n + 1 << 16);
            }
            return;
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Document document;
        Object object;
        if ((n & 3) != 0) {
            object = Globals.getAwtLock();
            synchronized (object) {
                document = this.doc;
                synchronized (document) {
                    n6 = this.getIndex();
                    this.doc.change(n6 << 16, n6 + 1 << 16);
                }
            }
        }
        if ((n & 0x20) != 0) {
            object = Globals.getAwtLock();
            synchronized (object) {
                document = this.doc;
                synchronized (document) {
                    n6 = this.getIndex();
                    this.doc.paint(n6 << 16, n6 + 1 << 16);
                }
            }
        }
        ScreenUpdater.updater.notify((UpdateClient)this, 100L);
        return (n & 0xA0) == 0;
    }

    public synchronized void init(Document document) {
        this.doc = document;
    }

    private int getItemNumber(DocStyle docStyle) {
        int n = 0;
        int n2 = docStyle.next.tag.getIndex() + 1;
        while (n2 <= docStyle.tag.getIndex()) {
            DocItem docItem = docStyle.doc.getItem(n2);
            TagItem tagItem = docItem.getTag(docStyle.doc);
            if (tagItem != null && tagItem.getName().equals("li")) {
                ++n;
            }
            if (docItem.getOffset() > 0) {
                n2 += docItem.getOffset();
            }
            ++n2;
        }
        return n;
    }

    static int bulletNameToType(String string) {
        int n = 0;
        while (n < LI.getBulletImgs().length) {
            if (string.equalsIgnoreCase(bulletNames[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    static int nextBulletType(int n) {
        return (n + 1) % LI.getBulletImgs().length;
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        this.maybeInitiateImageLoading(formatter);
        return super.formatStartTag(formatter, formatState, formatState2);
    }

    public int paintBullet(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        DocStyle docStyle = formatter.displayStyle;
        int n3 = this.style.getLeftIndent();
        if (docStyle == null || docStyle.next == null || docStyle.next.tag == null) {
            return n3;
        }
        String string = docStyle.next.tag.getName();
        if ("ul".equals(string) || "menu".equals(string) || "dir".equals(string)) {
            this.paintUnorderedItem(formatter, graphics, docStyle, n, n2, docLine);
        } else if ("ol".equals(string)) {
            this.paintOrderedItem(graphics, docStyle, n, n2, docLine);
        }
        return n3;
    }

    private void maybeInitiateImageLoading(Formatter formatter) {
        if (!imageLoadingInitiated) {
            Image[] imageArray = LI.getBulletImgs();
            synchronized (imageArray) {
                Container container;
                if (!imageLoadingInitiated && (container = formatter.getParent()) != null) {
                    int n = 0;
                    while (n < LI.getBulletImgs().length) {
                        container.prepareImage(LI.getBullet(n), this);
                        ++n;
                    }
                    imageLoadingInitiated = true;
                }
                return;
            }
        }
    }

    private void paintUnorderedItem(Formatter formatter, Graphics graphics, DocStyle docStyle, int n, int n2, DocLine docLine) {
        Image image = this.selectBulletImage(docStyle);
        int n3 = image.getHeight(this);
        if (n3 >= 0) {
            Color color = formatter.getFormatterBackgroundColor();
            Graphics graphics2 = formatter.getHackGraphics();
            if (Boolean.getBoolean("hotjava.debug.bulletdamage")) {
                Hax.debugln("Clip area is " + graphics.getClipRect());
                Hax.backtrace("break");
            }
            if (graphics2 != null) {
                graphics = graphics2;
            }
            if (formatter.getDocumentState().bg == null) {
                graphics.drawImage(image, n + 10, n2 + 2 + docLine.baseline - n3, color, this);
                return;
            }
            graphics.drawImage(image, n + 10, n2 + 2 + docLine.baseline - n3, this);
        }
    }

    private Image selectBulletImage(DocStyle docStyle) {
        Object object;
        Attributes attributes = docStyle.tag.getAttributes();
        if (attributes != null && (object = attributes.get("type")) != null) {
            return LI.getBullet(LI.bulletNameToType((String)object));
        }
        object = docStyle.next.tag;
        if (object instanceof UL) {
            UL uL = (UL)object;
            return LI.getBullet(uL.bulletType);
        }
        return LI.getBullet(0);
    }

    private void paintOrderedItem(Graphics graphics, DocStyle docStyle, int n, int n2, DocLine docLine) {
        Attributes attributes = docStyle.next.tag.getAttributes();
        boolean bl = false;
        int n3 = 0;
        Attributes attributes2 = docStyle.tag.getAttributes();
        if (attributes2 != null) {
            try {
                n3 = Integer.parseInt(attributes2.get("value"));
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            n3 = this.getItemNumber(docStyle);
            if (attributes != null) {
                int n4 = 1;
                try {
                    n4 = Integer.parseInt(attributes.get("start"));
                }
                catch (Exception exception) {}
                n3 += n4 - 1;
            }
        }
        graphics.setFont(docStyle.font);
        graphics.setColor(docStyle.color);
        String string = String.valueOf(this.formatItemNum(n3, attributes, attributes2)) + ".";
        n += this.style.getLeftIndent() - 4;
        FontMetrics fontMetrics = docStyle.font.getFontMetrics(docStyle);
        n -= fontMetrics.stringWidth(string);
        n = Math.max(0, n);
        graphics.drawString(string, n, n2 + docLine.baseline);
    }

    private String formatItemNum(int n, Attributes attributes, Attributes attributes2) {
        String string;
        String string2;
        String string3 = "1";
        if (attributes != null && (string2 = attributes.get("type")) != null) {
            string3 = string2;
        }
        if (attributes2 != null && (string2 = attributes2.get("type")) != null) {
            string3 = string2;
        }
        boolean bl = false;
        switch (string3.charAt(0)) {
            default: {
                string = String.valueOf(n);
                break;
            }
            case 'A': {
                bl = true;
            }
            case 'a': {
                string = this.formatAlphaNumerals(n);
                break;
            }
            case 'I': {
                bl = true;
            }
            case 'i': {
                string = this.formatRomanNumerals(n);
            }
        }
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    private String formatAlphaNumerals(int n) {
        String string = "";
        string = n > 26 ? String.valueOf(this.formatAlphaNumerals(n / 26)) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
        return string;
    }

    private String formatRomanNumerals(int n) {
        return this.formatRomanNumerals(0, n);
    }

    private String formatRomanNumerals(int n, int n2) {
        if (n2 < 10) {
            return this.formatRomanDigit(n, n2);
        }
        return String.valueOf(this.formatRomanNumerals(n + 1, n2 / 10)) + this.formatRomanDigit(n, n2 % 10);
    }

    private String formatRomanDigit(int n, int n2) {
        String string = "";
        if (n2 == 9) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n + 1][0];
            return string;
        }
        if (n2 == 4) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n][1];
            return string;
        }
        if (n2 >= 5) {
            string = String.valueOf(string) + romanChars[n][1];
            n2 -= 5;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + romanChars[n][0];
            ++n3;
        }
        return string;
    }

    static {
        bulletImgs = null;
        bulletNames = new String[]{"disc", "circle", "square"};
        romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
    }
}

