/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;

public class LWPhonePage
extends LEWizardDataPage
implements ItemListener {
    static final String INC_PHONE = new String("The phone number is incomplete.");
    private static final String INSTRUCTION_TAG = "PHONE_INST";
    private static final String HELP_TAG = "Phone_Number";
    private static final String TITLE_TAG = "PHONE_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    LETextField m_phone;
    Checkbox m_dov;
    Checkbox m_analog;
    Label m_phoneLabel;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource;

    public LWPhonePage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_gbc.insets.bottom = 10;
        this.m_gbc.insets.top = 10;
        this.m_phoneLabel = new Label("Enter the phone number to dial:");
        this.m_panel.add((Component)this.m_phoneLabel, this.m_gbc);
        this.m_phone = new LETextField(13);
        ((TextComponent)this.m_phone).setText(this.m_model.get(LWDataModel.PHONE));
        this.m_phone.setNumeric(true);
        this.m_panel.add((Component)this.m_phone, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_gbc.insets.bottom = 10;
        this.m_gbc.insets.top = 10;
        this.m_analog = new Checkbox("Dial with analog modem service");
        this.m_analog.addItemListener(this);
        this.m_panel.add((Component)this.m_analog, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_dov = new Checkbox("Dial using Data Over Voice");
        this.m_dov.addItemListener(this);
        this.m_panel.add((Component)this.m_dov, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        String string = this.m_phone.getText();
        if (string.length() < 2) {
            this.m_problem = INC_PHONE;
            return false;
        }
        this.m_model.set(LWDataModel.PHONE, string);
        if (this.m_analog.getState()) {
            this.m_model.set(LWDataModel.ANALOG, "on");
            this.m_model.set(LWDataModel.DOV, "off");
        } else {
            this.m_model.set(LWDataModel.ANALOG, "off");
            if (this.m_dov.getState()) {
                this.m_model.set(LWDataModel.DOV, "on");
            } else {
                this.m_model.set(LWDataModel.DOV, "off");
            }
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_analog.getState()) {
            this.m_dov.setEnabled(false);
        } else {
            this.m_dov.setEnabled(true);
        }
        if (this.m_dov.getState()) {
            this.m_analog.setEnabled(false);
            return;
        }
        this.m_analog.setEnabled(true);
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("telephone");
            s_template_keys.add("voice");
            s_template_keys.add("analog");
        }
        return s_template_keys;
    }
}

