/*
 * Decompiled with CFR 0.152.
 */
package com.acme.crypto;

import com.acme.crypto.BlockCipher;
import com.acme.crypto.CryptoUtils;

public class CbcBlockCipher
extends BlockCipher {
    private BlockCipher blockCipher;
    private byte[] iv;
    private byte[] temp;

    public CbcBlockCipher(BlockCipher blockCipher) {
        super(blockCipher.keySize(), blockCipher.blockSize());
        this.blockCipher = blockCipher;
        this.iv = new byte[this.blockSize()];
        CryptoUtils.zeroBlock(this.iv);
        this.temp = new byte[this.blockSize()];
    }

    public void setKey(byte[] byArray) {
        this.blockCipher.setKey(byArray);
    }

    public void setIv(byte[] byArray) {
        CryptoUtils.copyBlock(byArray, this.iv);
    }

    public byte[] setRandomIv() {
        byte[] byArray = new byte[this.blockSize()];
        CryptoUtils.randomBlock(byArray);
        this.setIv(byArray);
        return byArray;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        CryptoUtils.xorBlock(byArray, n, this.iv, 0, this.temp, 0, this.blockSize);
        this.blockCipher.encrypt(this.temp, 0, byArray2, n2);
        CryptoUtils.copyBlock(byArray2, n2, this.iv, 0, this.blockSize);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.blockCipher.decrypt(byArray, n, this.temp, 0);
        CryptoUtils.xorBlock(this.temp, 0, this.iv, 0, byArray2, n2, this.blockSize);
        CryptoUtils.copyBlock(byArray, n, this.iv, 0, this.blockSize);
    }
}

