/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAlarmFacility_RI;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_R;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_RI;
import com.lucent.ra.nms.backend.LECNMFacility_R;
import com.lucent.ra.nms.backend.LECNMFacility_RI;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_R;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LEDebugFacility_RI;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_RI;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEPMListen;
import com.lucent.ra.nms.backend.LESendBuf;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LETokenizer;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.util.MD5;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class LEDSSPortMaster_RI
extends UnicastRemoteObject
implements LEDSSPortMaster_R,
LEObserver {
    public static final String REQ_TIMEOUT = "Request timedout";
    public static final String UNEXPLAINED = "Unexplained error";
    protected static final String TEST_COMMAND = "version";
    protected static final String NC_MORE = "-- Press Return for More -- ";
    protected static FileWriter s_dbgFile;
    protected static PrintWriter s_pw;
    protected static int TIMEOUT_MILLIS;
    String m_id;
    LEAMRouter_RI m_router;
    long m_idle;
    LEAlarmFacility_RI m_alarm;
    LEDebugFacility_RI m_debug;
    LEMonitorFacility_RI m_monitor;
    LEAsyncCmdFacility_RI m_async;
    LECNMFacility_RI m_cnm;
    protected String m_hostname;
    protected String m_username;
    protected String m_password;
    protected boolean m_oneTimePass;
    protected Socket m_pmfd;
    protected LEPMListen m_listener;
    protected OutputStream m_outStream;
    protected LESendBuf m_sbOut;
    protected boolean m_newCommand = false;
    protected boolean m_rebooting = false;
    protected boolean m_reconnecting = false;
    protected boolean m_upgrading = false;
    protected boolean m_error = false;
    protected boolean m_noalarm = false;
    protected LEVector m_threads = new LEVector();
    protected LEVector m_sbInQ;

    public LEDSSPortMaster_RI(String string, String string2, String string3) throws IOException, LEDSSException, RemoteException {
        this.initialize(string, string2, string3);
        this.connectUser();
    }

    public LEDSSPortMaster_RI(String string, String string2, boolean bl) throws IOException, LEDSSException, RemoteException {
        this.initialize(string, null, string2);
        this.m_oneTimePass = bl;
        if (this.m_oneTimePass) {
            this.connectOTP();
            return;
        }
        this.connect();
    }

    public LEDSSPortMaster_RI(String string, String string2) throws IOException, LEDSSException, RemoteException {
        this.initialize(string, null, string2);
        this.connect();
    }

    public LEDSSPortMaster_RI() throws RemoteException {
        this.initialize();
    }

    public String getResourceID() throws RemoteException {
        return this.m_id;
    }

    public String getHostname() throws RemoteException {
        return this.m_hostname;
    }

    public String getUsername() throws RemoteException {
        return this.m_username;
    }

    public String getPassword() throws RemoteException {
        return this.m_password;
    }

    public boolean supportsEntities() throws RemoteException {
        return this.m_newCommand;
    }

    public void setPassword(String string) throws RemoteException {
        this.m_password = string;
    }

    public boolean isConnected() throws RemoteException {
        if (this.m_rebooting) {
            return false;
        }
        return this.m_pmfd != null;
    }

    public void disconnect() throws RemoteException {
        this.disconnect(2);
    }

    public boolean reconnecting() throws RemoteException {
        return this.m_reconnecting;
    }

    public boolean reconnect() throws IOException, LEDSSException, RemoteException {
        if (this.isConnected()) {
            return true;
        }
        this.m_reconnecting = true;
        try {
            if (this.m_oneTimePass) {
                this.connectOTP();
            } else if (this.m_username != null) {
                this.connectUser();
            } else {
                this.connect();
            }
        }
        catch (IOException iOException) {
            this.m_reconnecting = false;
            throw iOException;
        }
        catch (LEDSSException lEDSSException) {
            this.m_reconnecting = false;
            throw lEDSSException;
        }
        this.m_reconnecting = false;
        return this.isConnected();
    }

    public void startUpgrade() throws RemoteException {
        this.m_upgrading = true;
        LEStatusMessage lEStatusMessage = new LEStatusMessage(5);
        this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
    }

    public void stopUpgrade() throws RemoteException {
        this.m_upgrading = false;
        if (this.isConnected()) {
            LEStatusMessage lEStatusMessage = new LEStatusMessage(6);
            this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
        }
    }

    public boolean upgrading() throws RemoteException {
        return this.m_upgrading;
    }

    public LEAlarmFacility_R getAlarmFacility() throws RemoteException {
        block2: {
            if (this.m_alarm != null || !this.m_newCommand || this.m_noalarm) break block2;
            try {
                this.m_alarm = new LEAlarmFacility_RI(this);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return this.m_alarm;
    }

    public LEDebugFacility_R getDebugFacility() throws RemoteException {
        block2: {
            if (this.m_debug != null || !this.m_newCommand) break block2;
            try {
                this.m_debug = new LEDebugFacility_RI(this);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return this.m_debug;
    }

    public LEMonitorFacility_R getMonitorFacility() throws RemoteException {
        block2: {
            if (this.m_monitor != null || !this.m_newCommand) break block2;
            try {
                this.m_monitor = new LEMonitorFacility_RI(this);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return this.m_monitor;
    }

    public LEAsyncCmdFacility_R getAsyncFacility() throws RemoteException {
        block2: {
            if (this.m_async != null || !this.m_newCommand) break block2;
            try {
                this.m_async = new LEAsyncCmdFacility_RI(this);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return this.m_async;
    }

    public LECNMFacility_R getCNMFacility() throws RemoteException {
        block2: {
            if (this.m_cnm != null || !this.m_newCommand) break block2;
            try {
                this.m_cnm = new LECNMFacility_RI(this);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return this.m_cnm;
    }

    public LEPMCommand execute(String string) throws RemoteException {
        return this.execute(string, TIMEOUT_MILLIS);
    }

    public LEPMCommand execute(String string, int n) throws RemoteException {
        LEPMCommand lEPMCommand = new LEPMCommand(string);
        int n2 = 0;
        if (string != null) {
            n2 = string.length();
        }
        if (n2 == 0) {
            lEPMCommand.setStatus(false);
            return lEPMCommand;
        }
        LEDebug.getLog().logln(40, "Executing: " + string);
        if (LEPMCommand.IsReboot(string)) {
            return this.reboot(lEPMCommand);
        }
        return this.execute(lEPMCommand, n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LEVector getTOC(int var1_1) throws RemoteException {
        var2_2 = null;
        var3_3 = Integer.toString(var1_1);
        var4_4 = this.send((byte)22, (short)var3_3.length(), var3_3, true);
        var5_5 = var4_4.successful();
        if (var5_5) {
            var2_2 = new LEVector();
            var6_6 = var4_4.getStreamTok();
            var7_7 = true;
            try lbl-1000:
            // 8 sources

            {
                block8: while (var5_5 && var7_7) {
                    var8_8 = var6_6.getNextInt();
                    switch (var8_8) {
                        case 0x1D0000: {
                            var6_6.getNextQuotedString();
                            ** break;
                        }
                        case 12: {
                            var6_6.getNextQuotedString();
                            ** break;
                        }
                        case 10: {
                            var2_2.addElement(var6_6.getNextQuotedString());
                            ** break;
                        }
                        case 65535: {
                            if (var6_6.getNextInt() == 1) {
                                var4_4 = this.recv(true);
                                var5_5 = var4_4.successful();
                                if (!var5_5) continue block8;
                                var6_6 = var4_4.getStreamTok();
                                ** break;
                            }
                            var7_7 = false;
                            ** break;
                        }
                    }
                    LEDebug.getLog().logln(20, "Bad TOC attribute: " + var8_8 + ", " + var6_6.getNextQuotedString());
                }
            }
            catch (Exception var9_9) {
                LEDebug.getLog().logln(20, var9_9);
            }
        }
        this.done();
        return var2_2;
    }

    public long debug(int n, int n2) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        stringBuffer.append(" 1");
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)24, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public long debug(int n, int n2, int n3) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(' ');
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(459);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        stringBuffer.append(' ');
        stringBuffer.append(275);
        stringBuffer.append(' ');
        stringBuffer.append(n3);
        stringBuffer.append(' ');
        stringBuffer.append(460);
        stringBuffer.append(' ');
        stringBuffer.append(" 1");
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)24, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killDebug(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)24, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long delta(int n, int n2) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        try {
            LESendResponse lESendResponse = this.send((byte)25, (short)string.length(), string, false);
            if (!lESendResponse.successful()) {
                throw this.getLEDSSException(lESendResponse);
            }
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public long delta(int n, int n2, int n3) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(275);
        stringBuffer.append(" ");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        stringBuffer.append(278);
        stringBuffer.append(" ");
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        try {
            LESendResponse lESendResponse = this.send((byte)25, (short)string.length(), string, false);
            if (!lESendResponse.successful()) {
                throw this.getLEDSSException(lESendResponse);
            }
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killDelta(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)25, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long alarm(int n) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(" 1");
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void clearAlarm(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 2");
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public void killAlarm(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)29, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long monitor(int n, int n2) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)23, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public long monitor(int n, int n2, int n3) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(275);
        stringBuffer.append(" ");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        stringBuffer.append(278);
        stringBuffer.append(" ");
        stringBuffer.append(n2);
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)23, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public long monitor(int n, int n2, String string) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(553);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(278);
        stringBuffer.append(" ");
        stringBuffer.append(n2);
        String string2 = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)23, (short)string2.length(), string2, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killMonitor(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)23, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long async(int n, int n2, String string) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(89);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        String string2 = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)36, (short)string2.length(), string2, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killAsync(long l) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(88);
        stringBuffer.append(" ");
        stringBuffer.append(Long.toString(l));
        LESendResponse lESendResponse = this.send((byte)36, (short)stringBuffer.length(), stringBuffer.toString(), false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public long cnm(int n) throws LEDSSException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(277);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        String string = new String(stringBuffer);
        LESendResponse lESendResponse = this.send((byte)38, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
        try {
            lESendResponse.getStreamTok().getNextString();
            long l = lESendResponse.getStreamTok().getNextLong();
            return l;
        }
        catch (IOException iOException) {
            throw new LEDSSPMOpFailureException(iOException.getMessage());
        }
    }

    public void killCNM(long l) throws LEDSSException, RemoteException {
        String string = new String(String.valueOf(Long.toString(l)) + " 0");
        LESendResponse lESendResponse = this.send((byte)38, (short)string.length(), string, false);
        if (!lESendResponse.successful()) {
            throw this.getLEDSSException(lESendResponse);
        }
    }

    public LESendResponse send(byte by, short s, String string, boolean bl) throws RemoteException {
        return this.send(by, s, string, bl, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte by, short s, String string, boolean bl, int n) throws RemoteException {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[s + 1];
        System.arraycopy(byArray, 0, byArray2, 0, s);
        short s2 = s;
        s = (short)(s2 + 1);
        byArray2[s2] = 0;
        return this.send(by, s, byArray2, bl, n);
    }

    public LESendResponse send(byte by, short s, byte[] byArray, boolean bl) throws RemoteException {
        return this.send(by, s, byArray, bl, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte by, short s, byte[] byArray, boolean bl, int n) throws RemoteException {
        this.send(by, s, byArray);
        return this.recv(bl, n);
    }

    public synchronized void send(byte by, short s, byte[] byArray) throws RemoteException {
        Thread thread = Thread.currentThread();
        this.m_threads.addElement(thread);
        while (thread != (Thread)this.m_threads.firstElement()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        this.m_idle = System.currentTimeMillis();
        this.m_sbInQ.removeAllElements();
        this.m_sbOut.reset();
        this.m_sbOut.m_idByte = (byte)101;
        this.m_sbOut.m_opCode = by;
        this.m_sbOut.m_sendLength = s;
        System.arraycopy(byArray, 0, this.m_sbOut.m_data, 0, s);
        try {
            if (this.m_outStream != null) {
                this.m_outStream.write(this.m_sbOut.getBytes(), 0, s + 4);
                this.m_outStream.flush();
                this.dumpLogV("Sent: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbOut.m_opCode));
                LEDSSPortMaster_RI.dumpSRMsg("Sent: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbOut.m_opCode));
                LEDSSPortMaster_RI.dumpSRMsg(this.m_sbOut.toString());
                LEDSSPortMaster_RI.dumpSRMsg("End send");
                LEDSSPortMaster_RI.dumpSRMsg("");
                return;
            }
            this.update(null, null);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.update(null, exception);
            return;
        }
    }

    public LESendResponse recv(boolean bl) throws RemoteException {
        return this.recv(bl, TIMEOUT_MILLIS);
    }

    public synchronized LESendResponse recv(boolean bl, int n) throws RemoteException {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        boolean bl2 = false;
        while (!bl2 && this.m_sbInQ.size() == 0) {
            l2 = System.currentTimeMillis() - l;
            try {
                this.wait((long)n - l2);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            if (System.currentTimeMillis() - l < (long)n) continue;
            bl2 = true;
        }
        LESendResponse lESendResponse = null;
        if (this.m_sbInQ.size() > 0) {
            Object object = this.m_sbInQ.removeElementAt(0);
            if (object instanceof LESendResponse) {
                lESendResponse = (LESendResponse)object;
            } else if (object instanceof Exception) {
                lESendResponse = new LESendResponse((Exception)object);
            } else {
                lESendResponse = new LESendResponse();
                lESendResponse.setTimeout(true);
            }
        } else {
            lESendResponse = new LESendResponse();
            lESendResponse.setTimeout(true);
        }
        lESendResponse.checkSuccess();
        if (lESendResponse.successful()) {
            this.dumpLogV("Received: " + LEDSSPortMaster_RI.GetOpCodeString(lESendResponse.m_opCode));
            LEDSSPortMaster_RI.dumpSRMsg("Received: " + LEDSSPortMaster_RI.GetOpCodeString(lESendResponse.m_opCode));
            LEDSSPortMaster_RI.dumpSRMsg(lESendResponse.toString());
            LEDSSPortMaster_RI.dumpSRMsg("End Receive");
            LEDSSPortMaster_RI.dumpSRMsg("");
        } else if (lESendResponse.timedout()) {
            this.dumpLogV("Received: TIMEOUT");
            LEDSSPortMaster_RI.dumpSRMsg("Received: TIMEOUT");
            this.m_error = true;
            this.disconnect();
        } else if (lESendResponse.getException() != null) {
            this.dumpLogV("Received: EXCEPTION " + lESendResponse.getException().toString());
            LEDSSPortMaster_RI.dumpSRMsg("Received: EXCEPTION " + lESendResponse.getException().toString());
        }
        if (!bl) {
            this.done();
        }
        return lESendResponse;
    }

    public synchronized void done() throws RemoteException {
        Thread thread = Thread.currentThread();
        if (this.m_threads.size() == 0) {
            this.dumpLogV("Done called on empty queue: " + thread.getName() + ", " + this.m_threads.toString());
            return;
        }
        if (thread.equals(this.m_threads.firstElement())) {
            this.m_threads.removeElementAt(0);
        } else {
            this.dumpLogV("Done called by wrong thread: " + thread.getName() + ", " + this.m_threads.toString());
        }
        this.notifyAll();
    }

    public synchronized void update(LEObservable lEObservable, Object object) {
        this.m_sbInQ.addElement(object);
        this.notifyAll();
        if (object instanceof IOException) {
            this.m_error = true;
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {}
            Exception exception = (Exception)object;
            LEStatusMessage lEStatusMessage = new LEStatusMessage(3, exception);
            this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
            return;
        }
        if (object instanceof Exception) {
            this.m_error = true;
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {}
            Exception exception = (Exception)object;
            LEDSSException lEDSSException = new LEDSSException(exception.getMessage());
            LEStatusMessage lEStatusMessage = new LEStatusMessage(3, lEDSSException);
            this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
        }
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.m_idle;
    }

    public void finalize() {
        try {
            this.disconnect();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    void connectUser() throws IOException, LEDSSException {
        this.preConnect();
        try {
            if (this.m_username.equals("!root")) {
                this.connect();
                return;
            }
            byte[] byArray = new byte[this.m_password.length() + 65];
            byte[] byArray2 = this.m_username.getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = this.m_password.getBytes();
            System.arraycopy(byArray2, 0, byArray, 64, byArray2.length);
            LESendResponse lESendResponse = this.send((byte)20, (short)byArray.length, byArray, false);
            if (lESendResponse.successful()) {
                this.postConnect();
                return;
            }
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        catch (UnknownHostException unknownHostException) {
            String string = "Unknown host: " + this.m_hostname;
            this.disconnect();
            throw new UnknownHostException(string);
        }
        catch (LEDSSPMOpFailureException lEDSSPMOpFailureException) {
            String string = lEDSSPMOpFailureException.getMessage();
            this.disconnect();
            throw new LEDSSPMAuthFailureException(string);
        }
    }

    void connectOTP() throws IOException, LEDSSException {
        this.preConnect();
        LESendResponse lESendResponse = this.send((byte)2, (short)this.m_password.length(), this.m_password, false);
        if (!lESendResponse.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    void connect() throws IOException, LEDSSException {
        this.preConnect();
        byte[] byArray = new byte[]{0};
        LESendResponse lESendResponse = this.send((byte)18, (short)1, byArray, false);
        if (!lESendResponse.successful()) {
            this.connectOTP();
            return;
        }
        MD5 mD5 = new MD5();
        LETokenizer lETokenizer = lESendResponse.getStreamTok();
        lETokenizer.getNextRawBytes(1);
        byte[] byArray2 = lETokenizer.getNextRawBytes(16);
        mD5.update(this.m_password);
        mD5.update(byArray2);
        mD5.update("Command> ");
        byArray2 = mD5.digest();
        lESendResponse = this.send((byte)19, (short)16, byArray2, false);
        if (!lESendResponse.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    LEPMCommand reboot(LEPMCommand lEPMCommand) {
        LEDebug.getLog().logln(40, "** REBOOTING **");
        this.m_rebooting = true;
        boolean bl = false;
        try {
            lEPMCommand = this.execute(lEPMCommand);
            if (!lEPMCommand.getStatus()) {
                this.m_rebooting = false;
                return lEPMCommand;
            }
        }
        catch (RemoteException remoteException) {
            this.m_rebooting = false;
            lEPMCommand.setStatus(false);
            return lEPMCommand;
        }
        this.disconnect(4);
        if (!this.waitAndReconnect() && !this.waitAndReconnect()) {
            bl = true;
        }
        if (bl) {
            LEStatusMessage lEStatusMessage = new LEStatusMessage(2);
            this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
        }
        return lEPMCommand;
    }

    boolean waitAndReconnect() {
        boolean bl = false;
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
            bl = this.reconnect();
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    void disconnect(int n) {
        boolean bl = false;
        try {
            if (this.m_alarm != null) {
                if (!this.m_error) {
                    this.m_alarm.shutdown();
                }
                this.m_alarm = null;
            }
            if (this.m_debug != null) {
                if (!this.m_error) {
                    this.m_debug.shutdown();
                }
                this.m_debug = null;
            }
            if (this.m_monitor != null) {
                if (!this.m_error) {
                    this.m_monitor.shutdown();
                }
                this.m_monitor = null;
            }
            if (this.m_async != null) {
                if (!this.m_error) {
                    this.m_async.shutdown();
                }
                this.m_async = null;
            }
            if (this.m_cnm != null) {
                if (!this.m_error) {
                    this.m_cnm.shutdown();
                }
                this.m_cnm = null;
            }
            if (this.m_pmfd != null) {
                bl = true;
                if (this.m_listener != null) {
                    this.m_listener.shutdown();
                }
                this.m_listener = null;
                this.m_outStream.close();
                this.m_pmfd.close();
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_outStream = null;
        this.m_pmfd = null;
        this.m_rebooting = false;
        this.m_error = false;
        if (bl) {
            LEStatusMessage lEStatusMessage = new LEStatusMessage(n);
            this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
        }
    }

    protected void postConnect() throws LEDSSException {
        this.testNewCommand();
        LEStatusMessage lEStatusMessage = new LEStatusMessage(1);
        this.m_router.distribute(this.m_id, "STATUS", lEStatusMessage);
    }

    protected void testNewCommand() {
        try {
            LESendResponse lESendResponse = this.send((byte)33, (short)TEST_COMMAND.length(), TEST_COMMAND, true);
            if (lESendResponse.successful()) {
                this.recv(true);
                this.m_newCommand = true;
                String string = lESendResponse.toString();
                if (string.indexOf("ComOS 3.8") > -1) {
                    this.m_noalarm = true;
                }
            } else {
                this.m_newCommand = false;
            }
            this.done();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected LEPMCommand execute(LEPMCommand lEPMCommand) throws RemoteException {
        return this.execute(lEPMCommand, TIMEOUT_MILLIS);
    }

    protected LEPMCommand execute(LEPMCommand lEPMCommand, int n) throws RemoteException {
        String string;
        LESendResponse lESendResponse;
        boolean bl = false;
        String string2 = lEPMCommand.getCommand();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_newCommand) {
            lESendResponse = this.send((byte)33, (short)string2.length(), string2, true, n);
            if (lESendResponse.successful()) {
                while (!bl && lESendResponse.m_opCode != 9) {
                    string = new String(lESendResponse.m_data, 0, (int)lESendResponse.m_sendLength);
                    int n2 = string.indexOf(NC_MORE);
                    if (n2 > -1) {
                        string = string.substring(0, n2);
                    }
                    stringBuffer.append(string);
                    lESendResponse = this.recv(true, n);
                    if (lESendResponse.successful()) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
            this.done();
        } else {
            lESendResponse = this.send((byte)4, (short)string2.length(), string2, false, n);
            if (!lESendResponse.successful()) {
                bl = true;
            }
        }
        if (lESendResponse.timedout()) {
            lEPMCommand.setResult("Connection lost");
        } else if (lESendResponse.getException() != null) {
            lEPMCommand.setResult("Connection lost");
        } else {
            lEPMCommand.setResult(new String(stringBuffer));
        }
        if (bl) {
            lEPMCommand.setStatus(false);
            this.m_router.distribute(this.m_id, "CMD_FAILED", lEPMCommand);
        } else {
            string = LEPMCommand.IsSetPassword(string2);
            if (string != null) {
                this.setPassword(string);
            }
        }
        return lEPMCommand;
    }

    private void preConnect() throws IOException {
        if (this.m_pmfd == null) {
            try {
                this.m_pmfd = new Socket(this.m_hostname, 1643);
            }
            catch (UnknownHostException unknownHostException) {
                String string = "Unknown host: " + this.m_hostname;
                this.disconnect();
                throw new UnknownHostException(string);
            }
            this.m_listener = new LEPMListen(new DataInputStream(this.m_pmfd.getInputStream()), this.m_id);
            this.m_listener.addObserver(this);
            this.m_listener.start();
            this.m_outStream = this.m_pmfd.getOutputStream();
        }
    }

    protected static String GetOpCodeString(int n) {
        String string;
        switch (n) {
            case 2: {
                string = "NC_INIT";
                break;
            }
            case 3: {
                string = "NC_DISC";
                break;
            }
            case 4: {
                string = "NC_COMMAND";
                break;
            }
            case 5: {
                string = "NC_DOWNLOAD";
                break;
            }
            case 6: {
                string = "NC_DOWNDATA";
                break;
            }
            case 7: {
                string = "NC_RENAME";
                break;
            }
            case 8: {
                string = "NC_STATUS";
                break;
            }
            case 9: {
                string = "NC_REPLY";
                break;
            }
            case 10: {
                string = "NC_RAW_WRITE";
                break;
            }
            case 11: {
                string = "NC_IOSTAT";
                break;
            }
            case 12: {
                string = "NC_UPLOAD";
                break;
            }
            case 13: {
                string = "NC_UPDATA";
                break;
            }
            case 14: {
                string = "NC_CDATA";
                break;
            }
            case 15: {
                string = "NC_RESET";
                break;
            }
            case 16: {
                string = "NC_NETSTATUS";
                break;
            }
            case 17: {
                string = "NC_TABLE";
                break;
            }
            case 18: {
                string = "NC_CHALLENGE";
                break;
            }
            case 19: {
                string = "NC_MD5_PASS";
                break;
            }
            case 20: {
                string = "NC_USER_PASS";
                break;
            }
            case 21: {
                string = "NC_BK";
                break;
            }
            case 22: {
                string = "NC_TOC";
                break;
            }
            case 23: {
                string = "NC_MONITOR";
                break;
            }
            case 25: {
                string = "NC_DELTA";
                break;
            }
            case 29: {
                string = "NC_ALARMS";
                break;
            }
            case 30: {
                string = "NC_ALARMMSG";
                break;
            }
            case 24: {
                string = "NC_DEBUG";
                break;
            }
            case 26: {
                string = "NC_MONMESSAGE";
                break;
            }
            case 27: {
                string = "NC_DBGMESSAGE";
                break;
            }
            case 28: {
                string = "NC_DELTAMSG";
                break;
            }
            case 31: {
                string = "NC_ENTITY";
                break;
            }
            case 32: {
                string = "NC_ENTITYMSG";
                break;
            }
            case 33: {
                string = "NC_NEWCOMMAND";
                break;
            }
            case 34: {
                string = "NC_NEWCMDMSG";
                break;
            }
            case 35: {
                string = "NC_AUTHENTICATE";
                break;
            }
            case 36: {
                string = "NC_ASYNC";
                break;
            }
            case 37: {
                string = "NC_ASYNCMSG";
                break;
            }
            case 38: {
                string = "NC_CNM";
                break;
            }
            case 39: {
                string = "NC_CNMMSG";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    protected void dumpLogV(String string) {
        LEDebug.getLog().logln(40, string);
    }

    protected void dumpLog(int n, String string) {
        LEDebug.getLog().logln(n, string);
    }

    public static void dumpSRMsg(String string) {
        if (s_pw != null && LEDebug.getLog().shouldLog(30)) {
            try {
                s_pw.println(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    protected synchronized void initialize() {
        this.m_router = LEAMRouter_RI.GetAMRouter();
        String string = this.m_username == null ? "!root" : this.m_username;
        this.m_id = LEResourceID.CreatePM_ID(this.m_hostname, string);
        this.m_idle = System.currentTimeMillis();
        this.m_sbOut = new LESendBuf();
        this.m_sbOut.setSize(2048);
        this.m_sbInQ = new LEVector(100);
        if (s_dbgFile == null) {
            try {
                String string2 = LEAppInfo.getUserAppDirPath("sendrecv.txt");
                File file = new File(string2);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
                return;
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
                return;
            }
        }
    }

    protected synchronized void initialize(String string, String string2, String string3) {
        this.m_hostname = string;
        this.m_username = string2;
        this.m_password = string3;
        this.initialize();
    }

    LEDSSException getLEDSSException(LESendResponse lESendResponse) {
        if (lESendResponse.timedout()) {
            return new LEDSSPMOpFailureException(REQ_TIMEOUT);
        }
        Exception exception = lESendResponse.getException();
        if (exception != null) {
            return new LEDSSPMOpFailureException(exception.getMessage());
        }
        return new LEDSSPMOpFailureException(UNEXPLAINED);
    }

    static {
        TIMEOUT_MILLIS = 60000;
    }
}

