/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEUUEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class LETftpUpgrade {
    public static final int TIMEOUT = 120000;
    public static final int BLOCK_COUNT = 4;
    public static final short WRITESIZE = 256;
    public static final String DATAFILE_START = "file ";
    public static final String DATAFILE_END = "end";
    LEStatusManager m_status;
    LEDSSPortMaster m_dss;
    BufferedReader m_reader;
    byte[] m_send = new byte[256];
    byte[] m_decode = new byte[45];
    String m_file;
    short m_count;
    int m_blocks;
    int m_filesize;

    public static boolean IsTftpFile(File file) throws IOException {
        boolean bl = true;
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        while (bl && n < 512) {
            int n2 = fileInputStream.read();
            bl = LETftpUpgrade.IsPrintable(n2);
            ++n;
        }
        return bl;
    }

    public static boolean IsPrintable(int n) {
        return n == 10 || n == 13 || n == 9 || n == 10 || n == 13 || n > 31 && n < 127;
    }

    public LETftpUpgrade(LEDSSPortMaster lEDSSPortMaster, BufferedReader bufferedReader, LEStatusManager lEStatusManager) {
        this.m_dss = lEDSSPortMaster;
        this.m_reader = bufferedReader;
        this.m_status = lEStatusManager;
    }

    public void doUpgrade() throws LEDSSException {
        this.m_dss.startUpgrade();
        boolean bl = false;
        try {
            String string = this.m_reader.readLine();
            while (string != null) {
                int n;
                if (bl) {
                    if (string.startsWith(DATAFILE_END)) {
                        this.flush();
                        this.send((byte)6, (short)0, this.m_send);
                        LEDebug.getLog().logln(40, "EOF: " + this.m_file + " " + this.m_filesize + " bytes");
                        this.m_status.setStatus("Finished file " + this.m_file, 0);
                        bl = false;
                    } else {
                        n = LEUUEncoder.UUDecode(string, this.m_decode);
                        this.queue(this.m_decode, n);
                    }
                } else {
                    n = string.length();
                    char c = n > 0 ? string.charAt(0) : (char)'\u0000';
                    if (c == '#' || c == '!') {
                        String string2 = string.substring(1);
                        if (string2.length() > 0) {
                            this.m_status.setStatus(string2);
                        }
                        LEDebug.getLog().logln(40, "Comment: " + string2);
                    } else if (string.startsWith(DATAFILE_START)) {
                        int n2 = DATAFILE_START.length();
                        int n3 = string.length();
                        short s = 0;
                        int n4 = n2;
                        while (n4 < n3) {
                            short s2 = s;
                            s = (short)(s2 + 1);
                            this.m_decode[s2] = (byte)string.charAt(n4);
                            ++n4;
                        }
                        short s3 = s;
                        s = (short)(s3 + 1);
                        this.m_decode[s3] = 0;
                        this.send((byte)5, s, this.m_decode);
                        this.m_file = string.substring(n2);
                        LEDebug.getLog().logln(40, string);
                        this.m_status.setStatus("Downloading file " + this.m_file);
                        bl = true;
                        this.m_blocks = 0;
                        this.m_filesize = 0;
                    } else if (n > 0) {
                        this.m_status.setStatus(string);
                        LEDebug.getLog().logln(40, "Command: " + string);
                        this.m_dss.execute(string, 120000);
                    }
                }
                string = this.m_reader.readLine();
            }
            if (bl) {
                this.flush();
                this.send((byte)6, (short)0, this.m_send);
                throw new LEDSSException("Upgrade file missing end statement");
            }
        }
        catch (LEDSSException lEDSSException) {
            this.m_dss.stopUpgrade();
            throw lEDSSException;
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
            String string = "Upgrade failed";
            if (iOException.getMessage() != null) {
                string = String.valueOf(string) + ": " + iOException.getMessage();
            }
            this.m_dss.stopUpgrade();
            throw new LEDSSException(iOException, string);
        }
        this.m_dss.stopUpgrade();
    }

    void queue(byte[] byArray, int n) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Queue'ing more data: " + n);
        if (this.m_count + n > 256) {
            ++this.m_blocks;
            if (this.m_blocks % 4 == 0) {
                this.m_status.setStatus(this.m_blocks / 4);
            }
            short s = (short)(this.m_count + n - 256);
            System.arraycopy(byArray, 0, this.m_send, this.m_count, 256 - this.m_count);
            this.send((byte)6, (short)256, this.m_send);
            System.arraycopy(byArray, 256 - this.m_count, this.m_send, 0, s);
            this.m_count = s;
        } else {
            System.arraycopy(byArray, 0, this.m_send, this.m_count, n);
            this.m_count = (short)(this.m_count + n);
        }
        this.m_filesize += n;
    }

    void flush() throws LEDSSException, IOException {
        if (this.m_count > 0) {
            this.send((byte)6, this.m_count, this.m_send);
        }
        this.m_count = 0;
    }

    void send(byte by, short s, byte[] byArray) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster_RI.GetOpCodeString(by) + " Length: " + Integer.toString(s) + " bytes");
        LESendResponse lESendResponse = this.m_dss.send(by, s, byArray, false, 120000);
        if (!lESendResponse.successful()) {
            LEDebug.getLog().logln(40, "TFTP Upgrade: Data Send Failed");
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster_RI.GetOpCodeString(by));
        }
        LEDebug.getLog().logln(40, "TFTP Upgrade: Data Send Succeeded");
    }
}

