/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class LEDataSpecFactory {
    public static final String SPEC_FILE = "pmspec.cfg";
    public static final String SPEC_SUFFIX = "spec.cfg";
    public static final String DEP_STRING = "#";
    public static final String BLANK = "";
    protected static final char s_TOKEN_SEP = ',';
    protected static final char s_COMMENT = '#';
    protected static final char s_DEF_START = '{';
    protected static final char s_DEF_END = '}';
    protected static final char s_VALUE_SEP = '=';
    protected static final char s_ENUM_SEP = '|';
    protected static final char s_DEPENDENCY = '#';
    protected Hashtable m_specs = new Hashtable();
    static LEDataSpecFactory s_factory = null;

    public static LEDataSpecFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEDataSpecFactory();
        }
        return s_factory;
    }

    public static synchronized LEDataSpec GetPortMasterSpec() throws IOException {
        return LEDataSpecFactory.GetFactory().getPortMasterSpec();
    }

    public static synchronized LEDataSpec GetSpec(String string) throws IOException {
        return LEDataSpecFactory.GetFactory().getSpec(string);
    }

    public synchronized LEDataSpec getPortMasterSpec() throws IOException {
        LEDataSpec lEDataSpec = (LEDataSpec)this.m_specs.get(SPEC_FILE);
        if (lEDataSpec == null) {
            BufferedReader bufferedReader = LEResource.GetText(SPEC_FILE);
            if (bufferedReader == null) {
                throw new IOException("Missing file: pmspec.cfg");
            }
            lEDataSpec = LEDataSpecFactory.createFrom(bufferedReader);
            this.m_specs.put(SPEC_FILE, lEDataSpec);
        }
        return lEDataSpec;
    }

    public synchronized LEDataSpec getSpec(String string) throws IOException {
        String string2 = String.valueOf(string) + SPEC_SUFFIX;
        LEDataSpec lEDataSpec = (LEDataSpec)this.m_specs.get(string2);
        if (lEDataSpec == null) {
            BufferedReader bufferedReader = LEResource.GetText(string2);
            if (bufferedReader == null) {
                throw new IOException("Missing file: " + string2);
            }
            lEDataSpec = LEDataSpecFactory.createFrom(bufferedReader);
            this.m_specs.put(string2, lEDataSpec);
        }
        return lEDataSpec;
    }

    public static synchronized LEDataSpec createFrom(BufferedReader bufferedReader) throws IOException {
        LEDataSpec lEDataSpec;
        LEDataSpec lEDataSpec2 = lEDataSpec = new LEDataSpec(BLANK, "PortMaster", "LEConfig", null);
        Vector vector = null;
        Stack<LEDataSpec> stack = new Stack<LEDataSpec>();
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = string.length();
            if (n == 0) {
                string = bufferedReader.readLine();
                continue;
            }
            int n2 = LEDataSpecFactory.eatSpace(string, 0);
            if (n2 >= n) {
                string = bufferedReader.readLine();
                continue;
            }
            switch (string.charAt(n2)) {
                case '{': {
                    stack.push(lEDataSpec2);
                    if (vector == null) break;
                    LEDataSpec lEDataSpec3 = LEDataSpecFactory.createSpec(vector, true);
                    vector = null;
                    if (lEDataSpec3 == null) break;
                    lEDataSpec2.addSpec(lEDataSpec3);
                    lEDataSpec2 = lEDataSpec3;
                    break;
                }
                case '}': {
                    LEDataSpec lEDataSpec3;
                    if (vector != null) {
                        lEDataSpec3 = LEDataSpecFactory.createSpec(vector, false);
                        vector = null;
                        if (lEDataSpec3 != null) {
                            lEDataSpec2.addSpec(lEDataSpec3);
                        }
                    }
                    lEDataSpec2 = (LEDataSpec)stack.pop();
                    break;
                }
                default: {
                    LEDataSpec lEDataSpec3;
                    if (vector != null && (lEDataSpec3 = LEDataSpecFactory.createSpec(vector, false)) != null) {
                        lEDataSpec2.addSpec(lEDataSpec3);
                    }
                    if ((vector = LEDataSpecFactory.tokenize(string)) != null && vector.size() >= 3) break;
                    LEDebug.getLog().logln(20, "Bad spec: " + string);
                    vector = null;
                }
                case '#': 
            }
            string = bufferedReader.readLine();
        }
        return lEDataSpec;
    }

    protected static LEDataSpec createSpec(Vector vector, boolean bl) {
        LEDataSpec lEDataSpec = null;
        try {
            String string = (String)vector.elementAt(0);
            String string2 = (String)vector.elementAt(1);
            String string3 = (String)vector.elementAt(2);
            Hashtable hashtable = LEDataSpecFactory.extractAttributes(vector, 3);
            lEDataSpec = new LEDataSpec(string, string2, string3, hashtable);
        }
        catch (NoSuchElementException noSuchElementException) {
            LEDebug.getLog().logln(20, noSuchElementException);
            lEDataSpec = null;
        }
        return lEDataSpec;
    }

    protected static Vector tokenize(String string) {
        Vector<String> vector = null;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            String string2;
            int n3 = (n = LEDataSpecFactory.eatSpace(string, n)) < n2 ? string.indexOf(44, n) : -1;
            if (n3 > -1) {
                string2 = string.substring(n, n3);
                n = n3 + 1;
            } else if (n < n2) {
                string2 = string.substring(n, n2);
                n = n2;
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(string2);
        }
        return vector;
    }

    protected static int eatSpace(String string, int n) {
        int n2 = n;
        while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    protected static Hashtable extractAttributes(Vector vector, int n) {
        Hashtable<String, String> hashtable = null;
        try {
            int n2 = vector.size();
            while (n2 > n) {
                Object object;
                String string;
                String string2 = (String)vector.elementAt(n++);
                int n3 = string2.length();
                int n4 = string2.indexOf(61);
                if (n4 > -1) {
                    string = string2.substring(0, n4);
                    object = string2.substring(n4 + 1, n3);
                    if (string2.indexOf(124, n4) > -1 || string.charAt(0) == '#') {
                        object = LEDataSpecFactory.extractEnumValues((String)object);
                    }
                } else {
                    string = string2;
                    object = BLANK;
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                hashtable.put(string, (String)object);
                if (string.charAt(0) != '#') continue;
                hashtable.put(DEP_STRING, DEP_STRING);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LEDebug.getLog().logln(20, indexOutOfBoundsException);
        }
        return hashtable;
    }

    protected static Vector extractEnumValues(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            String string2;
            int n3 = string.indexOf(124, n);
            if (n3 > -1) {
                string2 = string.substring(n, n3);
                n = n3 + 1;
            } else {
                string2 = string.substring(n, n2);
                n = n2;
            }
            vector.addElement(string2);
        }
        return vector;
    }
}

