/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEEthernet
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String BROADCAST = "186";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String HELLOINTERVAL = "243";
    public static final String INPUT_FILTER = "193";
    public static final String IP_STATUS = "191";
    public static final String IPSEC_ACTIVE_PROFILE = "501";
    public static final String IPSEC_LOG_CONSOLE = "499";
    public static final String IPSEC_LOG_FAILURE = "496";
    public static final String IPSEC_LOG_SUCCESS = "497";
    public static final String IPSEC_LOG_SYSLOG = "498";
    public static final String IPSEC_OUTSRC_PROFILE = "500";
    public static final String IPSEC_PASSIVE_PROFILE = "502";
    public static final String IPSEC_PDA = "503";
    public static final String IPX_FRAME = "190";
    public static final String IPX_NETWORK = "189";
    public static final String IPX_STATUS = "192";
    public static final String MAC_ADDRESS = "195";
    public static final String MIGRATION = "241";
    public static final String MPROXY = "512";
    public static final String MPROXY_ADDR = "513";
    public static final String MPROXY_PORT = "514";
    public static final String MPROXY_SRC_ADDR = "515";
    public static final String MPROXY_SRC_MASK = "516";
    public static final String MPROXY_SLOT = "517";
    public static final String MPROXY_NUM = "518";
    public static final String MPROXY_ALARM = "519";
    public static final String MPROXY_TIMEOUT = "520";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String RIP = "rip";
    public static final String RIP_V2 = "rip_v2";
    public static final String RIP_COST = "198";
    public static final String ROUTE_IFILTER = "533";
    public static final String ROUTE_OFILTER = "534";
    public static final String XBAR_ADDR = "72";
    public static final int KEY_COUNT = 48;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String BROAD = "broadcast";
    public static final String LISTEN = "listen";
    public static final String V2 = "v2 enabled";
    public static final String MULTICAST = "multicast";
    public static final String COMPATABILITY = "v1-compatability";
    public static final String ETHERNET_802_2 = "ethernet_802.2";
    public static final String ETHERNET_802_2_II = "ethernet_802.2_ii";
    public static final String ETHERNET_802_3 = "ethernet_802.3";
    public static final String ETHERNET_II = "ethernet_ii";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[48];
            int n = 0;
            LEEthernet.s_keys[n++] = ADDRESS;
            LEEthernet.s_keys[n++] = BROADCAST;
            LEEthernet.s_keys[n++] = COST;
            LEEthernet.s_keys[n++] = DEADTIME;
            LEEthernet.s_keys[n++] = HELLOINTERVAL;
            LEEthernet.s_keys[n++] = INPUT_FILTER;
            LEEthernet.s_keys[n++] = IP_STATUS;
            LEEthernet.s_keys[n++] = IPSEC_ACTIVE_PROFILE;
            LEEthernet.s_keys[n++] = IPSEC_LOG_FAILURE;
            LEEthernet.s_keys[n++] = IPSEC_LOG_SUCCESS;
            LEEthernet.s_keys[n++] = IPSEC_LOG_SYSLOG;
            LEEthernet.s_keys[n++] = IPSEC_LOG_CONSOLE;
            LEEthernet.s_keys[n++] = IPSEC_OUTSRC_PROFILE;
            LEEthernet.s_keys[n++] = IPSEC_PASSIVE_PROFILE;
            LEEthernet.s_keys[n++] = IPSEC_PDA;
            LEEthernet.s_keys[n++] = IPX_FRAME;
            LEEthernet.s_keys[n++] = IPX_NETWORK;
            LEEthernet.s_keys[n++] = IPX_STATUS;
            LEEthernet.s_keys[n++] = MAC_ADDRESS;
            LEEthernet.s_keys[n++] = MIGRATION;
            LEEthernet.s_keys[n++] = MPROXY;
            LEEthernet.s_keys[n++] = MPROXY_ADDR;
            LEEthernet.s_keys[n++] = MPROXY_SRC_ADDR;
            LEEthernet.s_keys[n++] = MPROXY_SRC_MASK;
            LEEthernet.s_keys[n++] = MPROXY_SLOT;
            LEEthernet.s_keys[n++] = MPROXY_NUM;
            LEEthernet.s_keys[n++] = MPROXY_ALARM;
            LEEthernet.s_keys[n++] = MPROXY_TIMEOUT;
            LEEthernet.s_keys[n++] = NAT_TCP_TIMEOUT;
            LEEthernet.s_keys[n++] = NAT_OTHER_TIMEOUT;
            LEEthernet.s_keys[n++] = NAT_FAIL_ACTION;
            LEEthernet.s_keys[n++] = NAT_IN_MAP;
            LEEthernet.s_keys[n++] = NAT_PROXY_IN_MAP;
            LEEthernet.s_keys[n++] = NAT_OUT_MAP;
            LEEthernet.s_keys[n++] = NAT_PROXY_OUT_MAP;
            LEEthernet.s_keys[n++] = NAT_LOG_FAILURE;
            LEEthernet.s_keys[n++] = NAT_LOG_SUCCESS;
            LEEthernet.s_keys[n++] = NAT_LOG_SYSLOG;
            LEEthernet.s_keys[n++] = NAT_LOG_CONSOLE;
            LEEthernet.s_keys[n++] = NETMASK;
            LEEthernet.s_keys[n++] = OSPF_STATUS;
            LEEthernet.s_keys[n++] = OUTPUT_FILTER;
            LEEthernet.s_keys[n++] = RIP_COST;
            LEEthernet.s_keys[n++] = RIP;
            LEEthernet.s_keys[n++] = RIP_V2;
            LEEthernet.s_keys[n++] = ROUTE_IFILTER;
            LEEthernet.s_keys[n++] = ROUTE_OFILTER;
            LEEthernet.s_keys[n++] = XBAR_ADDR;
        }
        return s_keys;
    }

    public LEEthernet(LEConnectionFacade lEConnectionFacade, String string, String string2) {
        super(lEConnectionFacade, string);
        this.m_name = string2;
    }

    public LEEthernet(LEConnectionFacade lEConnectionFacade, String string) {
        super(lEConnectionFacade);
        this.m_name = string;
    }

    public Object clone() {
        LEEthernet lEEthernet = new LEEthernet(this.m_facade, this.m_board, this.m_name);
        lEEthernet.copy(this);
        return lEEthernet;
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = super.getAllCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            if (this.m_board != null) {
                if (!this.m_board.equals("4") && !this.m_board.equals("10")) {
                    this.makePowerCycleCommands(lEVector);
                } else {
                    lEVector.addElement("reboot");
                }
            } else {
                lEVector.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return bl;
    }

    boolean getChangedCommands(LEVector lEVector) {
        boolean bl = super.getChangedCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            if (this.m_board != null) {
                if (!this.m_board.equals("4") && !this.m_board.equals("10")) {
                    this.makePowerCycleCommands(lEVector);
                } else {
                    lEVector.addElement("reboot");
                }
            } else {
                lEVector.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return bl;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        CharSequence charSequence;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        this.m_reboot = false;
        if (bl || lEVector.contains(ADDRESS)) {
            this.makeSetCommand(lEVector2, this.m_name, ADDRESS, "address");
        }
        if (bl || lEVector.contains(BROADCAST)) {
            this.makeSetCommand(lEVector2, this.m_name, BROADCAST, BROAD);
        }
        if (bl || lEVector.contains(INPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (bl || lEVector.contains(IP_STATUS)) {
            if (this.m_board != null) {
                if (this.m_board.equals("4")) {
                    this.makeSetCommand(lEVector2, this.m_name, IP_STATUS, "ip");
                }
            } else {
                this.makeSetCommand(lEVector2, this.m_name, IP_STATUS, "ip");
            }
        }
        if (bl || lEVector.contains(IPX_FRAME)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_FRAME, "ipxframe");
        }
        if (bl || lEVector.contains(IPX_NETWORK)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (bl || lEVector.contains(IPX_STATUS)) {
            if (this.m_board != null) {
                if (this.m_board.equals("4")) {
                    this.makeSetCommand(lEVector2, this.m_name, IPX_STATUS, "ipx");
                }
            } else {
                this.makeSetCommand(lEVector2, this.m_name, IPX_STATUS, "ipx");
            }
        }
        if (bl || lEVector.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(lEVector2, this.m_name, NAT_FAIL_ACTION);
        }
        if (bl || lEVector.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_IN_MAP, true, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (bl || lEVector.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (bl || lEVector.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (bl || lEVector.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, this.m_name, NETMASK, "netmask");
        }
        if (bl || lEVector.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (bl || lEVector.contains(RIP) || lEVector.contains(RIP_V2)) {
            charSequence = (String)this.get(RIP);
            if (bl) {
                this.makeRIPCommand(lEVector2, this.m_name, RIP, (String)this.get(RIP));
                this.makeRIPv2Command(lEVector2, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            } else if (lEVector != null && lEVector.contains(RIP) && charSequence != null && !((String)charSequence).equals(V2)) {
                this.makeRIPCommand(lEVector2, this.m_name, RIP, (String)this.get(RIP));
            } else {
                this.makeRIPv2Command(lEVector2, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            }
        }
        if (bl || lEVector.contains(RIP_COST)) {
            this.makeSetCommand(lEVector2, this.m_name, RIP_COST, "rip cost");
        }
        if ((bl || lEVector.contains(OSPF_STATUS) || lEVector.contains(COST) || lEVector.contains(MIGRATION) || lEVector.contains(HELLOINTERVAL) || lEVector.contains(DEADTIME)) && this.get(OSPF_STATUS) != null) {
            charSequence = new StringBuffer(100);
            ((StringBuffer)charSequence).append("set ");
            ((StringBuffer)charSequence).append(" ");
            ((StringBuffer)charSequence).append(this.m_name);
            ((StringBuffer)charSequence).append(" ospf ");
            String string = (String)this.get(OSPF_STATUS);
            ((StringBuffer)charSequence).append(string);
            if (string.equals("on")) {
                String string2;
                String string3;
                String string4;
                String string5 = (String)this.get(COST);
                if (string5 != null && string5.length() > 0) {
                    ((StringBuffer)charSequence).append(" cost ");
                    ((StringBuffer)charSequence).append(string5);
                }
                if ((string4 = (String)this.get(MIGRATION)) != null && string4.length() > 0) {
                    ((StringBuffer)charSequence).append(" accept-rip ");
                    ((StringBuffer)charSequence).append(string4);
                }
                if ((string3 = (String)this.get(HELLOINTERVAL)) != null && string3.length() > 0) {
                    ((StringBuffer)charSequence).append(" hello-interval ");
                    ((StringBuffer)charSequence).append(string3);
                }
                if ((string2 = (String)this.get(DEADTIME)) != null && string2.length() > 0) {
                    ((StringBuffer)charSequence).append(" dead-time ");
                    ((StringBuffer)charSequence).append(string2);
                }
            }
            ((StringBuffer)charSequence).append(" ");
            lEVector2.add(new String((StringBuffer)charSequence));
        }
        if (bl || lEVector.contains(IPSEC_LOG_FAILURE)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_FAILURE, IPSEC_LOG_FAILURE);
        }
        if (bl || lEVector.contains(IPSEC_LOG_SUCCESS)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_SUCCESS, IPSEC_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(IPSEC_LOG_SYSLOG)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_SYSLOG, IPSEC_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(IPSEC_LOG_CONSOLE)) {
            this.makeIPSecLogCommand(lEVector2, this.m_name, IPSEC_LOG_CONSOLE, IPSEC_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(IPSEC_OUTSRC_PROFILE)) {
            this.makeIPSecProfileCommand(lEVector2, this.m_name, IPSEC_OUTSRC_PROFILE, IPSEC_OUTSRC_PROFILE);
        }
        if (bl || lEVector.contains(IPSEC_ACTIVE_PROFILE)) {
            this.makeIPSecProfileCommand(lEVector2, this.m_name, IPSEC_ACTIVE_PROFILE, IPSEC_ACTIVE_PROFILE);
        }
        if (bl || lEVector.contains(IPSEC_PDA)) {
            this.makeIPSecPDACommand(lEVector2, this.m_name, IPSEC_PDA, IPSEC_PDA);
        }
        if (bl || lEVector.contains(XBAR_ADDR)) {
            this.m_reboot = this.makeSetCommand(lEVector2, this.m_name, XBAR_ADDR, "crossbar-ip");
        }
        if (bl || lEVector.contains(ROUTE_IFILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, ROUTE_IFILTER, "route-filter incoming");
        }
        if (bl || lEVector.contains(ROUTE_OFILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, ROUTE_OFILTER, "route-filter outgoing");
        }
        if (bl || lEVector.contains(MPROXY)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY, "mproxy");
        }
        if (bl || lEVector.contains(MPROXY_ADDR)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_ADDR, "mproxy address");
        }
        if (bl || lEVector.contains(MPROXY_PORT)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_PORT, "mproxy port");
        }
        if (bl || lEVector.contains(MPROXY_SRC_ADDR)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_SRC_ADDR, "mproxy src-address");
        }
        if (bl || lEVector.contains(MPROXY_SRC_MASK)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_SRC_MASK, "mproxy src-netmask");
        }
        if (bl || lEVector.contains(MPROXY_NUM)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_NUM, "mproxy number-slots");
        }
        if (bl || lEVector.contains(MPROXY_SLOT)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_SLOT, "mproxy slot-time");
        }
        if (bl || lEVector.contains(MPROXY_ALARM)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_ALARM, "mproxy alarm");
        }
        if (bl || lEVector.contains(MPROXY_TIMEOUT)) {
            this.makeSetCommand(lEVector2, this.m_name, MPROXY_TIMEOUT, "mproxy timeout");
        }
        return lEVector2.size() > n;
    }

    public boolean requiresPowerCycle(String string) {
        return this.m_board != null && string.equals(XBAR_ADDR) && !this.m_board.equals("4") && !this.m_board.equals("10");
    }

    public boolean requiresReboot(String string) {
        if (string.equals(XBAR_ADDR)) {
            if (this.m_board != null) {
                if (this.m_board.equals("4") || this.m_board.equals("10")) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

