/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEGroup;
import com.lucent.ra.nms.model.LEGroups;
import com.lucent.ra.nms.util.LEVector;

public class LELine
extends LEConfig {
    public static final String CLOCKING = "472";
    public static final String CONFIG = "37";
    public static final String ENCODING = "26";
    public static final String FRAMING = "25";
    public static final String GROUPS = "groups";
    public static final String PCM = "27";
    public static final String LINE_SOURCE = "477";
    public static final String LOOPBACK = "39";
    public static final String SIGNALING = "38";
    public static final String STATUS = "17";
    public static final String STATUS_2 = "53";
    public static final String NFAS_GROUP = "474";
    public static final String NFAS_INTERFACE = "475";
    public static final String NFAS_TYPE = "476";
    public static final String PROFILE = "528";
    public static final String T3_SOURCE = "478";
    public static final int KEY_COUNT = 14;
    public static final String LINE = "line";
    public static final String DOWN = "down";
    public static final String UP = "up";
    public static final String ISDN = "isdn";
    public static final String T1 = "t1";
    public static final String E1 = "e1";
    public static final String FRACTIONAL = "fractional";
    public static final String ISDN_FRAC = "isdn-fractional";
    public static final String INBAND = "inband";
    public static final String IMT = "imt";
    public static final String SIG_NONE = "none";
    public static final String SIG_TRUNK = "trunk";
    public static final String SIG_EM = "em";
    public static final String SIG_WINK = "wink";
    public static final String SIG_FXS = "fxs";
    public static final String SIG_LOOP = "loop";
    public static final String SIG_IMMEDIATE = "immediate";
    public static final String SIG_RBS = "rbs";
    public static final String INTERNAL = "internal";
    public static final String EXTERNAL = "external";
    public static final String ALAW = "a-law";
    public static final String ULAW = "u-law";
    public static final String ESF = "esf";
    public static final String D4 = "d4";
    public static final String CRC4 = "crc4";
    public static final String FAS = "fas";
    public static final String B8ZS = "b8zs";
    public static final String AMI = "ami";
    public static final String HDB3 = "hdb3";
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String SLAVE = "slave";
    public static final String DISABLED = "disabled";
    public static final String LOCAL_SRC = "local";
    public static final String MUX_SRC = "mux card";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[14];
            int n = 0;
            LELine.s_keys[n++] = CLOCKING;
            LELine.s_keys[n++] = CONFIG;
            LELine.s_keys[n++] = ENCODING;
            LELine.s_keys[n++] = FRAMING;
            LELine.s_keys[n++] = GROUPS;
            LELine.s_keys[n++] = LINE_SOURCE;
            LELine.s_keys[n++] = LOOPBACK;
            LELine.s_keys[n++] = NFAS_GROUP;
            LELine.s_keys[n++] = NFAS_INTERFACE;
            LELine.s_keys[n++] = NFAS_TYPE;
            LELine.s_keys[n++] = PCM;
            LELine.s_keys[n++] = LOOPBACK;
            LELine.s_keys[n++] = SIGNALING;
            LELine.s_keys[n++] = STATUS;
            LELine.s_keys[n++] = T3_SOURCE;
        }
        return s_keys;
    }

    public LELine(LEConnectionFacade lEConnectionFacade, String string, String string2) {
        super(lEConnectionFacade, string);
        this.m_name = string2;
    }

    public Object clone() {
        LELine lELine = new LELine(this.m_facade, this.m_board, this.m_name);
        lELine.copy(this);
        return lELine;
    }

    public boolean requiresPowerCycle(String string) {
        if (this.m_board != null && string.equals(CONFIG)) {
            return true;
        }
        if (this.m_board != null && string.equals(LINE_SOURCE)) {
            return true;
        }
        return this.m_board != null && (string.equals(NFAS_GROUP) || string.equals(NFAS_TYPE) || string.equals(NFAS_INTERFACE));
    }

    public boolean requiresReboot(String string) {
        return this.m_board == null && string.equals(CONFIG);
    }

    LEConfig createConfig(String string) {
        if (string.equals(GROUPS)) {
            return new LEGroups(this.m_facade, this.m_board, this.m_name);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = super.getAllCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            if (this.m_board != null) {
                this.makePowerCycleCommands(lEVector);
            } else {
                lEVector.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return bl;
    }

    boolean getChangedCommands(LEVector lEVector) {
        boolean bl = super.getChangedCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            if (this.m_board != null) {
                this.makePowerCycleCommands(lEVector);
            } else {
                lEVector.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return bl;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        Object object;
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        this.m_reboot = false;
        if (bl || lEVector.contains(CLOCKING)) {
            this.makeSetCommand(lEVector2, this.m_name, CLOCKING, "clock");
        }
        if (bl || lEVector.contains(CONFIG)) {
            this.m_reboot = this.makeSetCommand(lEVector2, this.m_name, CONFIG, null);
            string = (String)this.get(CONFIG);
            if (string != null && string.equals(FRACTIONAL) && !this.checkForChannels()) {
                object = new StringBuffer(28);
                ((StringBuffer)object).append("set ");
                ((StringBuffer)object).append(this.m_name);
                ((StringBuffer)object).append(" group 2 channels 1");
                lEVector2.addElement(((StringBuffer)object).toString());
                StringBuffer stringBuffer = new StringBuffer(28);
                stringBuffer.append("set ");
                stringBuffer.append(this.m_name);
                stringBuffer.append(" group 2 64k");
                lEVector2.addElement(stringBuffer.toString());
                LEGroups lEGroups = (LEGroups)this.getConfig(GROUPS);
                LEGroup lEGroup = (LEGroup)lEGroups.getConfig("2");
                lEGroup.setField(LEGroup.CHANNELS, "1");
                lEGroup.setField(LEGroup.SPEED, "64k");
            } else if (string != null && !string.equals(FRACTIONAL) && !string.equals(ISDN_FRAC) && (object = (LEGroups)this.getConfig(GROUPS)) != null) {
                ((LEGroups)object).clear();
            }
        }
        if (bl || lEVector.contains(ENCODING)) {
            this.makeSetCommand(lEVector2, this.m_name, ENCODING, "encoding");
        }
        if (bl || lEVector.contains(FRAMING)) {
            this.makeSetCommand(lEVector2, this.m_name, FRAMING, "framing");
        }
        if (bl || lEVector.contains(LOOPBACK)) {
            this.makeSetCommand(lEVector2, this.m_name, LOOPBACK, "loopback");
        }
        if (bl || lEVector.contains(PCM)) {
            this.makeSetCommand(lEVector2, this.m_name, PCM, "pcm");
        }
        if ((bl || lEVector.contains(SIGNALING)) && (string = (String)this.get(SIGNALING)) != null && !string.equals(SIG_NONE)) {
            object = new StringBuffer("set ");
            ((StringBuffer)object).append(this.m_name);
            ((StringBuffer)object).append(" signaling ");
            if (string.indexOf(SIG_FXS) > -1) {
                ((StringBuffer)object).append(SIG_FXS);
            } else if (string.indexOf(SIG_WINK) > -1) {
                ((StringBuffer)object).append(SIG_WINK);
            } else if (string.indexOf(SIG_IMMEDIATE) > -1) {
                ((StringBuffer)object).append(SIG_IMMEDIATE);
            } else {
                ((StringBuffer)object).append(string);
            }
            lEVector2.addElement(new String((StringBuffer)object));
        }
        if (bl || lEVector.contains(PROFILE)) {
            this.makeSetCommand(lEVector2, this.m_name, PROFILE, "mfr2");
        }
        if ((bl || lEVector.contains(NFAS_GROUP) || lEVector.contains(NFAS_TYPE) || lEVector.contains(NFAS_INTERFACE)) && (string = (String)this.get(NFAS_GROUP)) != null) {
            object = new StringBuffer("set ");
            ((StringBuffer)object).append(this.m_name);
            ((StringBuffer)object).append(" nfas ");
            ((StringBuffer)object).append((String)this.get(NFAS_TYPE));
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append((String)this.get(NFAS_INTERFACE));
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append((String)this.get(NFAS_GROUP));
            lEVector2.addElement(((StringBuffer)object).toString());
            this.m_reboot = true;
        }
        if ((bl || lEVector.contains(LINE_SOURCE) || lEVector.contains(T3_SOURCE)) && (string = (String)this.get(LINE_SOURCE)) != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("set ");
            ((StringBuffer)object).append(this.m_name);
            ((StringBuffer)object).append(" source ");
            if (string.equals(LOCAL_SRC)) {
                ((StringBuffer)object).append(LOCAL_SRC);
            } else {
                ((StringBuffer)object).append((String)this.get(T3_SOURCE));
            }
            lEVector2.addElement(((StringBuffer)object).toString());
            this.m_reboot = true;
        }
        return lEVector2.size() > n;
    }

    boolean checkForChannels() {
        LEGroups lEGroups = (LEGroups)this.get(GROUPS);
        if (lEGroups == null || lEGroups.size() == 0) {
            return false;
        }
        boolean bl = false;
        LEVector lEVector = lEGroups.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (!bl && n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            LEGroup lEGroup = (LEGroup)lEGroups.get(string);
            String string2 = (String)lEGroup.get(LEGroup.CHANNELS);
            if (string2 != null && string2.length() > 0) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }
}

