/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDialScript;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class LELocationFileParser {
    private static final String ANALOG_STRING = "set\\s+loc\\w*\\s+(\\S+)\\s+an\\w*\\s+(\\w+)";
    private static final String CHAP_STRING = "set loc\\w* (\\S+) ch\\w* (\\w+)";
    private static final String COMPRESSION_STRING = "set loc\\w* (\\S+) com\\w* (\\w+)";
    private static final String DESTINATION_STRING = "set loc\\w* (\\S+) de\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String GROUP_STRING = "set loc\\w* (\\S+) gr\\w* (\\d+)";
    private static final String HIGHWATER_STRING = "set loc\\w* (\\S+) hi\\w* (\\d+)";
    private static final String IDLETIMEOUT_STRING = "set loc\\w* (\\S+) id\\w* (\\d+) (\\w*)";
    private static final String INPUTFILTER_STRING = "set loc\\w* (\\S+) if\\w* (\\S+)";
    private static final String IPSEC_ACTIVE_PROF_STRING = "set loc\\w* (\\S+) ipsec a\\w*p\\w* (\\S+)";
    private static final String IPSEC_LOG_CONSOLE_STRING = "set loc\\w* (\\S+) ipsec log cons\\w* (\\w*)";
    private static final String IPSEC_LOG_SYSLOG_STRING = "set loc\\w* (\\S+) ipsec log s\\w*l\\w* (\\w*)";
    private static final String IPSEC_LOG_SUCCESS_STRING = "set loc\\w* (\\S+) ipsec log sas\\w* (\\w*)";
    private static final String IPSEC_LOG_FAIL_STRING = "set loc\\w* (\\S+) ipsec log saf\\w* (\\w*)";
    private static final String IPSEC_OUTSRC_PROF_STRING = "set loc\\w* (\\S+) ipsec o\\w*p\\w* (\\S+)";
    private static final String IPSEC_PASSIVE_PROF_STRING = "set loc\\w* (\\S+) ipsec p\\w*p\\w* (\\S+)";
    private static final String IPSEC_PDA_STRING = "set loc\\w* (\\S+) ipsec p\\w*d\\w*a\\w* (\\S+)";
    private static final String IPXNETWORK_STRING = "set loc\\w* (\\S+) ipx\\w* (\\w+)";
    private static final String LOCALADDR_STRING = "set loc\\w* (\\S+) lo\\S* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String MAP_STRING = "set loc\\w* (\\S+) map\\w* (\\S+)";
    private static final String MAXPORTS_STRING = "set loc\\w* (\\S+) max\\w* (\\d+)";
    private static final String MTU_STRING = "set loc\\w* (\\S+) mt\\w* (\\d+)";
    private static final String MULTILINK_STRING = "set loc\\w* (\\S+) mu\\w* (\\w+)";
    private static final String NAT_INMAP_STRING = "set loc\\w* (\\S+) nat i\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_INMAP_STRING = "set loc\\w* (\\S+) nat i\\w*map (\\w*) outs\\w*";
    private static final String NAT_OUTMAP_STRING = "set loc\\w* (\\S+) nat o\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_OUTMAP_STRING = "set loc\\w* (\\S+) nat o\\w*map (\\w*) outs\\w*";
    private static final String NAT_LOG_CONSOLE_STRING = "set loc\\w* (\\S+) nat log cons\\w* (\\w*)";
    private static final String NAT_LOG_SYSLOG_STRING = "set loc\\w* (\\S+) nat log s\\w*l\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING = "set loc\\w* (\\S+) nat log ss\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING2 = "set loc\\w* (\\S+) nat log sessions\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING = "set loc\\w* (\\S+) nat log sf\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING2 = "set loc\\w* (\\S+) nat log sessionf\\w* (\\w*)";
    private static final String NAT_TIMEOUT_STRING = "set loc\\w* (\\S+) nat s\\w*t\\w*o\\w* (\\w+) (\\d{1,5}) (\\w*)";
    private static final String NAT_FAILURE_STRING = "set loc\\w* (\\S+) nat s\\w*d\\w*f\\w*a\\w* (\\w+)";
    private static final String NETMASK_STRING = "set loc\\w* (\\S+) ne\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String OUTPUTFILTER_STRING = "set loc\\w* (\\S+) of\\w* (\\S+)";
    private static final String OSPF_STRING = "set loc\\w* (\\S+) os\\w*\\s*.";
    private static final String PASSWORD_STRING = "set loc\\w* (\\S+) pa\\w* (\\S+)";
    private static final String PHONE_STRING = "set loc\\w* (\\S+) ph\\w* (\\S+)";
    private static final String PROTOCOL_STRING = "set loc\\w* (\\S+) pr\\w* (\\S+)";
    private static final String RIP_STRING = "set loc\\w* (\\S+) ri\\w* (\\w+)";
    private static final String RIPV2_STRING = "set loc\\w* (\\S+) rip v2 (\\w+)";
    private static final String SCRIPT_STRING = "set loc\\w* (\\S+) sc\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    private static final String TELEPHONE_STRING = "set loc\\w* (\\S+) te\\w* (\\S+)";
    private static final String USERNAME_STRING = "set loc\\w* (\\S+) us\\w* (\\S+)";
    private static final String VOICE_STRING = "set loc\\w* (\\S+) vo\\w* (\\w+)";
    private static final String V25BIS_STRING = "set loc\\w* (\\S+) v25\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    LELocations m_locations = new LELocations(null);
    LELocation m_location;
    String m_locname = "";
    Perl5Matcher m_matcher = new Perl5Matcher();
    MatchResult m_result;
    Perl5Pattern m_analogPattern;
    Perl5Pattern m_chapPattern;
    Perl5Pattern m_compressionPattern;
    Perl5Pattern m_destinationPattern;
    Perl5Pattern m_groupPattern;
    Perl5Pattern m_highPattern;
    Perl5Pattern m_idlePattern;
    Perl5Pattern m_ifilterPattern;
    Perl5Pattern m_ipsecactprofPattern;
    Perl5Pattern m_ipseclogsysPattern;
    Perl5Pattern m_ipseclogconPattern;
    Perl5Pattern m_ipseclogssPattern;
    Perl5Pattern m_ipseclogsfPattern;
    Perl5Pattern m_ipsecoutsrcprofPattern;
    Perl5Pattern m_ipsecpassiveprofPattern;
    Perl5Pattern m_ipsecpdaPattern;
    Perl5Pattern m_ipxnetPattern;
    Perl5Pattern m_localPattern;
    Perl5Pattern m_mapPattern;
    Perl5Pattern m_maxPattern;
    Perl5Pattern m_mtuPattern;
    Perl5Pattern m_multiPattern;
    Perl5Pattern m_natimapPattern;
    Perl5Pattern m_natimapproxyPattern;
    Perl5Pattern m_natomapPattern;
    Perl5Pattern m_natomapproxyPattern;
    Perl5Pattern m_natlogsysPattern;
    Perl5Pattern m_natlogconPattern;
    Perl5Pattern m_natlogssPattern;
    Perl5Pattern m_natlogssPattern2;
    Perl5Pattern m_natlogsfPattern;
    Perl5Pattern m_natlogsfPattern2;
    Perl5Pattern m_natfailPattern;
    Perl5Pattern m_nattimeoutPattern;
    Perl5Pattern m_netmaskPattern;
    Perl5Pattern m_ofilterPattern;
    Perl5Pattern m_ospfPattern;
    Perl5Pattern m_passwordPattern;
    Perl5Pattern m_phonePattern;
    Perl5Pattern m_protocolPattern;
    Perl5Pattern m_ripPattern;
    Perl5Pattern m_ripv2Pattern;
    Perl5Pattern m_scriptPattern;
    Perl5Pattern m_telePattern;
    Perl5Pattern m_userPattern;
    Perl5Pattern m_voicePattern;
    Perl5Pattern m_v25bisPattern;

    public boolean createPatterns() {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.m_analogPattern = (Perl5Pattern)perl5Compiler.compile(ANALOG_STRING, 1);
            this.m_chapPattern = (Perl5Pattern)perl5Compiler.compile(CHAP_STRING, 1);
            this.m_compressionPattern = (Perl5Pattern)perl5Compiler.compile(COMPRESSION_STRING, 1);
            this.m_destinationPattern = (Perl5Pattern)perl5Compiler.compile(DESTINATION_STRING, 1);
            this.m_groupPattern = (Perl5Pattern)perl5Compiler.compile(GROUP_STRING, 1);
            this.m_highPattern = (Perl5Pattern)perl5Compiler.compile(HIGHWATER_STRING, 1);
            this.m_idlePattern = (Perl5Pattern)perl5Compiler.compile(IDLETIMEOUT_STRING, 1);
            this.m_ifilterPattern = (Perl5Pattern)perl5Compiler.compile(INPUTFILTER_STRING, 1);
            this.m_ipsecactprofPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_ACTIVE_PROF_STRING, 1);
            this.m_ipseclogsysPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_LOG_SYSLOG_STRING, 1);
            this.m_ipseclogconPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_LOG_CONSOLE_STRING, 1);
            this.m_ipseclogssPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_LOG_SUCCESS_STRING, 1);
            this.m_ipseclogsfPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_LOG_FAIL_STRING, 1);
            this.m_ipsecpassiveprofPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_PASSIVE_PROF_STRING, 1);
            this.m_ipsecoutsrcprofPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_OUTSRC_PROF_STRING, 1);
            this.m_ipsecpdaPattern = (Perl5Pattern)perl5Compiler.compile(IPSEC_PDA_STRING, 1);
            this.m_ipxnetPattern = (Perl5Pattern)perl5Compiler.compile(IPXNETWORK_STRING, 1);
            this.m_localPattern = (Perl5Pattern)perl5Compiler.compile(LOCALADDR_STRING, 1);
            this.m_mapPattern = (Perl5Pattern)perl5Compiler.compile(MAP_STRING, 1);
            this.m_maxPattern = (Perl5Pattern)perl5Compiler.compile(MAXPORTS_STRING, 1);
            this.m_mtuPattern = (Perl5Pattern)perl5Compiler.compile(MTU_STRING, 1);
            this.m_multiPattern = (Perl5Pattern)perl5Compiler.compile(MULTILINK_STRING, 1);
            this.m_natimapPattern = (Perl5Pattern)perl5Compiler.compile(NAT_INMAP_STRING, 1);
            this.m_natimapproxyPattern = (Perl5Pattern)perl5Compiler.compile(NAT_PROXY_INMAP_STRING, 1);
            this.m_natomapPattern = (Perl5Pattern)perl5Compiler.compile(NAT_OUTMAP_STRING, 1);
            this.m_natomapproxyPattern = (Perl5Pattern)perl5Compiler.compile(NAT_PROXY_OUTMAP_STRING, 1);
            this.m_natlogsysPattern = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_SYSLOG_STRING, 1);
            this.m_natlogconPattern = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_CONSOLE_STRING, 1);
            this.m_natlogssPattern = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_SUCCESS_STRING, 1);
            this.m_natlogssPattern2 = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_SUCCESS_STRING2, 1);
            this.m_natlogsfPattern = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_FAIL_STRING, 1);
            this.m_natlogsfPattern2 = (Perl5Pattern)perl5Compiler.compile(NAT_LOG_FAIL_STRING2, 1);
            this.m_natfailPattern = (Perl5Pattern)perl5Compiler.compile(NAT_FAILURE_STRING, 1);
            this.m_nattimeoutPattern = (Perl5Pattern)perl5Compiler.compile(NAT_TIMEOUT_STRING, 1);
            this.m_netmaskPattern = (Perl5Pattern)perl5Compiler.compile(NETMASK_STRING, 1);
            this.m_ofilterPattern = (Perl5Pattern)perl5Compiler.compile(OUTPUTFILTER_STRING, 1);
            this.m_ospfPattern = (Perl5Pattern)perl5Compiler.compile(OSPF_STRING, 1);
            this.m_passwordPattern = (Perl5Pattern)perl5Compiler.compile(PASSWORD_STRING, 1);
            this.m_phonePattern = (Perl5Pattern)perl5Compiler.compile(PHONE_STRING, 1);
            this.m_protocolPattern = (Perl5Pattern)perl5Compiler.compile(PROTOCOL_STRING, 1);
            this.m_ripPattern = (Perl5Pattern)perl5Compiler.compile(RIP_STRING, 1);
            this.m_ripv2Pattern = (Perl5Pattern)perl5Compiler.compile(RIPV2_STRING, 1);
            this.m_scriptPattern = (Perl5Pattern)perl5Compiler.compile(SCRIPT_STRING, 1);
            this.m_telePattern = (Perl5Pattern)perl5Compiler.compile(TELEPHONE_STRING, 1);
            this.m_userPattern = (Perl5Pattern)perl5Compiler.compile(USERNAME_STRING, 1);
            this.m_voicePattern = (Perl5Pattern)perl5Compiler.compile(VOICE_STRING, 1);
            this.m_v25bisPattern = (Perl5Pattern)perl5Compiler.compile(V25BIS_STRING, 1);
        }
        catch (MalformedPatternException malformedPatternException) {
            LEDebug.getLog().logln(20, malformedPatternException);
            return false;
        }
        return true;
    }

    public void readLocations(LEVector lEVector) {
        int n = lEVector.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = (String)lEVector.elementAt(n2);
                if (!string.startsWith("#") && string.length() >= 3 && !string.equals("save all")) {
                    int n3 = string.length();
                    String string2 = string.substring(3, n3).toLowerCase();
                    if (string.regionMatches(true, 0, "add ", 0, 4)) {
                        if (string.indexOf("dlci") > -1) {
                            this.addDLCITable(string);
                        } else if (string.indexOf("location") > -1 && !this.addLocation(string)) {
                            return;
                        }
                    } else if (string.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseLocation(string);
                    }
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public LELocations getLocations() {
        return this.m_locations;
    }

    public void writeLocations(PrintStream printStream) {
        LEVector lEVector = new LEVector();
        this.m_locations.getCommands(lEVector);
        int n = lEVector.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            printStream.println(string);
            ++n2;
        }
    }

    protected boolean addLocation(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        LELocation lELocation = new LELocation(null, string2);
        lELocation.initialize();
        this.m_locations.setField(string2, lELocation);
        this.m_locname = string2;
        this.m_location = lELocation;
        return true;
    }

    protected void addDLCITable(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().toLowerCase();
        String string3 = stringTokenizer.nextToken();
        LELocation lELocation = (LELocation)this.m_locations.getConfig(string3);
        LEDLCITable lEDLCITable = null;
        if (string2.startsWith("dlc") || string2.startsWith("ipd")) {
            lEDLCITable = (LEDLCITable)lELocation.getConfig("ipdlci");
        } else if (string2.startsWith("ipxd")) {
            lEDLCITable = (LEDLCITable)lELocation.getConfig("ipxdlci");
        }
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (lEDLCITable != null) {
            lEDLCITable.setField(string4, string5);
        }
    }

    protected void parseLocation(String string) {
        try {
            if (this.m_matcher.contains(string, (Pattern)this.m_analogPattern)) {
                this.setParameter("292", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_chapPattern)) {
                this.setParameter("170", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_compressionPattern)) {
                this.setParameter("290", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_destinationPattern)) {
                String string2 = this.setAddressParameter("9", this.m_matcher.getMatch());
                if (string2.equals("255.255.255.255")) {
                    this.m_location.setField("74", "negotiated");
                    return;
                }
                this.m_location.setField("74", "specified");
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_groupPattern)) {
                this.setParameter("129", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_highPattern)) {
                this.setParameter("298", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_idlePattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                String string3 = matchResult.group(2);
                String string4 = matchResult.group(3);
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.append(" ");
                if (string4 != null) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append("minutes");
                }
                this.setLocation(matchResult);
                this.m_location.setField("297", stringBuffer.toString());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ifilterPattern)) {
                this.setParameter("193", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipsecactprofPattern)) {
                this.setIPSecParameter("501", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipseclogsysPattern)) {
                this.setIPSecParameter("498", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipseclogconPattern)) {
                this.setIPSecParameter("499", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipseclogssPattern)) {
                this.setIPSecParameter("497", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipseclogsfPattern)) {
                this.setIPSecParameter("496", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipsecoutsrcprofPattern)) {
                this.setIPSecParameter("500", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipsecpassiveprofPattern)) {
                this.setIPSecParameter("502", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipsecpdaPattern)) {
                this.setIPSecParameter("503", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ipxnetPattern)) {
                this.setParameter("189", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_localPattern)) {
                this.setAddressParameter("177", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_mapPattern)) {
                this.setParameter("299", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_maxPattern)) {
                this.setParameter("296", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_mtuPattern)) {
                this.setParameter("295", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_multiPattern)) {
                this.setParameter("291", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_netmaskPattern)) {
                this.setAddressParameter("15", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natimapPattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                String string5 = matchResult.group(3);
                if (string5 != null && string5.startsWith("pr")) {
                    this.setNATParameter("357", matchResult);
                    return;
                }
                this.setNATParameter("356", matchResult);
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natimapproxyPattern)) {
                this.setNATParameter("357", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natomapPattern)) {
                MatchResult matchResult = this.m_matcher.getMatch();
                String string6 = matchResult.group(3);
                if (string6 != null && string6.startsWith("pr")) {
                    this.setNATParameter("359", matchResult);
                    return;
                }
                this.setNATParameter("358", matchResult);
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natomapproxyPattern)) {
                this.setNATParameter("359", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natlogsysPattern)) {
                this.setNATParameter("362", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natlogconPattern)) {
                this.setNATParameter("363", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natlogssPattern) || this.m_matcher.contains(string, (Pattern)this.m_natlogssPattern2)) {
                this.setNATParameter("361", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natlogsfPattern) || this.m_matcher.contains(string, (Pattern)this.m_natlogsfPattern2)) {
                this.setNATParameter("360", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_natfailPattern)) {
                this.setNATParameter("355", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_nattimeoutPattern)) {
                this.setNATTimeoutParameter(this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ofilterPattern)) {
                this.setParameter("194", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ospfPattern)) {
                this.setOSPFParameters(string);
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_passwordPattern)) {
                this.setParameter("300", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ripv2Pattern)) {
                this.setParameter("rip_v2", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_ripPattern)) {
                this.setParameter("rip", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_scriptPattern)) {
                this.setScriptParameter("script", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_phonePattern) || this.m_matcher.contains(string, (Pattern)this.m_telePattern)) {
                this.setParameter("301", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_protocolPattern)) {
                this.setParameter("289", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_userPattern)) {
                this.setParameter("2", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_voicePattern)) {
                this.setParameter("293", this.m_matcher.getMatch());
                return;
            }
            if (this.m_matcher.contains(string, (Pattern)this.m_v25bisPattern)) {
                this.setScriptParameter("v25bis", this.m_matcher.getMatch());
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    protected void setLocation(MatchResult matchResult) {
        String string = matchResult.group(1);
        if (!string.equals(this.m_locname)) {
            this.m_location = (LELocation)this.m_locations.get(string);
            this.m_locname = string;
        }
    }

    protected void setParameter(String string, MatchResult matchResult) {
        this.setLocation(matchResult);
        String string2 = matchResult.group(2);
        if (string2 != null) {
            this.m_location.setField(string, matchResult.group(2));
        }
    }

    protected String setAddressParameter(String string, MatchResult matchResult) {
        this.setLocation(matchResult);
        String string2 = matchResult.group(2);
        String string3 = matchResult.group(3);
        String string4 = matchResult.group(4);
        String string5 = matchResult.group(5);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append(".");
        stringBuffer.append(string4);
        stringBuffer.append(".");
        stringBuffer.append(string5);
        this.m_location.setField(string, stringBuffer.toString());
        return stringBuffer.toString();
    }

    protected void setNATParameter(String string, MatchResult matchResult) {
        String string2;
        this.setLocation(matchResult);
        String string3 = (String)this.m_location.get("356");
        if (string3 == null) {
            this.m_location.initializeNAT();
        }
        if ((string2 = matchResult.group(2)) != null) {
            this.m_location.setField(string, string2);
        }
    }

    protected void setNATTimeoutParameter(MatchResult matchResult) {
        this.setLocation(matchResult);
        String string = (String)this.m_location.get("356");
        if (string == null) {
            this.m_location.initializeNAT();
        }
        String string2 = matchResult.group(2);
        String string3 = matchResult.group(3);
        String string4 = matchResult.group(4);
        String string5 = string4 == null ? new String(" minutes") : new String(" " + string4);
        if (string2 != null) {
            if (string2.equals("tcp")) {
                this.m_location.setField("353", String.valueOf(string3) + string5);
                return;
            }
            if (string2.equals("other")) {
                this.m_location.setField("354", String.valueOf(string3) + string5);
            }
        }
    }

    protected void setIPSecParameter(String string, MatchResult matchResult) {
        String string2;
        this.setLocation(matchResult);
        String string3 = (String)this.m_location.get("501");
        if (string3 == null) {
            this.m_location.initializeIPSec();
        }
        if ((string2 = matchResult.group(2)) != null) {
            this.m_location.setField(string, string2);
        }
    }

    protected void setScriptParameter(String string, MatchResult matchResult) {
        this.setLocation(matchResult);
        String string2 = matchResult.group(2);
        String string3 = "expect";
        String string4 = "send";
        String string5 = matchResult.group(3);
        String string6 = matchResult.group(4);
        if (string5 != null && string6 != null) {
            LEDialScript lEDialScript = (LEDialScript)this.m_location.getConfig(string);
            lEDialScript.setField(String.valueOf(string4) + string2, string5);
            lEDialScript.setField(String.valueOf(string3) + string2, string6);
        }
    }

    protected void setRIPParameter(MatchResult matchResult) {
        this.setLocation(matchResult);
    }

    protected void setOSPFParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        LELocation lELocation = (LELocation)this.m_locations.get(string2);
        if (lELocation != null) {
            if (lELocation.get("246") == null) {
                lELocation.initializeOSPF();
            }
            lELocation.setField("246", string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().toLowerCase();
                if (string4.startsWith("co")) {
                    lELocation.setField("242", stringTokenizer.nextToken());
                    continue;
                }
                if (string4.startsWith("he")) {
                    lELocation.setField("243", stringTokenizer.nextToken());
                    continue;
                }
                if (string4.startsWith("de")) {
                    lELocation.setField("244", stringTokenizer.nextToken());
                    continue;
                }
                if (!string4.startsWith("po") && !string4.startsWith("nb") && !string4.startsWith("wa")) continue;
                lELocation.setField("245", string4);
            }
        }
    }
}

