/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEOSPFArea;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEOSPFAreas
extends LETable {
    public LEOSPFAreas(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public Object clone() {
        LEOSPFAreas lEOSPFAreas = new LEOSPFAreas(this.m_facade);
        lEOSPFAreas.copy(this);
        return lEOSPFAreas;
    }

    public LEVector add(String string) {
        LEVector lEVector = null;
        String string2 = this.makeAddCommand("ospf area", string);
        LEPMCommand lEPMCommand = this.m_facade.execute(string2);
        if (lEPMCommand.getStatus()) {
            lEPMCommand = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    public LEVector delete(String string) {
        LEVector lEVector = null;
        String string2 = this.makeDeleteCommand("ospf area", string);
        LEPMCommand lEPMCommand = this.m_facade.execute(string2);
        if (lEPMCommand.getStatus()) {
            this.remove(string);
            lEPMCommand = this.m_facade.execute("save all");
            if (!lEPMCommand.getStatus()) {
                this.refresh();
            }
        }
        if (!lEPMCommand.getStatus()) {
            lEVector = new LEVector();
            lEVector.addElement(lEPMCommand);
        }
        return lEVector;
    }

    LEConfig createConfig(String string) {
        return new LEOSPFArea(this.m_facade, string);
    }

    boolean generateAddCommand(String string, LEVector lEVector) {
        lEVector.addElement(this.makeAddCommand("ospf area", string));
        return true;
    }

    boolean generateDeleteCommand(String string, LEVector lEVector) {
        lEVector.addElement(this.makeDeleteCommand("ospf area", string));
        return true;
    }

    boolean getChangedCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getChangedCommands(lEVector);
        if (bl) {
            this.checkCommands(lEVector, n);
        }
        return bl;
    }

    boolean getAllCommands(LEVector lEVector) {
        int n = lEVector.size();
        boolean bl = super.getAllCommands(lEVector);
        if (bl) {
            this.checkCommands(lEVector, n);
        }
        return bl;
    }

    void checkCommands(LEVector lEVector, int n) {
        int n2 = lEVector.size();
        int n3 = -1;
        int n4 = -1;
        int n5 = n;
        while (n5 < n2) {
            String string = (String)lEVector.elementAt(n5);
            if (string.equals("reset ospf")) {
                if (n3 > 0) {
                    lEVector.removeElementAt(n3);
                    --n2;
                    --n4;
                }
                n3 = --n5;
            } else if (string.equals("save all")) {
                n4 = n5;
            }
            ++n5;
        }
    }
}

