/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LEBootPClient;
import com.lucent.ra.nms.netboot.LEBootPPacket;
import com.lucent.ra.nms.netboot.LEUDPServer;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LEBootPServer
extends LEUDPServer {
    public static final int SERVER_PORT = 67;
    public static final int CLIENT_PORT = 68;
    private DatagramPacket m_received_packet;
    private LEBootPClient m_client = null;
    private static LEBootPServer s_singleton = null;
    private PrintWriter m_pw;

    public static LEBootPServer GetServer() {
        if (s_singleton == null) {
            s_singleton = new LEBootPServer();
        }
        return s_singleton;
    }

    private LEBootPServer() {
        super(67);
        try {
            String string = LEAppInfo.getUserAppDirPath("bootplog.txt");
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            this.m_pw = new PrintWriter((Writer)fileWriter, true);
            this.m_pw.println(LEAppInfo.getAppTitle());
            return;
        }
        catch (Exception exception) {
            this.m_pw = null;
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void setClient(LEBootPClient lEBootPClient) {
        this.m_client = lEBootPClient;
    }

    public LEBootPClient getClient() {
        return this.m_client;
    }

    public void removeClient() {
        this.m_client = null;
    }

    private void notifyClient(LEBootPPacket lEBootPPacket) {
        if (this.m_client != null) {
            this.m_client.receivedPacket(lEBootPPacket);
        }
    }

    public void process(DatagramPacket datagramPacket) {
        this.printMsg("Received BootP packet of length " + Integer.toString(datagramPacket.getData().length));
        LEBootPPacket lEBootPPacket = new LEBootPPacket(datagramPacket.getData());
        if (lEBootPPacket.isRequest()) {
            this.printMsg("Packet is a request");
            this.notifyClient(lEBootPPacket);
        }
    }

    public void sendPacket(LEBootPPacket lEBootPPacket, InetAddress inetAddress) {
        try {
            this.printMsg("Using broadcast address " + inetAddress.toString());
            DatagramPacket datagramPacket = new DatagramPacket(lEBootPPacket.dumpData(), lEBootPPacket.size(), inetAddress, 68);
            this.printMsg("Sending BootP Response");
            this.send(datagramPacket);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, "Exception " + exception.getClass().getName() + " Message " + exception.getMessage());
            return;
        }
    }

    public void printMsg(String string) {
        this.print(this.m_pw, string, true);
    }

    public void printMsg(String string, boolean bl) {
        this.print(this.m_pw, string, bl);
    }

    public void startServer() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.printMsg("Starting BootP Server at address " + inetAddress.toString());
        }
        catch (UnknownHostException unknownHostException) {
            LEDebug.getLog().logln(30, "Unknown Host");
        }
        super.startServer();
    }

    public void stopServer() {
        this.printMsg("Terminating BootP Server");
        this.m_client = null;
        super.stopServer();
    }
}

