/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPInFile;
import com.lucent.ra.nms.netboot.LETFTPOutFile;
import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEByteArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class LETFTPDataPacket
extends LETFTPPacket {
    private static final int MAX_PACKET_SIZE = 516;
    private short m_blockNum;
    private int m_dataLen;
    private byte[] m_data;

    public LETFTPDataPacket(LETFTPInFile lETFTPInFile, short s) throws IOException {
        int n = 0;
        this.m_data = new byte[516];
        this.m_blockNum = s;
        LEByteArray.CopyShort((short)3, this.m_data, n);
        LEByteArray.CopyShort(this.m_blockNum, this.m_data, n += 2);
        this.m_dataLen = lETFTPInFile.getBlock(this.m_data, n += 2);
    }

    public LETFTPDataPacket(DatagramPacket datagramPacket) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            dataInputStream.skipBytes(2);
            this.m_blockNum = dataInputStream.readShort();
            this.m_dataLen = datagramPacket.getLength() - 4;
            return;
        }
        catch (IOException iOException) {
            LETFTPServer.GetServer().printMsg("Problem reading TFTP Data packet from stream");
            return;
        }
    }

    public void putToFile(LETFTPOutFile lETFTPOutFile, DatagramPacket datagramPacket) {
        try {
            lETFTPOutFile.putToFile(datagramPacket.getData(), 4, datagramPacket.getLength() - 4);
            return;
        }
        catch (IOException iOException) {
            LETFTPServer.GetServer().printMsg("Problem writing to file");
            return;
        }
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getSize() {
        return this.m_dataLen + 4;
    }

    public short getBlockNum() {
        return this.m_blockNum;
    }

    public int getDataLen() {
        return this.m_dataLen;
    }

    public void printPacket() {
        LETFTPServer.GetServer().printMsg("Data packet", false);
        LETFTPServer.GetServer().printMsg(" Block number: " + this.m_blockNum, false);
    }
}

