/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEByteArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class LETFTPPacket {
    public static final short READ_REQUEST = 1;
    public static final short WRITE_REQUEST = 2;
    public static final short DATA = 3;
    public static final short ACK = 4;
    public static final short ERROR = 5;
    public static final short OPTION_ACK = 6;
    private static final int MAX_PACKET_SIZE = 2;
    protected short m_opcode;
    private byte[] m_data;

    public LETFTPPacket() {
    }

    public LETFTPPacket(DatagramPacket datagramPacket) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.m_opcode = dataInputStream.readShort();
            return;
        }
        catch (IOException iOException) {
            LETFTPServer.GetServer().printMsg("Problem reading from input data stream");
            return;
        }
    }

    public short getOpcode() {
        return this.m_opcode;
    }

    public byte[] getBytes() {
        this.m_data = new byte[2];
        LEByteArray.CopyShort(this.m_opcode, this.m_data, 0);
        return this.m_data;
    }

    public int getSize() {
        return 2;
    }
}

