/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPAckPacket;
import com.lucent.ra.nms.netboot.LETFTPClient;
import com.lucent.ra.nms.netboot.LETFTPDataPacket;
import com.lucent.ra.nms.netboot.LETFTPErrorPacket;
import com.lucent.ra.nms.netboot.LETFTPOutFile;
import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPReqPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEDebug;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;

public class LETFTPWriteClient
extends LETFTPClient
implements Runnable {
    public static final int TFTP_WRITE_BLOCK_SIZE = 512;
    private Thread m_clientThread;
    private short m_blockNum;
    LETFTPOutFile m_tftpFile;
    LETFTPAckPacket m_lastPkt;
    int m_lastPktLen;

    LETFTPWriteClient(DatagramPacket datagramPacket) {
        super(datagramPacket);
        LETFTPReqPacket lETFTPReqPacket = new LETFTPReqPacket(datagramPacket);
        LETFTPServer.GetServer().printMsg("Packet received:");
        lETFTPReqPacket.printPacket();
        this.setFilePath(LETFTPServer.GetServer().getBaseDir(), lETFTPReqPacket.getFileName());
        try {
            LETFTPAckPacket lETFTPAckPacket;
            this.m_tftpFile = new LETFTPOutFile(this.getFilePath());
            this.m_blockNum = 1;
            this.m_lastPkt = lETFTPAckPacket = new LETFTPAckPacket(this.m_blockNum);
            this.send(lETFTPAckPacket);
            this.m_clientThread = new Thread(this);
            this.m_clientThread.start();
            this.m_state = 1;
            return;
        }
        catch (IOException iOException) {
            LETFTPErrorPacket lETFTPErrorPacket = new LETFTPErrorPacket(0, "");
            this.send(lETFTPErrorPacket);
            this.m_state = 3;
            return;
        }
    }

    public void run() {
        int n = 0;
        byte[] byArray = new byte[4];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.m_state = 2;
        try {
            this.getSocket().setSoTimeout(LETFTPServer.GetServer().getTimeoutInterval() * 1000);
            while (true) {
                try {
                    while (true) {
                        LETFTPPacket lETFTPPacket;
                        this.getSocket().receive(datagramPacket);
                        if (datagramPacket.getPort() == this.getRemotePort()) {
                            LETFTPPacket lETFTPPacket2;
                            lETFTPPacket = new LETFTPPacket(datagramPacket);
                            if (lETFTPPacket.getOpcode() == 3) {
                                lETFTPPacket2 = new LETFTPDataPacket(datagramPacket);
                                if (((LETFTPDataPacket)lETFTPPacket2).getBlockNum() != this.m_blockNum) continue;
                                ((LETFTPDataPacket)lETFTPPacket2).putToFile(this.m_tftpFile, datagramPacket);
                                LETFTPAckPacket lETFTPAckPacket = new LETFTPAckPacket(this.m_blockNum);
                                this.send(lETFTPAckPacket);
                                this.m_blockNum = (short)(this.m_blockNum + 1);
                                this.m_lastPkt = lETFTPAckPacket;
                                if (((LETFTPDataPacket)lETFTPPacket2).getDataLen() >= 512) continue;
                                this.m_state = 4;
                                this.m_lastPktLen = ((LETFTPDataPacket)lETFTPPacket2).getDataLen();
                                return;
                            }
                            if (lETFTPPacket.getOpcode() == 5) {
                                lETFTPPacket2 = new LETFTPErrorPacket(datagramPacket);
                                LETFTPServer.GetServer().printMsg("Error packet containing of type" + Integer.toString(((LETFTPErrorPacket)lETFTPPacket2).getErrorCode()) + "received from client at port" + Integer.toString(this.getRemotePort()));
                                this.m_state = 3;
                                return;
                            }
                            LETFTPServer.GetServer().printMsg("Unexpected packet received from client" + Integer.toString(this.getRemotePort()));
                            continue;
                        }
                        lETFTPPacket = new LETFTPErrorPacket(5, "");
                        this.send(lETFTPPacket);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (n++ < LETFTPServer.GetServer().getMaxRetries()) {
                        this.send(this.m_lastPkt);
                        continue;
                    }
                    LETFTPServer.GetServer().printMsg("Client at port" + Integer.toString(this.getRemotePort()) + "timed out");
                    this.m_state = 3;
                    return;
                }
                break;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public String getType() {
        return "WRITE";
    }

    public int getBytesTransferred() {
        if (this.m_state == 1 || this.m_state == 2 || this.m_state == 3) {
            return this.m_blockNum * 512;
        }
        if (this.m_state == 4) {
            return (this.m_blockNum - 1) * 512 + this.m_lastPktLen;
        }
        return 0;
    }
}

