/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;

public class LEBackupReqPage
extends LEWizardDataPage
implements ItemListener,
ActionListener {
    public static final String NO_FILE = "You did not specify a backup file.";
    public static final String BROWSE = "Browse";
    private static final String INSTRUCTION_TAG = "BACKUPREQ_INST";
    private static final String HELP_TAG = "Back_Up";
    private static final String TITLE_TAG = "BACKUPREQ_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Frame m_topFrame = LEUiUtils.GetBaseFrame();
    Checkbox m_backup;
    Label m_loclabel;
    LETextField m_location;
    Button m_browse;
    PropertyResourceBundle m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);

    public LEBackupReqPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        String string = new String("Do you want to make a backup file?");
        this.m_component = new Label(string);
        Panel panel = new Panel();
        panel.add(this.m_component);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_backup = new Checkbox("Yes", true, checkboxGroup);
        this.m_backup.addItemListener(this);
        panel.add(this.m_backup);
        Checkbox checkbox = new Checkbox("No", false, checkboxGroup);
        checkbox.addItemListener(this);
        panel.add(checkbox);
        this.m_panel.add((Component)panel, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        string = new String("Set the location of your backup file:");
        this.m_loclabel = new Label(string);
        this.m_panel.add((Component)this.m_loclabel, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_location = new LETextField(50);
        this.m_location.setLimitLength(false);
        String string2 = LEAppInfo.getUserAppDir();
        String string3 = this.m_model.get(LEPMWizardModel.BACKUP_FILE);
        ((TextComponent)this.m_location).setText(LEAppInfo.createFullPath(string2, string3));
        this.m_panel.add((Component)this.m_location, this.m_gbc);
        this.m_gbc.insets.right = 0;
        this.m_gbc.insets.left = 0;
        this.m_browse = new Button(BROWSE);
        this.m_browse.setActionCommand(BROWSE);
        this.m_browse.addActionListener(this);
        this.m_panel.add((Component)this.m_browse, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        if (this.m_backup.getState()) {
            String string = this.m_location.getText();
            String string2 = System.getProperty("file.separator");
            int n = string.lastIndexOf(string2);
            String string3 = string.substring(n + 1);
            String string4 = string.substring(0, n);
            if (string3.equals("") || string4.equals("")) {
                this.m_problem = NO_FILE;
                return false;
            }
            this.m_model.set(LEPMWizardModel.BACKUP_DIR, string4);
            this.m_model.set(LEPMWizardModel.BACKUP_FILE, string3);
        } else {
            this.m_model.set(LEPMWizardModel.BACKUP_DIR, "");
            this.m_model.set(LEPMWizardModel.BACKUP_FILE, "");
        }
        return true;
    }

    public Panel getPanel() {
        Panel panel = this.m_panel;
        if (this.m_panel == null) {
            this.m_panel = panel = this.createPanel();
        } else {
            this.m_loclabel.setEnabled(true);
            if (!this.m_backup.getState()) {
                this.m_loclabel.setEnabled(false);
            }
            this.m_loclabel.invalidate();
            this.m_loclabel.validate();
        }
        return panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_backup.getState()) {
            this.m_loclabel.setEnabled(true);
            this.m_location.setEnabled(true);
            this.m_browse.setEnabled(true);
            return;
        }
        this.m_loclabel.setEnabled(false);
        this.m_location.setEnabled(false);
        this.m_browse.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BROWSE)) {
            this.browse();
        }
    }

    private void browse() {
        String string = this.m_location.getText();
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        String string3 = string.substring(n + 1);
        String string4 = string.substring(0, n);
        FileDialog fileDialog = new FileDialog(this.m_topFrame, "Save Configuration", 1);
        fileDialog.setDirectory(string4);
        fileDialog.setFile(string3);
        fileDialog.show();
        string4 = fileDialog.getDirectory();
        string3 = fileDialog.getFile();
        if (string3 != null) {
            String string5 = LEAppInfo.createFullPath(string4, string3);
            ((TextComponent)this.m_location).setText(string5);
        }
    }
}

