/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.util.PropertyResourceBundle;

public class LEOSPFInterfacePage
extends LEWizardDataPage {
    public static final String BAD_COST = "You need to enter a cost between 1 and 65535";
    public static final String BAD_HELLO = "You need to enter a hello time between 10 and 120 seconds.";
    public static final String BAD_DEAD = "You need to enter a dead time between 40 and 1200 seconds.";
    private static final String INSTRUCTION_TAG = "OSPFINTERFACE_INST";
    private static final String HELP_TAG = "OSPFINTERFACE_HELP";
    private static final String TITLE_TAG = "OSPFINTERFACE_TITLE";
    private static final String LABEL_TAG = "OSPFINTERFACE_LABEL";
    LETextField m_cost;
    LETextField m_hello;
    LETextField m_dead;
    Choice m_inter;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource;

    public LEOSPFInterfacePage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage("wiz.gif");
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(this.m_resource.getString(HELP_TAG));
    }

    public Panel createPanel() {
        super.createPanel();
        new Panel();
        String string = new String(this.m_resource.getString(LABEL_TAG));
        this.m_component = new Label(string);
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_component = new Label("Enter the OSPF cost:");
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_cost = new LETextField(5);
        ((TextComponent)this.m_cost).setText(this.m_model.get(LEPMWizardModel.OSPF_COST));
        this.m_cost.setNumeric(true);
        this.m_panel.add((Component)this.m_cost, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_component = new Label("Enter the OSPF hello interval:");
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_hello = new LETextField(3);
        ((TextComponent)this.m_hello).setText(this.m_model.get(LEPMWizardModel.OSPF_HELLO));
        this.m_hello.setNumeric(true);
        this.m_panel.add((Component)this.m_hello, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_component = new Label("Enter the OSPF dead time:");
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_dead = new LETextField(4);
        ((TextComponent)this.m_dead).setText(this.m_model.get(LEPMWizardModel.OSPF_DEADTIME));
        this.m_dead.setNumeric(true);
        this.m_panel.add((Component)this.m_dead, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_component = new Label("Set the interface as:");
        this.m_panel.add(this.m_component, this.m_gbc);
        this.m_inter = new Choice();
        this.m_inter.addItem("nbma");
        this.m_inter.addItem("point-to-multipoint");
        this.m_inter.addItem("wan-as-stub-ptmp");
        String string2 = this.m_model.get(LEPMWizardModel.OSPF_INTERFACE);
        this.m_inter.select(string2);
        this.m_panel.add((Component)this.m_inter, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        String string = this.m_cost.getText();
        int n = Integer.parseInt(string);
        if (n < 1 || n > 65535) {
            this.m_problem = BAD_COST;
            return false;
        }
        String string2 = this.m_hello.getText();
        int n2 = Integer.parseInt(string2);
        if (n2 < 10 || n2 > 120) {
            this.m_problem = BAD_HELLO;
            return false;
        }
        String string3 = this.m_dead.getText();
        int n3 = Integer.parseInt(string3);
        if (n3 < 40 || n3 > 1200) {
            this.m_problem = BAD_DEAD;
            return false;
        }
        this.m_model.set(LEPMWizardModel.OSPF_COST, string);
        this.m_model.set(LEPMWizardModel.OSPF_HELLO, string2);
        this.m_model.set(LEPMWizardModel.OSPF_DEADTIME, string3);
        this.m_model.set(LEPMWizardModel.OSPF_INTERFACE, this.m_inter.getSelectedItem());
        return true;
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("ospf");
        }
        return s_template_keys;
    }
}

