/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LEActionClient;
import com.lucent.ra.nms.ui.LEActionDialog;
import com.lucent.ra.nms.ui.LEStatusBar;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.wizard.LEWizardAction;
import com.lucent.ra.nms.wizard.LEWizardActionClient;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import java.awt.Component;
import java.net.ConnectException;
import java.net.NoRouteToHostException;

public class LEPMConnectAction
extends LEWizardAction
implements LEActionClient {
    public static final String IP_DONE = "SetupIPDone";
    public static final String CONFIG_PROBLEM = "Could not retrieve the configuration information.";
    static final String NO_DEVICE = "Could not find the device with the specified IP Address.  Make sure the device is on the same subnet.";
    static final String BAD_PASSWORD_MSG = "You entered a wrong password for this device.";
    static final String UNKNOWN_PROBLEM = "An unknown problem has occurred, please restart the wizard.";
    static final String SOCKET_EXCEPTION = "The BootP server could not start because another application is using the socket.";
    static final String SECURITY_EXCEPTION = "The BootP server could not start because you don't have the necessary privledges.";
    static final String CONNECTION_REFUSED = "Connection to the specified address was refused.";
    static final String UNKNOWN_HOST = "Could not find the specified host.";
    static final String SUCCESS = "Successful Connection.";
    static final int CONNECTED = 0;
    static final int NO_RESPONSE = -1;
    static final int BAD_PASSWORD = -2;
    static final int NO_SOCKET = -4;
    static final int SECURITY = -5;
    static final int CONNECT_FAILURE = -6;
    static final int UNKNOWN_FAILURE = -20;
    boolean m_connected;
    boolean m_canceled = false;
    LEActionDialog m_connectDlg;
    String m_problem;
    LEStatusBar m_status;
    LEPortMaster m_pm;
    LEStatusManager m_manager;

    public LEPMConnectAction(LEWizardDataModel lEWizardDataModel, LEWizardActionClient lEWizardActionClient) {
        super(lEWizardDataModel, lEWizardActionClient);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Connecting...");
        this.setupDialog();
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        this.m_status = lEActionDialog.getStatusBar();
        this.m_status.setStatusText("Connecting to device");
        this.setupPM();
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (!this.m_connected) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            this.m_client.actionDone(this, this.m_problem, -1);
            return;
        }
        this.m_model.set(LEPMWizardModel.CONNECTED, "on");
        this.m_client.actionDone(this, "", 0);
    }

    public void actionCancel(LEActionDialog lEActionDialog) {
        this.m_canceled = true;
        if (this.m_pm != null) {
            this.m_pm.disconnect();
            this.m_pm = null;
        }
        this.m_model.set(LEPMWizardModel.CONNECTED, "off");
        this.m_client.actionDone(this, "", -3);
    }

    void setupDialog() {
        this.m_manager = new LEStatusManager();
        this.m_connectDlg = new LEActionDialog(LEUiUtils.GetBaseFrame(), "Connecting...", this, this.m_manager);
        ((Component)this.m_connectDlg).setVisible(true);
        new Thread(this.m_connectDlg).start();
    }

    private int connectToPM() {
        LEConnectionManager lEConnectionManager = (LEConnectionManager)this.m_model.getObject(LEPMWizardModel.CONNECTION_MGR);
        try {
            this.m_pm = LEPMFactory.GetFromPM(lEConnectionManager, this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", this.m_model.get(LEPMWizardModel.ADMIN_PASSWORD));
            if (this.m_pm != null && this.m_pm.isConnected()) {
                this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
            }
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            try {
                this.m_pm = LEPMFactory.GetFromPM(lEConnectionManager, this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", "");
                if (this.m_pm != null && this.m_pm.isConnected()) {
                    this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException2) {
                return -2;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return -20;
            }
        }
        catch (LEDSSException lEDSSException) {
            LEDebug.getLog().logln(20, lEDSSException);
            return -20;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            return -1;
        }
        catch (ConnectException connectException) {
            LEDebug.getLog().logln(20, connectException);
            return -6;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return -20;
        }
        if (this.m_model.getObject(LEPMWizardModel.PORTMASTER) == null) {
            this.m_connected = false;
            return -1;
        }
        this.m_connected = true;
        return 0;
    }

    private void setupPM() {
        try {
            int n = this.connectToPM();
            switch (n) {
                case 0: {
                    this.m_status.setStatusText("Connected, getting configuration...");
                    if (!this.m_model.getModelInfo()) {
                        this.m_status.setStatusText("Could not get configuration!");
                        this.m_problem = CONFIG_PROBLEM;
                        return;
                    }
                    break;
                }
                case -2: {
                    this.m_status.setStatusText("Incorrect password");
                    this.m_problem = BAD_PASSWORD_MSG;
                    return;
                }
                case -5: {
                    this.m_problem = SECURITY_EXCEPTION;
                    return;
                }
                case -4: {
                    this.m_problem = SOCKET_EXCEPTION;
                    return;
                }
                case -6: {
                    this.m_problem = CONNECTION_REFUSED;
                    return;
                }
                case -20: {
                    this.m_problem = NO_DEVICE;
                    return;
                }
                case -1: {
                    this.m_problem = UNKNOWN_HOST;
                    return;
                }
                default: {
                    this.m_problem = UNKNOWN_PROBLEM;
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.m_status.setStatusText("Could not connect.");
            LEDebug.getLog().logln(20, exception);
        }
    }
}

