/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.pmwizard.LEAdmin_Page;
import com.lucent.ra.nms.pmwizard.LEPMBootpAction;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEBusyPanel;
import com.lucent.ra.nms.ui.LEConfirmClient;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEImageView;
import com.lucent.ra.nms.ui.LEMultiLineLabel;
import com.lucent.ra.nms.ui.LEProgressPanel;
import com.lucent.ra.nms.ui.LETitleBar;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.wizard.LEWizardActionClient;
import com.lucent.ra.nms.wizard.LEWizardActionIterator;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import com.lucent.ra.nms.wizard.LEWizardDataPage;
import com.lucent.ra.nms.wizard.LEWizardModelIterator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;

public abstract class LEWizMainPanel
extends Frame
implements ActionListener,
WindowListener,
LEWizardActionClient,
LEConfirmClient {
    public static final String PREVIOUS = "previous";
    public static final String NEXT = "next";
    public static final String NEXTACTION = "nextaction";
    public static final String CANCEL = "cancel";
    public static final String CONFIG = "config";
    public static final String HELP = "help";
    protected boolean m_exit = false;
    protected Button m_previous;
    protected Button m_next;
    protected Button m_cancel;
    protected Button m_config;
    protected Button m_help;
    protected LEProgressPanel m_progress;
    protected int m_screenWidth;
    protected int m_screenHeight;
    private Button m_dummy;
    protected LEImageView m_imageView;
    protected LETitleBar m_panelTitle;
    protected Panel m_mainPanel;
    protected Panel m_configPanel;
    protected Panel m_currentPanel;
    protected LEMultiLineLabel m_instructions;
    protected LEWizardDataPage m_currentPage;
    protected LEWizardDataModel m_model;
    protected LEWizardModelIterator m_wizardIterator;
    protected LEWizardActionIterator m_actionIterator;
    protected Panel m_buttonPanel;
    protected CardLayout m_cardlayout;
    protected Hashtable m_wizardPanels;
    protected LEAMManager_RI m_amm;
    protected LEConnectionManager m_cm;
    protected LEAMRouter_RI m_router;

    protected void createDataFrame() {
        BorderLayout borderLayout = new BorderLayout(10, 10);
        this.setLayout(borderLayout);
        Panel panel = new Panel(new FlowLayout(1, 0, 0));
        Image image = this.m_currentPage.getImage();
        this.m_imageView = image instanceof Image ? new LEImageView(this.m_currentPage.getImage()) : new LEImageView("");
        LEBorderPanel lEBorderPanel = new LEBorderPanel(2);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add((Component)this.m_imageView, "Center");
        panel.add("Center", lEBorderPanel);
        this.add((Component)panel, "West");
        this.m_panelTitle = new LETitleBar(this.m_currentPage.getTitle(), 1);
        this.m_panelTitle.setFont(LEFont.getBoldFont());
        this.add((Component)this.m_panelTitle, "North");
        this.m_mainPanel = this.mainPanel();
        this.add((Component)this.m_mainPanel, "Center");
        this.m_buttonPanel = this.buttonPanel();
        this.add((Component)this.m_buttonPanel, "South");
        this.m_dummy = new Button();
        this.m_dummy.addActionListener(this);
        if (this.m_wizardIterator.atBeginning()) {
            this.m_previous.setEnabled(false);
        }
        if (this.m_wizardIterator.atEnd()) {
            this.m_next.setEnabled(false);
        }
        int n = 640;
        int n2 = 480;
        int n3 = this.m_screenWidth / 2 - n / 2;
        int n4 = this.m_screenHeight / 2 - n2 / 2;
        ((Component)this).setLocation(n3, n4);
        ((Component)this).setSize(n, n2);
    }

    protected Panel buttonPanel() {
        Insets insets;
        Panel panel = new Panel(new BorderLayout());
        LETitleBar lETitleBar = new LETitleBar();
        lETitleBar.setBorder(1);
        panel.add((Component)lETitleBar, "North");
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets = new Insets(5, 20, 5, 0);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        Button button = this.m_cancel = new Button("Cancel");
        this.m_cancel.addActionListener(this);
        this.m_cancel.setActionCommand(CANCEL);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        button = this.m_previous = new Button("< Back");
        this.m_previous.addActionListener(this);
        this.m_previous.setActionCommand(PREVIOUS);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 0;
        ++gridBagConstraints.gridx;
        button = this.m_next = new Button("Next  >");
        this.m_next.addActionListener(this);
        this.m_next.setActionCommand(NEXT);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        button = this.m_config = new Button("Configure");
        this.m_config.addActionListener(this);
        this.m_config.setActionCommand(CONFIG);
        this.m_config.setEnabled(false);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        this.m_help = new Button("Help...");
        this.m_help.addActionListener(this);
        this.m_help.setActionCommand(HELP);
        panel2.add((Component)this.m_help, gridBagConstraints);
        panel.add((Component)panel2, "South");
        return panel;
    }

    protected Panel mainPanel() {
        Panel panel = new Panel(new BorderLayout(15, 15));
        this.m_instructions = new LEMultiLineLabel(this.m_currentPage.getInstructions());
        this.m_instructions.setMinHeight(100);
        this.m_instructions.setBorder(10);
        panel.add((Component)this.m_instructions, "North");
        Panel panel2 = this.m_currentPage.getPanel();
        if (this.m_wizardPanels.get(this.m_currentPage.getTitle()) == null) {
            this.m_wizardPanels.put(this.m_currentPage.getTitle(), panel2);
            this.m_currentPanel.add(this.m_currentPage.getTitle(), panel2);
        }
        this.m_cardlayout.show(this.m_currentPanel, this.m_currentPage.getTitle());
        panel.add((Component)this.m_currentPanel, "Center");
        return panel;
    }

    protected void setInstructions(String string) {
        this.m_mainPanel.remove(this.m_instructions);
        this.m_instructions = new LEMultiLineLabel(string);
        this.m_mainPanel.add((Component)this.m_instructions, "North");
    }

    protected Panel configurePanel() {
        Panel panel = new Panel(new BorderLayout());
        panel.setBackground(Color.lightGray);
        this.m_progress = new LEProgressPanel((LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER));
        panel.add((Component)this.m_progress, "North");
        Panel panel2 = new Panel(new BorderLayout(0, 0));
        Panel panel3 = new Panel(new FlowLayout(1, 0, 0));
        this.m_cancel = new Button("Cancel");
        panel3.add(this.m_cancel);
        panel2.add((Component)panel3, "Center");
        LEBusyPanel lEBusyPanel = new LEBusyPanel(0);
        panel2.add((Component)lEBusyPanel, "East");
        lEBusyPanel.startFlash();
        panel.add((Component)panel2, "South");
        this.m_cancel.addActionListener(this);
        this.m_cancel.setActionCommand(CANCEL);
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PREVIOUS)) {
            this.previousPage();
            return;
        }
        if (string.equals(NEXT)) {
            this.nextPage();
            return;
        }
        if (string.equals(NEXTACTION)) {
            this.gotoNextPage();
            return;
        }
        if (string.equals(CANCEL)) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
            if (lEPortMaster instanceof LEPortMaster) {
                lEPortMaster.disconnect();
            }
            this.exit();
            return;
        }
        if (string.equals(HELP)) {
            this.showHelp();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    protected void nextPage() {
        if (!this.m_currentPage.processPanelData()) {
            new LEErrorDialog((Frame)this, this.m_currentPage.describePanelProblem());
            return;
        }
        if (this.m_currentPage instanceof LEAdmin_Page && this.m_model.getObject(LEPMWizardModel.PORTMASTER) == null) {
            LEPMBootpAction lEPMBootpAction = new LEPMBootpAction(this.m_model, this);
            lEPMBootpAction.start();
            return;
        }
        this.gotoNextPage();
    }

    protected void previousPage() {
        if (!this.m_wizardIterator.atBeginning()) {
            this.m_currentPage = null;
            this.m_currentPage = this.m_wizardIterator.previousPage();
            this.m_panelTitle.setTitle(this.m_currentPage.getTitle());
            this.setInstructions(this.m_currentPage.getInstructions());
            this.m_next.setEnabled(true);
            this.m_cardlayout.show(this.m_currentPanel, this.m_currentPage.getTitle());
            this.m_panelTitle.repaint();
            this.m_config.setEnabled(false);
        } else {
            this.m_previous.setEnabled(false);
        }
        this.invalidate();
        this.validate();
    }

    protected void setupConfiguration() {
        ((Component)this).setVisible(false);
        this.removeAll();
        this.m_mainPanel = this.configurePanel();
        this.add((Component)this.m_mainPanel, "Center");
        this.pack();
        Dimension dimension = this.getSize();
        int n = this.m_screenWidth / 2 - dimension.width / 2;
        int n2 = this.m_screenHeight / 2 - dimension.height / 2;
        ((Component)this).setLocation(n, n2);
        ((Component)this).setVisible(true);
    }

    public void actionCancel(String string) {
        this.exit();
    }

    protected void triggerNextPage() {
        try {
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, NEXTACTION);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected abstract void initialize(LEWizardDataModel var1);

    protected abstract void gotoNextPage();

    protected abstract void exit();

    public abstract void actionStart(Object var1, String var2);

    public abstract void updateStatus(Object var1, String var2, int var3);

    public abstract void actionDone(Object var1, String var2, int var3);

    public abstract void confirmAction(String var1, Object var2);

    public abstract void cancelAction(Object var1);

    protected abstract void showHelp();
}

