/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LEDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;

public class LECompGrid
extends Panel {
    int[] m_widths;
    int[] m_heights;
    Component[][] m_comps;
    boolean m_colDiv;
    boolean m_bottomDiv;
    int m_border;
    int m_totalWidth;
    int m_totalHeight;

    public LECompGrid(Component[][] componentArray, int n, boolean bl) {
        this.setLayout(null);
        this.m_comps = componentArray;
        this.m_border = n;
        this.m_colDiv = bl;
        int n2 = this.m_comps.length;
        int n3 = n2 > 0 ? this.m_comps[0].length : 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                if (this.m_comps[n4][n5] != null) {
                    this.add(this.m_comps[n4][n5]);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public LECompGrid(Component[][] componentArray, int n) {
        this(componentArray, n, false);
    }

    public void setColumnDivider(boolean bl) {
        this.m_colDiv = bl;
    }

    public void setBottomDivider(boolean bl) {
        this.m_bottomDiv = bl;
    }

    public int getHeight() {
        return this.m_totalHeight;
    }

    public int getWidth() {
        return this.m_totalWidth;
    }

    public int[] getHeights() {
        if (this.m_heights == null) {
            this.calculateLayout();
        }
        return this.m_heights;
    }

    public int[] getWidths() {
        if (this.m_widths == null) {
            this.calculateLayout();
        }
        return this.m_widths;
    }

    public int getRows() {
        return this.m_comps.length;
    }

    public int getColumns() {
        if (this.m_comps.length == 0) {
            return 0;
        }
        return this.m_comps[0].length;
    }

    public Component getComponent(int n, int n2) {
        if (this.m_comps != null && this.m_comps.length > 0 && n < this.m_comps.length && n2 < this.m_comps[0].length) {
            return this.m_comps[n][n2];
        }
        return null;
    }

    public void setHeights(int[] nArray) {
        this.m_heights = nArray;
        this.m_totalHeight = 0;
        int n = 0;
        while (n < this.m_heights.length) {
            this.m_totalHeight += this.m_heights[n];
            ++n;
        }
    }

    public void setWidths(int[] nArray) {
        this.m_widths = nArray;
        this.m_totalWidth = 0;
        int n = 0;
        while (n < this.m_widths.length) {
            this.m_totalWidth += this.m_widths[n];
            ++n;
        }
        if (this.m_colDiv) {
            this.m_totalWidth += 2 * this.m_widths.length;
        }
    }

    public Dimension getMinimumSize() {
        if (this.m_heights == null) {
            this.calculateLayout();
        }
        return new Dimension(this.m_totalWidth, this.m_totalHeight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void redraw() {
        this.doLayout();
    }

    public synchronized void doLayout() {
        try {
            if (this.m_heights == null) {
                this.calculateLayout();
            }
            int n = 0;
            int n2 = 2 * this.m_border;
            int n3 = 0;
            while (n3 < this.m_heights.length) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.m_widths.length) {
                    if (this.m_comps[n3][n5] != null) {
                        Dimension dimension = this.m_comps[n3][n5].getPreferredSize();
                        int n6 = Math.min(dimension.height, this.m_heights[n3]);
                        int n7 = Math.min(dimension.width, this.m_widths[n5] - n2);
                        this.m_comps[n3][n5].setBounds(n4 + this.m_border, n + (this.m_heights[n3] - n6) / 2, n7, n6);
                    }
                    n4 += this.m_widths[n5];
                    if (this.m_colDiv) {
                        n4 += 2;
                    }
                    ++n5;
                }
                n += this.m_heights[n3];
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_widths != null && this.m_colDiv) {
            graphics.setColor(Color.gray);
            int n = this.m_widths.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                graphics.drawLine(n2 += this.m_widths[n3], 0, n2, this.m_totalHeight + 1);
                graphics.drawLine(++n2, 0, n2, this.m_totalHeight + 1);
                ++n2;
                ++n3;
            }
        }
        if (this.m_bottomDiv) {
            graphics.setColor(Color.gray);
            graphics.drawLine(0, this.m_totalHeight - 2, this.m_totalWidth, this.m_totalHeight - 2);
            graphics.drawLine(0, this.m_totalHeight - 1, this.m_totalWidth, this.m_totalHeight - 1);
        }
    }

    void calculateLayout() {
        try {
            this.m_totalHeight = 0;
            this.m_heights = new int[this.m_comps.length];
            int n = this.m_comps.length > 0 ? this.m_comps[0].length : 0;
            this.m_widths = new int[n];
            int n2 = 2 * this.m_border;
            int n3 = 0;
            while (n3 < this.m_heights.length) {
                this.m_heights[n3] = 0;
                int n4 = 0;
                while (n4 < this.m_widths.length) {
                    if (n3 == 0) {
                        this.m_widths[n4] = 0;
                    }
                    if (this.m_comps[n3][n4] != null) {
                        Dimension dimension = this.m_comps[n3][n4].getPreferredSize();
                        this.m_widths[n4] = Math.max(this.m_widths[n4], dimension.width + n2);
                        this.m_heights[n3] = Math.max(this.m_heights[n3], dimension.height + n2);
                    }
                    ++n4;
                }
                this.m_totalHeight += this.m_heights[n3];
                ++n3;
            }
            if (this.m_bottomDiv) {
                this.m_totalHeight += 2;
            }
            this.m_totalWidth = 0;
            int n5 = 0;
            while (n5 < this.m_widths.length) {
                this.m_totalWidth += this.m_widths[n5];
                ++n5;
            }
            if (this.m_colDiv) {
                this.m_totalWidth += 2 * this.m_widths.length;
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

