/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEFiller;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollable;
import com.lucent.ra.nms.ui.LEScrollablePanel;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;

public class LECompMatrix2
extends Panel
implements LEScrollable {
    static final int BORDER = 2;
    int m_rows;
    int m_cols;
    LECompGrid m_cgrid;
    LECompGrid m_rowTitles;
    LECompGrid m_colTitles;
    LEScrollablePanel m_gridScroll;
    LEScrollablePanel m_ctScroll;
    LEScrollablePanel m_rtScroll;
    LEFiller m_filler;
    boolean m_colDiv;

    public LECompMatrix2(Component[][] componentArray, Component[][] componentArray2, Component[][] componentArray3) {
        this(componentArray, componentArray2, componentArray3, false);
    }

    public LECompMatrix2(Component[][] componentArray, Component[][] componentArray2, Component[][] componentArray3, boolean bl) {
        this.setLayout(null);
        this.m_colDiv = bl;
        this.m_cgrid = new LECompGrid(componentArray3, 2, bl);
        this.m_rowTitles = new LECompGrid(componentArray, 2, bl);
        this.m_colTitles = new LECompGrid(componentArray2, 2, bl);
        this.m_colTitles.setBottomDivider(true);
        this.m_gridScroll = new LEScrollablePanel(this.m_cgrid, false, false);
        this.m_ctScroll = new LEScrollablePanel(this.m_colTitles, false, false);
        this.m_rtScroll = new LEScrollablePanel(this.m_rowTitles, false, false);
        this.m_filler = new LEFiller();
        this.add(this.m_gridScroll);
        this.add(this.m_rtScroll);
        this.add(this.m_ctScroll);
        this.add(this.m_filler);
        this.m_rows = componentArray.length;
        this.m_cols = componentArray2[0].length;
    }

    public void setColumnDivider(boolean bl) {
        if (this.m_cgrid != null) {
            this.m_cgrid.setColumnDivider(bl);
        }
    }

    public Component getComponent(int n, int n2) {
        if (this.m_cgrid != null) {
            return this.m_cgrid.getComponent(n, n2);
        }
        return null;
    }

    public Component getRowTitle(int n, int n2) {
        if (this.m_rowTitles != null) {
            return this.m_rowTitles.getComponent(n, n2);
        }
        return null;
    }

    public Component getColTitle(int n, int n2) {
        if (this.m_colTitles != null) {
            return this.m_colTitles.getComponent(n, n2);
        }
        return null;
    }

    public void doLayout() {
        try {
            this.calculateLayout();
            Dimension dimension = this.getSize();
            int n = this.m_rowTitles.getWidth();
            int n2 = this.m_colTitles.getHeight();
            this.m_filler.setBounds(0, 0, n, n2);
            this.m_ctScroll.setBounds(n, 0, dimension.width - n, n2);
            this.m_rtScroll.setBounds(0, n2, n, dimension.height - n2);
            this.m_gridScroll.setBounds(n, n2, dimension.width - n, dimension.height - n2);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
    }

    public void setOrigin(int n, int n2) {
        this.m_ctScroll.setOrigin(n, 0);
        this.m_rtScroll.setOrigin(0, n2);
        this.m_gridScroll.setOrigin(n, n2);
    }

    public void startScroll() {
        this.m_ctScroll.startScroll();
        this.m_rtScroll.startScroll();
        this.m_gridScroll.startScroll();
    }

    public void scrollTo(int n, int n2) {
        this.m_ctScroll.scrollTo(n, 0);
        this.m_rtScroll.scrollTo(0, n2);
        this.m_gridScroll.scrollTo(n, n2);
    }

    public void endScroll() {
        this.m_ctScroll.endScroll();
        this.m_rtScroll.endScroll();
        this.m_gridScroll.endScroll();
        this.m_cgrid.redraw();
        this.m_colTitles.redraw();
        this.m_rowTitles.redraw();
    }

    public Dimension getMinimumSize() {
        return this.totalArea();
    }

    public Dimension getPreferredSize() {
        return this.totalArea();
    }

    public Dimension totalArea() {
        this.calculateLayout();
        int n = this.m_rowTitles.getWidth() + this.m_cgrid.getWidth();
        int n2 = this.m_colTitles.getHeight() + this.m_cgrid.getHeight();
        return new Dimension(n, n2);
    }

    void calculateLayout() {
        try {
            int n;
            int n2;
            int[] nArray = this.m_cgrid.getWidths();
            int[] nArray2 = this.m_colTitles.getWidths();
            int[] nArray3 = new int[this.m_cols];
            if (nArray == null || nArray2 == null) {
                return;
            }
            int n3 = 0;
            while (n3 < this.m_cols) {
                n2 = n3 < nArray.length ? nArray[n3] : 0;
                n = n3 < nArray2.length ? nArray2[n3] : 0;
                nArray3[n3] = Math.max(n2, n);
                ++n3;
            }
            int[] nArray4 = this.m_cgrid.getHeights();
            int[] nArray5 = this.m_rowTitles.getHeights();
            int[] nArray6 = new int[this.m_rows];
            int n4 = 0;
            while (n4 < nArray6.length) {
                n2 = n4 < nArray4.length ? nArray4[n4] : 0;
                n = n4 < nArray5.length ? nArray5[n4] : 0;
                nArray6[n4] = Math.max(n2, n);
                ++n4;
            }
            this.m_cgrid.setHeights(nArray6);
            this.m_cgrid.setWidths(nArray3);
            this.m_rowTitles.setHeights(nArray6);
            this.m_colTitles.setWidths(nArray3);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

