/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEGridTitles;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEGridColTitles
extends LEGridTitles {
    int[] m_widths;
    boolean m_colDiv;

    public LEGridColTitles(String[] stringArray, int n, boolean bl) {
        super(stringArray, n);
        this.m_colDiv = bl;
    }

    public int[] getWidths() {
        if (this.m_widths == null) {
            this.calculateLayout();
        }
        return this.m_widths;
    }

    public void setWidths(int[] nArray) {
        this.m_widths = nArray;
        this.m_width = 0;
        int n = 0;
        while (n < this.m_widths.length) {
            this.m_width += this.m_widths[n];
            ++n;
        }
        if (this.m_colDiv) {
            this.m_width += 2 * this.m_widths.length;
        }
    }

    void drawTitles() {
        Dimension dimension = this.getSize();
        int n = Math.max(this.m_width, dimension.width);
        int n2 = Math.max(this.m_height, dimension.height);
        this.m_buf = this.createImage(n, n2);
        Graphics graphics = this.m_buf.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        int n4 = this.m_border + fontMetrics.getAscent();
        int n5 = 0;
        while (n5 < this.m_titles.length) {
            if (this.m_titles[n5] != null) {
                int n6 = (this.m_widths[n5] - fontMetrics.stringWidth(this.m_titles[n5])) / 2;
                graphics.drawString(this.m_titles[n5], n3 + n6, n4);
            }
            n3 += this.m_widths[n5];
            if (this.m_colDiv) {
                graphics.setColor(Color.gray);
                graphics.drawLine(n3, n2 / 2, n3, n2);
                graphics.drawLine(++n3, n2 / 2, n3, n2);
                ++n3;
                graphics.setColor(Color.black);
            }
            ++n5;
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.dispose();
    }

    void calculateLayout() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.dispose();
        Font font = this.getFont();
        this.setFont(new Font(font.getFamily(), 1, font.getSize()));
        graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 2 * this.m_border;
        this.m_height = fontMetrics.getHeight() + n + 2;
        this.m_widths = new int[this.m_titles.length];
        int n2 = 0;
        while (n2 < this.m_titles.length) {
            this.m_widths[n2] = n;
            if (this.m_titles[n2] != null) {
                int n3 = n2;
                this.m_widths[n3] = this.m_widths[n3] + fontMetrics.stringWidth(this.m_titles[n2]);
            }
            ++n2;
        }
    }
}

