/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEMultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int WIDTH = 1;
    static final int HEIGHT = 2;
    String m_label;
    int m_just;
    int m_width;
    int m_height;
    int m_sideBased;
    int m_border;

    public LEMultiLineLabel(String string, int n) {
        this.m_label = string;
        this.m_just = n;
    }

    public LEMultiLineLabel(String string) {
        this(string, 0);
    }

    public void setMinWidth(int n) {
        this.m_width = n;
    }

    public void setMinHeight(int n) {
        this.m_height = n;
    }

    public void setText(String string) {
        this.m_label = string;
        this.repaint();
    }

    public void setBorder(int n) {
        this.m_border = n;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        this.determineSize();
        return new Dimension(this.m_width, this.m_height);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        String string;
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getForeground());
        int n = dimension.width - 2 * this.m_border;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getLeading() + fontMetrics.getAscent();
        int n3 = this.m_border;
        int n4 = this.m_label.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            char c;
            if (Character.isWhitespace(c = this.m_label.charAt(n9++))) {
                n8 = n9 - 1;
                n6 += n5;
                n5 = 0;
            }
            if (c == '\n') {
                string = this.m_label.substring(n7, n8);
                this.drawString(graphics, string, n, n6, n3, n2, this.m_just);
                n6 = 0;
                n2 += fontMetrics.getHeight() + fontMetrics.getLeading();
                n7 = n8 + 1;
                continue;
            }
            if (n6 + (n5 += fontMetrics.charWidth(c)) <= n) continue;
            if (n7 > n8) {
                n9 = n4;
                continue;
            }
            string = this.m_label.substring(n7, n8);
            this.drawString(graphics, string, n, n6, n3, n2, this.m_just);
            n6 = 0;
            n2 += fontMetrics.getHeight() + fontMetrics.getLeading();
            n7 = n8 + 1;
        }
        string = this.m_label.substring(n7, n4);
        this.drawString(graphics, string, n, n6 + n5, n3, n2, this.m_just);
    }

    void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 1: {
                n3 += (n - n2) / 2;
                break;
            }
            case 2: {
                n3 += n - n2;
                break;
            }
        }
        graphics.drawString(string, n3, n4);
    }

    void determineSize() {
        Dimension dimension = this.getSize();
        int n = dimension.width - 2 * this.m_border;
        int n2 = Math.max(n, this.m_width);
        int n3 = Math.max(dimension.height, this.m_height);
        if (n2 == 0 && n3 == 0) {
            return;
        }
        if (this.m_sideBased == 0) {
            this.m_sideBased = n2 == 0 ? 2 : 1;
        }
        this.m_width = 0;
        this.m_height = 0;
        if (this.m_label == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        int n4 = fontMetrics.getHeight() + fontMetrics.getLeading();
        int n5 = this.m_label.length();
        this.m_height = fontMetrics.getLeading();
        if (this.m_sideBased == 1 && n2 > 0) {
            char c = '.';
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n5) {
                if (Character.isWhitespace(c = (char)this.m_label.charAt(n8++))) {
                    n7 += n6;
                    n6 = 0;
                }
                if (c == '\n') {
                    this.m_height += n4;
                    continue;
                }
                if (n7 + (n6 += fontMetrics.charWidth(c)) <= n2) continue;
                n7 = 0;
                this.m_height += n4;
            }
            this.m_width = n2;
            this.m_height += n4;
            return;
        }
        if (this.m_sideBased == 2 && n3 > 0) {
            int n9 = n3 / n4;
            if (n9 == 0) {
                ++n9;
            }
            int n10 = n5 / n9;
            this.m_width = fontMetrics.getMaxAdvance() * n10 * 2 / 3;
            this.m_height = n3;
        }
    }
}

