/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class LELog {
    public static final int NONE = 0;
    public static final int LOW = 10;
    public static final int MEDIUM = 20;
    public static final int HIGH = 30;
    public static final int FULL = 40;
    public static final int TAB_INDENT = 0;
    public static final int SPACE_INDENT = 1;
    protected PrintWriter m_printWriter;
    protected int m_logLevel;
    protected boolean m_timeStamp;
    protected String m_indentBuf;

    public LELog() {
        this.init();
    }

    public LELog(OutputStream outputStream) {
        this.init();
        this.m_printWriter = new PrintWriter(outputStream, true);
    }

    public LELog(Writer writer) {
        this.init();
        this.m_printWriter = new PrintWriter(writer, true);
    }

    public LELog(PrintWriter printWriter) {
        this.init();
        this.m_printWriter = printWriter;
    }

    public synchronized PrintWriter getPrintWriter() {
        return this.m_printWriter;
    }

    public synchronized int getLogLevel() {
        return this.m_logLevel;
    }

    public synchronized void setLogLevel(int n) {
        this.m_logLevel = n;
    }

    public synchronized void startLogging() {
        this.m_logLevel = 40;
    }

    public synchronized void stopLogging() {
        this.m_logLevel = 0;
    }

    public synchronized void setTimeStamp(boolean bl) {
        this.m_timeStamp = bl;
    }

    public synchronized void setIndent(int n, int n2) {
        char[] cArray = new char[n];
        int n3 = n2 == 0 ? 9 : 32;
        int n4 = 0;
        while (n4 < n) {
            cArray[n4] = n3;
            ++n4;
        }
        this.m_indentBuf = new String(cArray);
    }

    public synchronized boolean shouldLog(int n) {
        return this.m_printWriter != null && this.m_logLevel > 0 && this.m_logLevel >= n;
    }

    public synchronized void logTime(int n) {
        if (this.shouldLog(n)) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
            this.m_printWriter.print(dateFormat.format(date));
            this.m_printWriter.print(' ');
        }
    }

    public synchronized void loglnTime(int n) {
        if (this.shouldLog(n)) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
            this.m_printWriter.print(this.m_indentBuf);
            this.m_printWriter.println(dateFormat.format(date));
        }
    }

    public synchronized void log(int n, String string) {
        if (this.shouldLog(n)) {
            this.printHeader(null);
            this.m_printWriter.print(string);
        }
    }

    public synchronized void log(int n, String string, char c) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(c);
        }
    }

    public synchronized void log(int n, String string, int n2) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(n2);
        }
    }

    public synchronized void log(int n, String string, long l) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(l);
        }
    }

    public synchronized void log(int n, String string, float f) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(f);
        }
    }

    public synchronized void log(int n, String string, double d) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(d);
        }
    }

    public synchronized void log(int n, String string, boolean bl) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(bl);
        }
    }

    public synchronized void log(int n, String string, String string2) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(string2);
        }
    }

    public synchronized void log(int n, String string, char[] cArray) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.print(cArray);
        }
    }

    public synchronized void logln(int n) {
        if (this.shouldLog(n)) {
            this.m_printWriter.println();
        }
    }

    public synchronized void logln(int n, String string) {
        if (this.shouldLog(n)) {
            this.printHeader(null);
            this.m_printWriter.println(string);
            this.m_printWriter.flush();
        }
    }

    public synchronized void logln(int n, String string, char c) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(c);
        }
    }

    public synchronized void logln(int n, String string, int n2) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(n2);
        }
    }

    public synchronized void logln(int n, String string, long l) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(l);
        }
    }

    public synchronized void logln(int n, String string, float f) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(f);
        }
    }

    public synchronized void logln(int n, String string, double d) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(d);
        }
    }

    public synchronized void logln(int n, String string, boolean bl) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(bl);
        }
    }

    public synchronized void logln(int n, String string, String string2) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(string2);
        }
    }

    public synchronized void logln(int n, String string, char[] cArray) {
        if (this.shouldLog(n)) {
            this.printHeader(string);
            this.m_printWriter.println(cArray);
        }
    }

    protected void init() {
        this.m_logLevel = 40;
        this.m_timeStamp = false;
        this.setIndent(0, 1);
    }

    protected synchronized void printHeader(String string) {
        this.m_printWriter.print(this.m_indentBuf);
        if (this.m_timeStamp) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
            this.m_printWriter.print(dateFormat.format(date));
            this.m_printWriter.print(' ');
        }
        this.printOtherHeader();
        if (string != null && string.length() > 0) {
            this.m_printWriter.print(string);
            this.m_printWriter.print(' ');
        }
    }

    protected synchronized void printOtherHeader() {
    }
}

