/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import java.io.Serializable;

public class LEQueue
implements Cloneable,
Serializable {
    public static final int INCREMENT = 10;
    Object[] m_elements;
    int m_count = 0;
    int m_capacity;
    int m_head;

    public LEQueue() {
        this.m_capacity = 10;
        this.m_elements = new Object[10];
    }

    public LEQueue(int n) {
        this.m_capacity = n;
        this.m_elements = new Object[this.m_capacity];
    }

    public synchronized Object clone() {
        LEQueue lEQueue = new LEQueue(this.m_capacity);
        System.arraycopy(this.m_elements, 0, lEQueue.m_elements, 0, this.m_capacity);
        lEQueue.m_count = this.m_count;
        lEQueue.m_head = this.m_head;
        return lEQueue;
    }

    public int size() {
        return this.m_count;
    }

    public synchronized void add(Object object) {
        if (this.m_count == this.m_capacity) {
            this.grow();
        }
        int n = (this.m_head + this.m_count) % this.m_capacity;
        this.m_elements[n] = object;
        ++this.m_count;
    }

    public synchronized Object next() {
        Object object = null;
        if (this.m_count > 0) {
            object = this.m_elements[this.m_head];
            this.m_elements[this.m_head++] = null;
            if (this.m_head == this.m_capacity) {
                this.m_head = 0;
            }
            --this.m_count;
        }
        return object;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.m_capacity) {
            this.m_elements[n] = null;
            ++n;
        }
        this.m_count = 0;
        this.m_head = 0;
    }

    void grow() {
        Object[] objectArray = new Object[this.m_capacity + 10];
        int n = this.m_capacity - this.m_head;
        if (this.m_count > n) {
            System.arraycopy(this.m_elements, this.m_head, objectArray, 0, n);
            System.arraycopy(this.m_elements, 0, objectArray, n, this.m_count - n);
        } else {
            System.arraycopy(this.m_elements, this.m_head, objectArray, 0, this.m_count);
        }
        this.m_head = 0;
        this.m_elements = objectArray;
        this.m_capacity += 10;
    }
}

