/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;

public class LETokenizer
implements Serializable {
    byte[] m_data;
    int m_ptr;

    public LETokenizer(byte[] byArray) {
        this.m_data = byArray;
    }

    public int getNextByte() {
        if (this.m_ptr == this.m_data.length) {
            return -1;
        }
        return this.m_data[this.m_ptr++];
    }

    public int getNextInt() throws IOException, NumberFormatException {
        return Integer.parseInt(this.getNextQuotedString());
    }

    public long getNextLong() throws IOException, NumberFormatException {
        return Long.parseLong(this.getNextQuotedString());
    }

    public byte[] getNextRawBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)this.getNextByte();
            ++n2;
        }
        return byArray;
    }

    public long getNextHex() throws IOException, NumberFormatException {
        return Long.parseLong(this.getNextQuotedString(), 16);
    }

    public String getNextQuotedString() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.skipBlanks();
        if (n != 34) {
            bl2 = true;
        } else {
            n = this.getNextByte();
        }
        while (!bl) {
            switch (n) {
                case -1: 
                case 0: {
                    if (stringBuffer.length() == 0) {
                        throw new EOFException();
                    }
                }
                case 34: {
                    bl = true;
                    break;
                }
                case 9: 
                case 10: 
                case 32: {
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    stringBuffer.append((char)n);
                    n = this.getNextByte();
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                    n = this.getNextByte();
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getNextString() throws IOException {
        StringBuffer stringBuffer;
        block8: {
            boolean bl = false;
            stringBuffer = new StringBuffer();
            try {
                int n = this.skipBlanks();
                while (!bl) {
                    switch (n) {
                        case -1: 
                        case 0: {
                            if (stringBuffer.length() == 0) {
                                throw new EOFException();
                            }
                        }
                        case 9: 
                        case 10: 
                        case 32: {
                            bl = true;
                            break;
                        }
                        default: {
                            stringBuffer.append((char)n);
                            n = this.getNextByte();
                            break;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                if (stringBuffer.length() != 0) break block8;
                throw eOFException;
            }
        }
        return stringBuffer.toString();
    }

    public void skip(int n) throws IOException {
        if (n > this.m_data.length - this.m_ptr) {
            throw new EOFException();
        }
        this.m_ptr += n;
    }

    protected int skipBlanks() throws IOException {
        boolean bl = true;
        int n = this.getNextByte();
        while (bl) {
            if (n == -1) {
                throw new EOFException();
            }
            if (n != 32 && n != 9) {
                bl = false;
                continue;
            }
            n = this.getNextByte();
        }
        return n;
    }

    public void getToken(byte by, String string) throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            int n = this.getNextByte();
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 32 || n == 9) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
    }

    public void reset() throws IOException {
        this.m_ptr = 0;
    }

    public void skipToken() throws IOException {
        boolean bl = false;
        int n = this.skipBlanks();
        if (n == 32 || n == 9) {
            bl = true;
            n = this.getNextByte();
            if (n == -1) {
                throw new EOFException();
            }
            if (n != 32 && n != 9) {
                bl = false;
            }
        }
        while (!bl) {
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 32 || n == 9) {
                bl = true;
                continue;
            }
            n = this.getNextByte();
        }
    }
}

