/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import com.lucent.ra.nms.util.LECompare;
import com.lucent.ra.nms.util.LEVectorEnum;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class LEVector
implements Cloneable,
Serializable {
    Object[] m_elements;
    int m_count;
    int m_increment;
    int m_capacity;
    static final int s_defIncrement = 10;

    public LEVector() {
        this.m_count = 0;
        this.m_increment = 10;
        this.m_capacity = 10;
        this.m_elements = new Object[this.m_capacity];
    }

    public LEVector(int n) {
        this.m_count = 0;
        this.m_increment = 10;
        this.m_capacity = n > this.m_increment ? n : this.m_increment;
        this.m_elements = new Object[this.m_capacity];
    }

    public LEVector(Vector vector) {
        this.m_count = vector.size();
        this.m_elements = new Object[this.m_count];
        int n = 0;
        while (n < this.m_count) {
            this.m_elements[n] = vector.elementAt(n);
            ++n;
        }
        this.m_capacity = this.m_count;
        this.m_increment = 10;
    }

    public synchronized void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Vector) {
            this.addVector((Vector)object);
            return;
        }
        if (object instanceof LEVector) {
            this.addVector((LEVector)object);
            return;
        }
        this.addElement(object);
    }

    public synchronized void addElement(Object object) {
        this.realloc(this.m_count + 1);
        this.m_elements[this.m_count++] = object;
    }

    public synchronized void addElementUnique(Object object) {
        if (!this.contains(object)) {
            this.realloc(this.m_count + 1);
            this.m_elements[this.m_count++] = object;
        }
    }

    public synchronized void addUnique(Object object) {
        if (object instanceof Vector) {
            this.addVectorUnique((Vector)object);
            return;
        }
        if (object instanceof LEVector) {
            this.addVectorUnique((LEVector)object);
            return;
        }
        this.addElementUnique(object);
    }

    public synchronized void addVector(LEVector lEVector) {
        int n = lEVector.size();
        this.realloc(this.m_count + n);
        System.arraycopy(lEVector.m_elements, 0, this.m_elements, this.m_count, n);
        this.m_count += n;
    }

    public synchronized void addVector(Vector vector) {
        int n = 0;
        int n2 = this.m_count;
        int n3 = this.m_count + vector.size();
        this.realloc(n3);
        n = n2;
        int n4 = 0;
        while (n < n3) {
            this.m_elements[n] = vector.elementAt(n4);
            ++this.m_count;
            ++n;
            ++n4;
        }
    }

    public synchronized void addVectorUnique(LEVector lEVector) {
        int n = 0;
        int n2 = this.m_count;
        int n3 = this.m_count + lEVector.size();
        this.realloc(n3);
        n = n2;
        int n4 = 0;
        while (n < n3) {
            this.addUnique(lEVector.elementAt(n4));
            ++n;
            ++n4;
        }
    }

    public synchronized void addVectorUnique(Vector vector) {
        int n = 0;
        int n2 = this.m_count;
        int n3 = this.m_count + vector.size();
        this.realloc(n3);
        n = n2;
        int n4 = 0;
        while (n < n3) {
            this.addUnique(vector.elementAt(n4));
            ++n;
            ++n4;
        }
    }

    public synchronized Object clone() {
        LEVector lEVector = new LEVector();
        lEVector.addVector(this);
        return lEVector;
    }

    public synchronized boolean contains(Object object) {
        int n = 0;
        while (n < this.m_count) {
            if (this.m_elements[n] == null ? object == null : this.m_elements[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void dump(PrintStream printStream) {
        printStream.print(this.toString());
    }

    public synchronized Enumeration elements() {
        return new LEVectorEnum(this);
    }

    public synchronized Object elementAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.m_count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_elements[n];
    }

    public synchronized Object firstElement() throws NoSuchElementException {
        if (this.m_count == 0) {
            throw new NoSuchElementException();
        }
        return this.m_elements[0];
    }

    public synchronized int indexOf(Object object) {
        int n = 0;
        n = 0;
        while (n < this.m_count) {
            if (this.m_elements[n] == null ? object == null : this.m_elements[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.m_count == this.m_capacity) {
            this.m_capacity += this.m_increment;
            Object[] objectArray = new Object[this.m_capacity];
            System.arraycopy(this.m_elements, 0, objectArray, 0, n);
            objectArray[n] = object;
            System.arraycopy(this.m_elements, n, objectArray, n + 1, this.m_count - n);
            this.m_elements = objectArray;
        } else {
            int n2 = this.m_count;
            while (n2 > n) {
                this.m_elements[n2] = this.m_elements[n2 - 1];
                --n2;
            }
            this.m_elements[n] = object;
        }
        ++this.m_count;
    }

    public synchronized boolean isEmpty() {
        return this.m_count == 0;
    }

    public synchronized void removeAllElements() {
        this.m_count = 0;
        this.m_capacity = this.m_increment;
        int n = 0;
        while (n < this.m_capacity) {
            this.m_elements[n] = null;
            ++n;
        }
    }

    public synchronized boolean removeElement(Object object) {
        int n = 0;
        boolean bl = false;
        n = 0;
        while (n < this.m_count) {
            if (bl) {
                this.m_elements[n - 1] = this.m_elements[n];
            } else if (this.m_elements[n] == null) {
                if (object == null) {
                    bl = true;
                }
            } else if (this.m_elements[n].equals(object)) {
                this.m_elements[n] = null;
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.m_elements[--this.m_count] = null;
        }
        return bl;
    }

    public synchronized Object removeElementAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.m_count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.m_elements[n];
        int n2 = n + 1;
        while (n2 < this.m_count) {
            this.m_elements[n2 - 1] = this.m_elements[n2];
            ++n2;
        }
        this.m_elements[--this.m_count] = null;
        return object;
    }

    public synchronized Object setElementAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.m_count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object2 = this.m_elements[n];
        this.m_elements[n] = object;
        return object2;
    }

    public synchronized void swapElements(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n2 < 0 || n >= this.m_count || n2 >= this.m_count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.m_elements[n];
        this.m_elements[n] = this.m_elements[n2];
        this.m_elements[n2] = object;
    }

    public synchronized int size() {
        return this.m_count;
    }

    public int setIncrement(int n) {
        int n2 = this.m_increment;
        this.m_increment = n;
        return n2;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("[ ");
        n = 0;
        while (n < this.m_count) {
            if (this.m_elements[n] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.m_elements[n].toString());
            }
            if (n + 1 < this.m_count) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public synchronized String toStringNl() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("[ ");
        n = 0;
        while (n < this.m_count) {
            if (this.m_elements[n] == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.m_elements[n].toString());
            }
            if (n + 1 < this.m_count) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        stringBuffer.append(" ]\n");
        return stringBuffer.toString();
    }

    public synchronized void quickSort(LECompare lECompare) {
        this.sort(lECompare, 0, this.size() - 1, false);
    }

    public synchronized void quickSort(LECompare lECompare, boolean bl) {
        this.sort(lECompare, 0, this.size() - 1, bl);
    }

    public synchronized void quickSort(LECompare lECompare, int n, int n2, boolean bl) {
        this.sort(lECompare, n, n2, bl);
    }

    void sort(LECompare lECompare, int n, int n2, boolean bl) {
        if (n < n2) {
            int n3 = this.partition(lECompare, n, n2, bl);
            this.sort(lECompare, n, n3 - 1, bl);
            this.sort(lECompare, n3 + 1, n2, bl);
        }
    }

    int partition(LECompare lECompare, int n, int n2, boolean bl) {
        this.swap(n, (n + n2) / 2);
        Object object = this.m_elements[n];
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (!bl && lECompare.compare(this.m_elements[n4], object) < 0 || bl && lECompare.compare(this.m_elements[n4], object) > 0) {
                this.swap(++n3, n4);
            }
            ++n4;
        }
        this.swap(n, n3);
        int n5 = n3;
        return n5;
    }

    void swap(int n, int n2) {
        Object object = this.m_elements[n];
        this.m_elements[n] = this.m_elements[n2];
        this.m_elements[n2] = object;
    }

    synchronized void realloc(int n) {
        if (n < this.m_count || n <= this.m_capacity) {
            return;
        }
        this.m_capacity = (n / this.m_increment + 1) * this.m_increment;
        Object[] objectArray = this.m_elements;
        this.m_elements = new Object[this.m_capacity];
        System.arraycopy(objectArray, 0, this.m_elements, 0, this.m_count);
    }
}

