/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.netboot.LEBootPDatabaseMgr;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEProperties;
import com.lucent.ra.nms.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class NBBootpDatabasePanel
extends Frame
implements ActionListener,
WindowListener,
LEMLListener {
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_CLOSE = "close";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_EDIT = "edit";
    static final String PROP_BOOTPDATA_X = "bootpdata_x";
    static final String PROP_BOOTPDATA_Y = "bootpdata_y";
    static final String PROP_BOOTPDATA_W = "bootpdata_w";
    static final String PROP_BOOTPDATA_H = "bootpdata_h";
    static final String PROP_BOOTPDATA_LIST_H = "bootpdata_list_h";
    static NBBootpDatabasePanel s_panel;
    NBBootpDatabaseForm m_bootpForm;
    Panel m_buttons;
    Button m_edit;
    Button m_delete;
    boolean m_changed;
    boolean m_isIconified;
    static Image s_main32;
    static Image s_main16;
    MenuBar m_menubar;
    Rectangle m_bounds;
    int m_bootpDataListH = 150;

    public static void Display() {
        if (s_panel == null) {
            s_panel = new NBBootpDatabasePanel();
            return;
        }
        if (s_panel.isIconified()) {
            s_panel.dispose();
            s_panel = new NBBootpDatabasePanel();
            return;
        }
        ((Component)s_panel).setVisible(true);
        s_panel.show();
        s_panel.setActiveDimension();
    }

    private NBBootpDatabasePanel() {
        super("BOOTP Server Database");
        LEUiUtils.SetBaseFrame(this);
        LEColor.CheckColorFlags();
        this.m_changed = false;
        this.m_isIconified = false;
        this.loadProperties();
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        this.m_bootpForm = new NBBootpDatabaseForm();
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_bootpForm);
        this.add("Center", lEScrollPanel);
        this.add("South", this.createButtons());
        this.m_bootpForm.addListener(this);
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
        this.setInitialDimension();
        try {
            s_main32 = LEResource.GetImage("lucent_32.gif");
            s_main16 = LEResource.GetImage("lucent_16.gif");
            if (s_main32 != null) {
                this.setIconImage(s_main32);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 6) {
            LEDebug.getLog().logln(20, "Received onLMLeEvent " + lEMLEvent.getType());
            if (this.m_edit.isEnabled()) {
                this.edit(lEMLEvent.getRow());
                return;
            }
        } else if (lEMLEvent.getType() == 3) {
            this.setState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_CLOSE)) {
            this.saveProperties();
            ((Component)this).setVisible(false);
            return;
        }
        if (string.equals(ACTION_IMPORT)) {
            this.importFile();
            this.m_changed = true;
            return;
        }
        if (string.equals(ACTION_EXPORT)) {
            this.exportFile();
            return;
        }
        if (string.equals(ACTION_ADD)) {
            NBBootpDialog nBBootpDialog = new NBBootpDialog((Frame)this, null, null);
            if (nBBootpDialog.okay()) {
                LEBootPDatabaseMgr.GetManager().add(nBBootpDialog.getMacAddr(), nBBootpDialog.getIPAddr());
                this.m_changed = true;
                return;
            }
        } else if (string.equals(ACTION_EDIT)) {
            int[] nArray = this.m_bootpForm.getSelectedRows();
            if (nArray.length == 1) {
                this.edit(nArray[0]);
                this.m_changed = true;
                return;
            }
        } else {
            if (string.equals(ACTION_DELETE)) {
                this.delete();
                this.m_changed = true;
                return;
            }
            LEDebug.getLog().logln(20, "Unknown LEConsole Action: " + string);
        }
    }

    void edit(int n) {
        String string;
        String string2 = (String)this.m_bootpForm.getCellItem(n, 0);
        NBBootpDialog nBBootpDialog = new NBBootpDialog((Frame)this, string2, string = (String)this.m_bootpForm.getCellItem(n, 1));
        if (nBBootpDialog.okay()) {
            LEBootPDatabaseMgr.GetManager().delete(string2);
            LEBootPDatabaseMgr.GetManager().add(nBBootpDialog.getMacAddr(), nBBootpDialog.getIPAddr());
        }
    }

    void delete() {
        int[] nArray = this.m_bootpForm.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.m_bootpForm.getCellItem(nArray[n], 0);
            String cfr_ignored_0 = (String)this.m_bootpForm.getCellItem(nArray[n], 1);
            LEBootPDatabaseMgr.GetManager().delete(string);
            ++n;
        }
        this.m_bootpForm.deleteRows(nArray);
    }

    void setState() {
        int[] nArray = this.m_bootpForm.getSelectedRows();
        if (nArray.length > 0) {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(true);
            }
            if (this.m_edit != null) {
                if (nArray.length == 1) {
                    this.m_edit.setEnabled(true);
                    return;
                }
                this.m_edit.setEnabled(false);
                return;
            }
        } else {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(false);
            }
            if (this.m_edit != null) {
                this.m_edit.setEnabled(false);
            }
        }
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Import From File...");
        menuItem.setActionCommand(ACTION_IMPORT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Export To File...");
        menuItem.setActionCommand(ACTION_EXPORT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Close");
        menuItem.setActionCommand(ACTION_CLOSE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    private Panel createButtons() {
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 5, 5));
        Button button = new Button("Add...");
        panel.add(button);
        button.setActionCommand(ACTION_ADD);
        button.addActionListener(this);
        this.m_edit = new Button("Edit...");
        panel.add(this.m_edit);
        this.m_edit.setActionCommand(ACTION_EDIT);
        this.m_edit.addActionListener(this);
        this.m_edit.setEnabled(false);
        this.m_delete = new Button("Delete");
        panel.add(this.m_delete);
        this.m_delete.setActionCommand(ACTION_DELETE);
        this.m_delete.addActionListener(this);
        this.m_delete.setEnabled(false);
        Button button2 = new Button("Close");
        panel.add(button2);
        button2.setActionCommand(ACTION_CLOSE);
        button2.addActionListener(this);
        button2.setEnabled(true);
        this.m_buttons.add(panel);
        Panel panel2 = new Panel();
        panel2.setBackground(LEColor.getBackground());
        panel2.setLayout(new BorderLayout(5, 5));
        panel2.add("Center", this.m_buttons);
        return panel2;
    }

    private void importFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Import From File", 0);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            File file = new File(string3);
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                LEBootPDatabaseMgr.GetManager().createDatabase(bufferedReader);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                new LEErrorDialog(LEUiUtils.getFrame(this), "Could not find file " + string3);
                return;
            }
        }
    }

    private void exportFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Export To File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            LEBootPDatabaseMgr.GetManager().save(string3);
        }
    }

    void loadProperties() {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 400;
            int n4 = 300;
            String string = LEProperties.GetProperty(PROP_BOOTPDATA_X);
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_BOOTPDATA_Y)) != null) {
                n2 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_BOOTPDATA_W)) != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_BOOTPDATA_H)) != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_BOOTPDATA_LIST_H)) != null) {
                this.m_bootpDataListH = Integer.parseInt(string);
            }
            this.m_bounds = new Rectangle(n, n2, n3, n4);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void saveProperties() {
        Rectangle rectangle = this.getBounds();
        LEProperties.SetProperty(PROP_BOOTPDATA_X, Integer.toString(rectangle.x));
        LEProperties.SetProperty(PROP_BOOTPDATA_Y, Integer.toString(rectangle.y));
        LEProperties.SetProperty(PROP_BOOTPDATA_W, Integer.toString(rectangle.width));
        LEProperties.SetProperty(PROP_BOOTPDATA_H, Integer.toString(rectangle.height));
        LEProperties.SetProperty(PROP_BOOTPDATA_W, Integer.toString(rectangle.width));
        Dimension dimension = this.m_bootpForm.getSize();
        if (dimension.height < 0) {
            LEProperties.SetProperty(PROP_BOOTPDATA_LIST_H, "0");
        } else {
            LEProperties.SetProperty(PROP_BOOTPDATA_LIST_H, Integer.toString(dimension.height));
        }
        LEProperties.SaveProperties();
    }

    void setInitialDimension() {
        int n = 0;
        int n2 = 0;
        int n3 = 400;
        int n4 = 300;
        if (this.m_bounds != null) {
            n = this.m_bounds.x;
            n2 = this.m_bounds.y;
            n3 = this.m_bounds.width;
            n4 = this.m_bounds.height;
        }
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
    }

    void setActiveDimension() {
        this.m_bounds = this.getBounds();
        int n = this.m_bounds.x;
        int n2 = this.m_bounds.y;
        int n3 = this.m_bounds.width;
        int n4 = this.m_bounds.height;
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this) {
            this.saveProperties();
            ((Component)this).setVisible(false);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.m_isIconified = false;
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.m_isIconified = true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean isIconified() {
        return this.m_isIconified;
    }
}

