/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPClient;
import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPReadClient;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import java.net.DatagramPacket;
import java.util.Enumeration;
import java.util.Hashtable;

public class LETFTPClientFactory
extends LEObservable {
    Hashtable m_clients = new Hashtable();

    LETFTPClientFactory() {
    }

    public void addConnection(DatagramPacket datagramPacket) {
        LETFTPPacket lETFTPPacket = new LETFTPPacket(datagramPacket);
        if (lETFTPPacket.getOpcode() == 1) {
            LETFTPReadClient lETFTPReadClient = new LETFTPReadClient(datagramPacket);
            String string = lETFTPReadClient.getRemoteAddress().getHostAddress();
            this.m_clients.put(string, lETFTPReadClient);
            this.notifyObservers(lETFTPReadClient);
            return;
        }
        if (lETFTPPacket.getOpcode() == 2) {
            LETFTPServer.GetServer().printMsg("TFTP Write Request received - functionality not supported");
            return;
        }
        LETFTPServer.GetServer().printMsg("Packet is unknown");
    }

    public void closeConnections() {
        if (this.m_clients.isEmpty()) {
            return;
        }
        try {
            Enumeration enumeration = this.m_clients.keys();
            while (enumeration.hasMoreElements()) {
                LETFTPClient lETFTPClient = (LETFTPClient)this.m_clients.get(enumeration.nextElement());
                lETFTPClient.terminate();
            }
            this.m_clients.clear();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public LETFTPClient getClient(String string) {
        return (LETFTPClient)this.m_clients.get(string);
    }
}

