/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPAckPacket;
import com.lucent.ra.nms.netboot.LETFTPClient;
import com.lucent.ra.nms.netboot.LETFTPDataPacket;
import com.lucent.ra.nms.netboot.LETFTPErrorPacket;
import com.lucent.ra.nms.netboot.LETFTPInFile;
import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPReqPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEDebug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;

public class LETFTPReadClient
extends LETFTPClient
implements Runnable {
    public static final int TFTP_READ_BLOCK_SIZE = 512;
    private Thread m_clientThread;
    private short m_blockNum;
    private LETFTPInFile m_tftpFile;
    private LETFTPDataPacket m_lastPkt;
    private long m_timeLastPktSent;

    LETFTPReadClient(DatagramPacket datagramPacket) {
        super(datagramPacket);
        LETFTPReqPacket lETFTPReqPacket = new LETFTPReqPacket(datagramPacket);
        LETFTPServer.GetServer().printMsg("Packet received:");
        lETFTPReqPacket.printPacket();
        this.setFilePath(LETFTPServer.GetServer().getBaseDir(), lETFTPReqPacket.getFileName());
        this.m_lastPkt = this.sendFirstPacket();
        if (this.m_lastPkt != null) {
            if (this.m_lastPkt.getDataLen() == 512) {
                this.m_clientThread = new Thread(this);
                this.m_clientThread.start();
                this.m_state = 1;
                return;
            }
            this.m_state = 4;
        }
    }

    private LETFTPDataPacket sendFirstPacket() {
        try {
            this.m_tftpFile = new LETFTPInFile(this.getFilePath(), 512);
            this.m_blockNum = 1;
            LETFTPDataPacket lETFTPDataPacket = new LETFTPDataPacket(this.m_tftpFile, this.m_blockNum);
            LETFTPServer.GetServer().printMsg("Sending Data of length " + lETFTPDataPacket.getDataLen());
            this.sendDataPkt(lETFTPDataPacket);
            return lETFTPDataPacket;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LETFTPServer.GetServer().printMsg("File Not Found: " + this.getFilePath());
            LETFTPErrorPacket lETFTPErrorPacket = new LETFTPErrorPacket(1, "");
            this.send(lETFTPErrorPacket);
            this.m_state = 3;
            return null;
        }
        catch (SecurityException securityException) {
            LETFTPServer.GetServer().printMsg("Could not read File: " + this.getFilePath());
            LETFTPErrorPacket lETFTPErrorPacket = new LETFTPErrorPacket(2, "");
            this.send(lETFTPErrorPacket);
            this.m_state = 3;
            return null;
        }
        catch (IOException iOException) {
            LETFTPServer.GetServer().printMsg("Exception when reading File: " + this.getFilePath());
            LETFTPErrorPacket lETFTPErrorPacket = new LETFTPErrorPacket(0, "");
            this.send(lETFTPErrorPacket);
            this.m_state = 3;
            return null;
        }
    }

    public void run() {
        block14: {
            int n = 0;
            byte[] byArray = new byte[4];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.m_state = 2;
            try {
                this.getSocket().setSoTimeout(LETFTPServer.GetServer().getTimeoutInterval() * 1000);
                while (true) {
                    try {
                        while (true) {
                            LETFTPPacket lETFTPPacket;
                            this.getSocket().receive(datagramPacket);
                            LETFTPServer.GetServer().printMsg("Received packet ");
                            if (datagramPacket.getPort() == this.getRemotePort()) {
                                LETFTPPacket lETFTPPacket2;
                                lETFTPPacket = new LETFTPPacket(datagramPacket);
                                if (lETFTPPacket.getOpcode() == 4) {
                                    lETFTPPacket2 = new LETFTPAckPacket(datagramPacket);
                                    if (((LETFTPAckPacket)lETFTPPacket2).getBlockNum() == this.m_blockNum) {
                                        this.m_blockNum = (short)(this.m_blockNum + 1);
                                        LETFTPDataPacket lETFTPDataPacket = new LETFTPDataPacket(this.m_tftpFile, this.m_blockNum);
                                        LETFTPServer.GetServer().printMsg("Sending Block " + Integer.toString(this.m_blockNum) + " of length " + lETFTPDataPacket.getDataLen() + " to port " + this.getSocket().getLocalPort());
                                        this.sendDataPkt(lETFTPDataPacket);
                                        n = 0;
                                        if (lETFTPDataPacket.getDataLen() >= 512) continue;
                                        LETFTPServer.GetServer().printMsg("Reached EOF ");
                                        this.m_state = 4;
                                        return;
                                    }
                                    LETFTPServer.GetServer().printMsg("Invalid block number " + Integer.toString(((LETFTPAckPacket)lETFTPPacket2).getBlockNum()));
                                    long l = System.currentTimeMillis();
                                    int n2 = this.getNewTimeout(l);
                                    if (n2 != 0) {
                                        this.getSocket().setSoTimeout(n2);
                                        continue;
                                    }
                                    if (this.resendLastPkt(n++)) continue;
                                    this.m_state = 3;
                                    return;
                                }
                                if (lETFTPPacket.getOpcode() == 5) {
                                    lETFTPPacket2 = new LETFTPErrorPacket(datagramPacket);
                                    LETFTPServer.GetServer().printMsg("Error packet received from client on port " + Integer.toString(this.getSocket().getLocalPort()));
                                    ((LETFTPErrorPacket)lETFTPPacket2).printPacket();
                                    this.m_state = 3;
                                    return;
                                }
                                if (lETFTPPacket.getOpcode() == 1) {
                                    LETFTPServer.GetServer().printMsg("Received Read Request on port sending data");
                                    LETFTPServer.GetServer().printMsg("Sending first packet");
                                    this.m_lastPkt = this.sendFirstPacket();
                                    if (this.m_lastPkt != null) {
                                        if (this.m_lastPkt.getDataLen() == 512) continue;
                                        this.m_state = 4;
                                        return;
                                    }
                                    break block14;
                                }
                                LETFTPServer.GetServer().printMsg("Unexpected packet received from client on port " + Integer.toString(this.getSocket().getLocalPort()));
                                long l = System.currentTimeMillis();
                                int n3 = this.getNewTimeout(l);
                                if (n3 != 0) {
                                    this.getSocket().setSoTimeout(n3);
                                    continue;
                                }
                                if (this.resendLastPkt(n++)) continue;
                                this.m_state = 3;
                                return;
                            }
                            lETFTPPacket = new LETFTPErrorPacket(5, "");
                            this.send(lETFTPPacket);
                            this.m_timeLastPktSent = System.currentTimeMillis();
                            LETFTPServer.GetServer().printMsg("Unexpected port" + Integer.toString(datagramPacket.getPort()));
                            ((LETFTPErrorPacket)lETFTPPacket).printPacket();
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        LETFTPServer.GetServer().printMsg("Socket timed out");
                        if (this.resendLastPkt(n++)) continue;
                        this.m_state = 3;
                        return;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    public int getBytesTransferred() {
        if (this.m_state == 1 || this.m_state == 2 || this.m_state == 3) {
            return this.m_blockNum * 512;
        }
        if (this.m_state == 4) {
            return (this.m_blockNum - 1) * 512 + this.m_lastPkt.getDataLen();
        }
        return 0;
    }

    public String getType() {
        return "READ";
    }

    public void terminate() {
        if (this.m_clientThread != null) {
            this.m_clientThread.stop();
            this.m_clientThread = null;
        }
        super.terminate();
    }

    private void sendDataPkt(LETFTPDataPacket lETFTPDataPacket) {
        try {
            this.send(lETFTPDataPacket);
            this.getSocket().setSoTimeout(LETFTPServer.GetServer().getTimeoutInterval() * 1000);
            this.m_timeLastPktSent = System.currentTimeMillis();
            this.m_lastPkt = lETFTPDataPacket;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    private boolean resendLastPkt(int n) {
        if (n < LETFTPServer.GetServer().getMaxRetries()) {
            LETFTPServer.GetServer().printMsg("Resending packet to port " + Integer.toString(this.getSocket().getLocalPort()));
            if (this.m_lastPkt != null) {
                this.sendDataPkt(this.m_lastPkt);
                this.m_lastPkt.printPacket();
            } else {
                LETFTPServer.GetServer().printMsg("Last packet was null");
            }
            return true;
        }
        LETFTPServer.GetServer().printMsg("Sent Max retries for port " + Integer.toString(this.getSocket().getLocalPort()));
        return false;
    }

    private int getNewTimeout(long l) {
        if (this.m_timeLastPktSent == 0L || System.currentTimeMillis() < this.m_timeLastPktSent) {
            return 0;
        }
        if (l - this.m_timeLastPktSent > (long)(LETFTPServer.GetServer().getTimeoutInterval() * 1000)) {
            return 0;
        }
        return (int)((long)(LETFTPServer.GetServer().getTimeoutInterval() * 1000) - (l - this.m_timeLastPktSent));
    }
}

