/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEImageView
extends Canvas
implements ImageObserver {
    public static final int WEST = 0;
    public static final int NORTHWEST = 1;
    public static final int NORTH = 2;
    public static final int NORTHEAST = 3;
    public static final int EAST = 4;
    public static final int SOUTHEAST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTHWEST = 7;
    public static final int CENTER = 8;
    Image m_image;
    boolean m_loaded;
    int m_anchor;

    public LEImageView(Image image, int n) {
        this.m_loaded = this.prepareImage(image, this);
        this.m_image = image;
        this.m_anchor = n;
    }

    public LEImageView(Image image) {
        this(image, 0);
    }

    public LEImageView(String string, int n) {
        this.m_anchor = n;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.m_image = toolkit.getImage(string);
        this.m_loaded = this.prepareImage(this.m_image, this);
    }

    public LEImageView(String string) {
        this(string, 0);
    }

    public void setImage(Image image) {
        this.m_loaded = this.prepareImage(image, this);
        this.m_image = image;
        if (this.m_loaded) {
            this.repaint();
        }
    }

    public void setAnchor(int n) {
        this.m_anchor = n;
        if (this.m_loaded) {
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (this.m_image != null) {
            n = this.m_image.getWidth(this);
            n2 = this.m_image.getHeight(this);
        }
        return new Dimension(n, n2);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (!this.m_loaded) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = this.m_image.getWidth(this);
        int n2 = this.m_image.getHeight(this);
        int n3 = 0;
        int n4 = 0;
        switch (this.m_anchor) {
            case 0: {
                n4 = (dimension.height - n2) / 2;
                break;
            }
            case 2: {
                n3 = (dimension.width - n) / 2;
                break;
            }
            case 3: {
                n3 = dimension.width - n;
                break;
            }
            case 4: {
                n3 = dimension.width - n;
                n4 = (dimension.height - n2) / 2;
                break;
            }
            case 5: {
                n3 = dimension.width - n;
                n4 = dimension.height - n2;
                break;
            }
            case 6: {
                n3 = (dimension.width - n) / 2;
                n4 = dimension.height - n2;
                break;
            }
            case 7: {
                n4 = dimension.height - n2;
                break;
            }
            case 8: {
                n3 = (dimension.width - n) / 2;
                n4 = (dimension.height - n2) / 2;
                break;
            }
        }
        graphics.drawImage(this.m_image, n3, n4, this);
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_loaded = true;
            this.repaint();
            return false;
        }
        return true;
    }
}

