/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEScrollable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEScrollPanel
extends Panel
implements AdjustmentListener,
MouseListener {
    Scrollbar m_horz;
    Scrollbar m_vert;
    LEScrollable m_scrollable;
    int m_x;
    int m_y;
    boolean m_scrolling;

    public LEScrollPanel() {
        this.addMouseListener(this);
        this.setLayout(null);
        this.m_horz = new Scrollbar(0);
        this.m_horz.addAdjustmentListener(this);
        this.m_vert = new Scrollbar(1);
        this.m_vert.addAdjustmentListener(this);
        this.add(this.m_horz);
        this.add(this.m_vert);
    }

    public LEScrollPanel(LEScrollable lEScrollable) {
        this();
        this.addScrollable(lEScrollable);
    }

    public void setScrollable(LEScrollable lEScrollable) {
        this.addScrollable(lEScrollable);
        this.invalidate();
        this.validate();
    }

    public void updateScrollbars(int n, int n2) {
        this.doLayout(new Dimension(n, n2));
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.doLayout();
        this.repaint();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.doLayout();
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.doLayout();
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = -this.m_horz.getValue();
        int n2 = -this.m_vert.getValue();
        if (n != this.m_x || n2 != this.m_y) {
            this.m_x = n;
            this.m_y = n2;
            this.m_scrollable.scrollTo(this.m_x, this.m_y);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        Component component = this.getComponentAt(n2, n = mouseEvent.getY());
        if (component instanceof Scrollbar) {
            this.m_scrolling = true;
            if (this.m_scrollable != null) {
                this.m_scrollable.startScroll();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_scrolling) {
            this.m_scrolling = false;
            if (this.m_scrollable != null) {
                this.m_scrollable.endScroll();
            }
        }
    }

    public synchronized void doLayout() {
        Dimension dimension = this.m_scrollable != null ? this.m_scrollable.totalArea() : new Dimension(0, 0);
        this.doLayout(dimension);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.m_scrollable instanceof Component) {
            Dimension dimension = ((Component)((Object)this.m_scrollable)).getPreferredSize();
            Dimension dimension2 = this.m_vert.getPreferredSize();
            Dimension dimension3 = this.m_horz.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height + dimension3.height);
        }
        return new Dimension(0, 0);
    }

    void addScrollable(LEScrollable lEScrollable) {
        if (this.m_scrollable instanceof Component) {
            this.removeAll();
            this.add(this.m_horz);
            this.add(this.m_vert);
        }
        this.m_scrollable = lEScrollable;
        this.m_scrollable.setScrollPanel(this);
        if (this.m_scrollable instanceof Component) {
            this.add((Component)((Object)this.m_scrollable));
        }
    }

    void doLayout(Dimension dimension) {
        Dimension dimension2 = this.m_vert.getPreferredSize();
        Dimension dimension3 = this.m_horz.getPreferredSize();
        Dimension dimension4 = this.getSize();
        int n = dimension.width - dimension4.width;
        int n2 = dimension.height - dimension4.height;
        this.m_x = 0;
        this.m_y = 0;
        if (n > 0 && n2 > 0) {
            this.m_y = this.manageVSB(true, dimension4.height - dimension3.height, dimension.height, dimension4.width - dimension2.width, 0, dimension2.width, dimension4.height - dimension3.height);
            this.m_x = this.manageHSB(true, dimension4.width - dimension2.width, dimension.width, 0, dimension4.height - dimension3.height, dimension4.width - dimension2.width, dimension3.height);
        } else if (n > 0 && n2 + dimension3.height > 0) {
            this.m_y = this.manageVSB(true, dimension4.height - dimension3.height, dimension.height, dimension4.width - dimension2.width, 0, dimension2.width, dimension4.height - dimension3.height);
            this.m_x = this.manageHSB(true, dimension4.width - dimension2.width, dimension.width, 0, dimension4.height - dimension3.height, dimension4.width - dimension2.width, dimension3.height);
        } else if (n2 > 0 && n + dimension2.width > 0) {
            this.m_y = this.manageVSB(true, dimension4.height - dimension3.height, dimension.height, dimension4.width - dimension2.width, 0, dimension2.width, dimension4.height - dimension3.height);
            this.m_x = this.manageHSB(true, dimension4.width - dimension2.width, dimension.width, 0, dimension4.height - dimension3.height, dimension4.width - dimension2.width, dimension3.height);
        } else if (n > 0) {
            this.m_y = this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.m_x = this.manageHSB(true, dimension4.width, dimension.width, 0, dimension4.height - dimension3.height, dimension4.width, dimension3.height);
        } else if (n2 > 0) {
            this.m_y = this.manageVSB(true, dimension4.height, dimension.height, dimension4.width - dimension2.width, 0, dimension2.width, dimension4.height);
            this.m_x = this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        } else {
            this.m_y = this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.m_x = this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        }
        if (this.m_scrollable != null) {
            int n3 = dimension4.width;
            int n4 = dimension4.height;
            if (this.m_vert.isEnabled()) {
                n3 -= dimension2.width;
            }
            if (this.m_horz.isEnabled()) {
                n4 -= dimension3.height;
            }
            this.m_scrollable.setOrigin(this.m_x, this.m_y);
            if (this.m_scrollable instanceof Component) {
                Component component = (Component)((Object)this.m_scrollable);
                component.setBounds(0, 0, n3, n4);
                component.invalidate();
                component.repaint();
            }
        }
    }

    int manageVSB(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (bl) {
            if (this.m_vert.isEnabled()) {
                n7 = this.m_vert.getValue();
            }
            n7 = -Math.min(n7, n2);
            this.m_vert.setBounds(n3, n4, n5, n6);
            this.m_vert.setValues(-n7, n, 0, n2);
            this.m_vert.setUnitIncrement(20);
            this.m_vert.setBlockIncrement(n6);
            this.m_vert.setEnabled(true);
            this.m_vert.setVisible(true);
        } else {
            this.m_vert.setVisible(false);
            this.m_vert.setEnabled(false);
        }
        return n7;
    }

    int manageHSB(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (bl) {
            if (this.m_horz.isEnabled()) {
                n7 = this.m_horz.getValue();
            }
            n7 = -Math.min(n7, n2);
            this.m_horz.setBounds(n3, n4, n5, n6);
            this.m_horz.setValues(-n7, n, 0, n2);
            this.m_horz.setUnitIncrement(20);
            this.m_horz.setBlockIncrement(n5);
            this.m_horz.setEnabled(true);
            this.m_horz.setVisible(true);
        } else {
            this.m_horz.setVisible(false);
            this.m_horz.setEnabled(false);
        }
        return n7;
    }
}

