/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDeltaModemsMessage;
import COM.livingston.backend.LEMonModemsMessage;

public class LEModem {
    public static final int DEAD = 0;
    public static final int ERROR = 1;
    public static final int ADMIN = 2;
    public static final int TEST = 3;
    public static final int READY = 4;
    public static final int BOUND = 5;
    public static final int CONNECTING = 6;
    public static final int CONNECTED = 7;
    public static final int TX = 8;
    public static final int RX = 9;
    public static final int TXRX = 10;
    public static final String ADMIN_STR = new String("ADM");
    public static final String HALT_STR = new String("HAL");
    public static final String READY_STR = new String("REA");
    public static final String DOWN_STR = new String("DOW");
    public static final String BOUND_STR = new String("BOU");
    public static final String ACTIVE_STR = new String("NRM");
    public static final String CONN_STR = new String("CON");
    public static final String HUNT_STR = new String("HUN");
    public static final String INIT_STR = new String("INI");
    public static final String HALT_DISP_STR = new String("Halt");
    public static final String ERROR_DISP_STR = new String("Error");
    public static final String ADMIN_DISP_STR = new String("Admin");
    public static final String TEST_DISP_STR = new String("Test");
    public static final String READY_DISP_STR = new String("Ready");
    public static final String BOUND_DISP_STR = new String("Bound");
    public static final String CONNECTING_DISP_STR = new String("Connecting");
    public static final String CONNECTED_DISP_STR = new String("Active");
    int m_state;
    int m_rxCount;
    int m_txCount;

    public static int convertState(int n, boolean bl, boolean bl2) {
        int n2 = bl && bl2 && n >= 7 ? 10 : (bl && n >= 7 ? 8 : (bl2 && n >= 7 ? 9 : n));
        return n2;
    }

    public static int convertState(String string, boolean bl, boolean bl2) {
        int n = string.startsWith(HALT_STR) || string.startsWith(INIT_STR) ? LEModem.convertState(0, bl, bl2) : (string.startsWith(ACTIVE_STR) ? LEModem.convertState(7, bl, bl2) : (string.startsWith(ADMIN_STR) ? LEModem.convertState(2, bl, bl2) : (string.startsWith(READY_STR) ? LEModem.convertState(4, bl, bl2) : (string.startsWith(DOWN_STR) ? LEModem.convertState(1, bl, bl2) : (string.startsWith(BOUND_STR) ? LEModem.convertState(5, bl, bl2) : (string.startsWith(CONN_STR) ? LEModem.convertState(6, bl, bl2) : (string.startsWith(HUNT_STR) ? LEModem.convertState(6, bl, bl2) : LEModem.convertState(3, bl, bl2))))))));
        return n;
    }

    public LEModem(int n) {
        this.m_state = n;
    }

    public LEModem(String string) {
        this.m_state = LEModem.convertState(string, false, false);
    }

    public LEModem(LEMonModemsMessage lEMonModemsMessage) {
        String string = lEMonModemsMessage.getState();
        if (string != null) {
            this.m_state = LEModem.convertState(string, false, false);
        }
    }

    public int getState() {
        return this.m_state;
    }

    public String getStateString() {
        String string = READY_DISP_STR;
        switch (this.m_state) {
            case 0: {
                string = HALT_DISP_STR;
                break;
            }
            case 1: {
                string = ERROR_DISP_STR;
                break;
            }
            case 2: {
                string = ADMIN_DISP_STR;
                break;
            }
            case 3: {
                string = TEST_DISP_STR;
                break;
            }
            case 4: {
                string = READY_DISP_STR;
                break;
            }
            case 5: {
                string = BOUND_DISP_STR;
                break;
            }
            case 6: {
                string = CONNECTING_DISP_STR;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = CONNECTED_DISP_STR;
                break;
            }
        }
        return string;
    }

    public void setState(LEDeltaModemsMessage lEDeltaModemsMessage) {
        String string = lEDeltaModemsMessage.getState();
        boolean bl = false;
        boolean bl2 = false;
        if (lEDeltaModemsMessage.getRXCountChanged()) {
            bl = true;
            this.m_rxCount = lEDeltaModemsMessage.getRXCount();
        }
        if (lEDeltaModemsMessage.getTXCountChanged()) {
            bl2 = true;
            this.m_txCount = lEDeltaModemsMessage.getRXCount();
        }
        if (string == null) {
            this.m_state = LEModem.convertState(this.m_state, bl, bl2);
            return;
        }
        this.m_state = LEModem.convertState(string, bl, bl2);
    }

    public void setState(LEMonModemsMessage lEMonModemsMessage) {
        int n;
        String string = lEMonModemsMessage.getState();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = lEMonModemsMessage.getRXCount();
        if (this.m_rxCount != n2) {
            bl = true;
        }
        if (this.m_txCount != (n = lEMonModemsMessage.getTXCount())) {
            bl2 = true;
        }
        this.m_rxCount = n2;
        this.m_txCount = n;
        if (string == null) {
            this.m_state = LEModem.convertState(this.m_state, bl, bl2);
            return;
        }
        this.m_state = LEModem.convertState(string, bl, bl2);
    }

    public void setState(String string, boolean bl, boolean bl2) {
        this.m_state = LEModem.convertState(string, bl, bl2);
    }

    public void setState(int n, boolean bl, boolean bl2) {
        this.m_state = LEModem.convertState(n, bl, bl2);
    }
}

