/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEAsyncPorts;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LEParallelPorts;
import COM.livingston.model.LEPort;
import COM.livingston.model.LESyncPorts;
import COM.livingston.model.LETable;

public class LEPorts
extends LEConfig {
    public static final String ASYNC_PORTS = "AsyncPort";
    public static final String SYNC_PORTS = "SyncPort";
    public static final String ISDN_PORTS = "ISDNPort";
    public static final String PARALLEL_PORTS = "ParallelPort";
    public static final int KEY_COUNT = 4;
    public static final String PPP = "ppp";
    public static final String FRAME_RELAY = "frame";
    public static final String SLIP = "slip";
    public static final String VJ = "vj";
    public static final String STAC = "stac";
    public static final String SECONDS = "seconds";
    public static final String MINUTES = "minutes";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            LEPorts.s_keys[0] = ASYNC_PORTS;
            LEPorts.s_keys[1] = SYNC_PORTS;
            LEPorts.s_keys[2] = ISDN_PORTS;
            LEPorts.s_keys[3] = PARALLEL_PORTS;
        }
        return s_keys;
    }

    public LEPorts(LEConfigFacility lEConfigFacility, String string, String string2) {
        super(lEConfigFacility, string, string2);
    }

    public LEPorts(LEConfigFacility lEConfigFacility) {
        super(lEConfigFacility);
    }

    public LEPort getPort(String string) {
        LETable lETable;
        if (!this.m_fetched) {
            this.fetch();
        }
        LEPort lEPort = null;
        LEAsyncPorts lEAsyncPorts = (LEAsyncPorts)this.get(ASYNC_PORTS);
        if (lEAsyncPorts != null) {
            lEPort = (LEPort)lEAsyncPorts.get(string);
        }
        if (lEPort == null && (lETable = (LESyncPorts)this.get(SYNC_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        if (lEPort == null && (lETable = (LEISDNPorts)this.get(ISDN_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        if (lEPort == null && (lETable = (LEParallelPorts)this.get(PARALLEL_PORTS)) != null) {
            lEPort = (LEPort)lETable.get(string);
        }
        return lEPort;
    }

    public Object clone() {
        LEPorts lEPorts = new LEPorts(this.m_facility, this.m_board, this.m_fetchKey);
        lEPorts.copy(this);
        return lEPorts;
    }

    LEConfig createConfig(String string) {
        LEConfig lEConfig = string.equals(ASYNC_PORTS) ? new LEAsyncPorts(this.m_facility, this.m_board) : (string.equals(SYNC_PORTS) ? new LESyncPorts(this.m_facility, this.m_board) : (string.equals(ISDN_PORTS) ? new LEISDNPorts(this.m_facility, this.m_board) : (string.equals(PARALLEL_PORTS) ? new LEParallelPorts(this.m_facility, this.m_board) : new LEConfig(this.m_facility))));
        return lEConfig;
    }
}

