/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEPMCommand;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class PMReset
extends CLUtil {
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("pmreset");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMReset rp = new PMReset();
        rp.processArgs(args);
        System.exit(0);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        if (args.length < 3) {
            this.checkArgs();
        } else {
            if (LEAppInfo.getFlag("-version") != null) {
                this.printAppInfo();
            }
            this.resetPort(args[args.length - 1]);
        }
    }

    public void resetPort(String portname) {
        LEVector ports = this.processPorts(portname);
        this.connectToPortMaster();
        try {
            int len = ports.size();
            int i = 0;
            while (i < len) {
                String port = (String)ports.elementAt(i);
                String cmd = new String("reset " + port);
                LEPMCommand result = this.m_pm.execute(cmd);
                if (!result.getStatus()) {
                    System.out.println("Error in resetting port: " + result.getResult());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error in resetting port: " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            this.disconnect();
        }
        this.disconnect();
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("<\"ports\">");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("<\"ports\"> : specifies the ports to reset.  Ports can be specified ");
        System.out.println("on an individual basis (\"s1\"), as a comma separated list (\"s1,s2,s4\"), ");
        System.out.println("as a group (\"s1-s4\"), or any combination of above (\"s1,s4,s6-s10\").");
        System.out.println("You can also specify \"all\" and all ports will be reset.");
    }

    private LEVector processPorts(String portnames) {
        LEVector ports = new LEVector();
        if (portnames.indexOf(44) > 0) {
            StringTokenizer comma_tokenizer = new StringTokenizer(portnames, ",");
            while (comma_tokenizer.hasMoreTokens()) {
                String comma_port = comma_tokenizer.nextToken();
                int pos = comma_port.indexOf(45);
                if (pos > 0) {
                    this.processDashPorts(ports, comma_port, pos);
                    continue;
                }
                ports.add(comma_port);
            }
        } else {
            int pos = portnames.indexOf(45);
            if (pos > 0) {
                this.processDashPorts(ports, portnames, pos);
            } else {
                ports.add(portnames);
            }
        }
        return ports;
    }

    private void processDashPorts(LEVector ports, String portrange, int pos) {
        String pre_dash = portrange.substring(0, pos);
        String post_dash = portrange.substring(pos + 1);
        try {
            int pre_int = Integer.parseInt(pre_dash.substring(1));
            int post_int = Integer.parseInt(post_dash.substring(1));
            int i = pre_int;
            while (i <= post_int) {
                String new_port = new String(String.valueOf(pre_dash.substring(0, 1)) + i);
                ports.add(new_port);
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

