/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEDebugLog;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PMBackup
extends PMUtil {
    private static final String BGP_FLAG = "-bgp";
    private static final String BOARDS_FLAG = "-boards";
    private static final String CHOICENET_FLAG = "-choicenet";
    private static final String ETHERS_FLAG = "-ethernets";
    private static final String FILTERS_FLAG = "-filters";
    private static final String GLOBAL_FLAG = "-global";
    private static final String HOSTS_FLAG = "-hosts";
    private static final String LINES_FLAG = "-lines";
    private static final String LOCATIONS_FLAG = "-locations";
    private static final String MAPS_FLAG = "-maps";
    private static final String OSPF_FLAG = "-ospf";
    private static final String PORTS_FLAG = "-ports";
    private static final String RADIUS_FLAG = "-radius";
    private static final String SNMP_FLAG = "-snmp";
    private static final String SUBS_FLAG = "-subinterfaces";
    private static final String USERS_FLAG = "-users";
    private static final String EXCEPT_FLAG = "-except";
    LEDebugLog m_log = LEDebug.getLog();
    LEVector m_sections = new LEVector();
    LEVector m_tags = new LEVector();
    LEVector m_remove = new LEVector();

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmbackup");
        LEAppInfo.setAppVersion("4.1");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMBackup();
        ((PMBackup)object).processArgs(stringArray);
        System.exit(0);
    }

    public PMBackup() {
        this.initialize();
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        if (stringArray.length < 2) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        this.backupPM();
    }

    public void backupPM() {
        String string = LEAppInfo.getFlag("-f");
        this.connectToPortMaster();
        this.getCommands();
        LEDSSFlatFile lEDSSFlatFile = this.m_cm.connectToFile(string, 1);
        try {
            lEDSSFlatFile.connect();
            int n = this.m_sections.size();
            int n2 = 0;
            while (n2 < n) {
                String string2 = (String)this.m_tags.elementAt(n2);
                String string3 = (String)this.m_sections.elementAt(n2);
                LEConfig lEConfig = (LEConfig)this.m_pm.get(string2);
                if (lEConfig != null) {
                    LEVector lEVector = new LEVector();
                    lEConfig.getCommands(lEVector);
                    lEDSSFlatFile.writeSection(string3, lEVector);
                }
                ++n2;
            }
            lEDSSFlatFile.disconnect();
        }
        catch (Exception exception) {
            System.out.println("Error while backup up: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            this.disconnect();
        }
        this.disconnect();
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <filename>] : specifies a backup file, otherwise stdout.");
        System.out.println("[-bgp] : backs up the BGP configurations. Requres ComOS 3.9 or later");
        System.out.println("[-boards] : backs up the boards on a PM4.");
        System.out.println("[-choicenet] : backs up ChoiceNet servers.");
        System.out.println("[-ethernets] : backs up the ethernets. For PM4 use -boards.");
        System.out.println("[-filters] : backs up the filter table.");
        System.out.println("[-global] : backs up the global information.");
        System.out.println("[-hosts] : backs up the host table.");
        System.out.println("[-lines] : backs up lines. For PM4 use -boards.");
        System.out.println("[-locations] : backs up the location table.");
        System.out.println("[-maps] : backs up NAT maps.");
        System.out.println("[-ospf] : backs up OSPF.");
        System.out.println("[-ports] : backs up the ports. For PM4 use -boards.");
        System.out.println("[-radius] : backs up RADIUS servers.");
        System.out.println("[-snmp] : backs up SNMP.");
        System.out.println("[-subinterfaces] : backs up subinterfaces.");
        System.out.println("[-users] : backs up the user table.");
    }

    public void printUsage() {
        super.printUsage();
        System.out.print("[-f <filename>] ");
        System.out.print("[-bgp] ");
        System.out.print("[-boards] ");
        System.out.print("[-choicenet] ");
        System.out.print("[-ethernets] ");
        System.out.print("[-filters] ");
        System.out.print("[-global] ");
        System.out.print("[-hosts] ");
        System.out.print("[-lines] ");
        System.out.print("[-locations] ");
        System.out.print("[-maps] ");
        System.out.print("[-ospf] ");
        System.out.print("[-ports] ");
        System.out.print("[-radius] ");
        System.out.print("[-snmp] ");
        System.out.print("[-subinterfaces] ");
        System.out.println("[-users] ");
    }

    private void getCommands() {
        boolean bl = true;
        String string = LEAppInfo.getFlag(EXCEPT_FLAG);
        if (LEAppInfo.getFlag(GLOBAL_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("2162688");
            } else {
                this.m_tags.addElement("2162688");
                this.m_sections.addElement("Global");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(BOARDS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("2555904");
            } else {
                this.m_tags.addElement("2555904");
                this.m_sections.addElement("Boards");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(RADIUS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("2228224");
            } else {
                this.m_tags.addElement("2228224");
                this.m_sections.addElement("RADIUS");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(CHOICENET_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1507328");
            } else {
                this.m_tags.addElement("1507328");
                this.m_sections.addElement("ChoiceNet");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(SNMP_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1376256");
            } else {
                bl = false;
                this.m_tags.addElement("1376256");
                this.m_sections.addElement("SNMP");
            }
        }
        if (LEAppInfo.getFlag(OSPF_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1048576");
                this.m_remove.addElement("524288");
            } else {
                this.m_tags.addElement("1048576");
                this.m_tags.addElement("524288");
                this.m_sections.addElement("OSPF");
                this.m_sections.addElement("OSPF Areas");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(BGP_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("589824");
                this.m_remove.addElement("1441792");
            } else {
                this.m_tags.addElement("589824");
                this.m_tags.addElement("1441792");
                this.m_sections.addElement("BGP");
                this.m_sections.addElement("BGP Peers");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(LOCATIONS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1703936");
            } else {
                this.m_tags.addElement("1703936");
                this.m_sections.addElement("Locations");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(USERS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1835008");
            } else {
                this.m_tags.addElement("1835008");
                this.m_sections.addElement("Users");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(FILTERS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("filter");
            } else {
                this.m_tags.addElement("filter");
                this.m_sections.addElement("Filters");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(HOSTS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("1245184");
            } else {
                this.m_tags.addElement("1245184");
                this.m_sections.addElement("Hosts");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(LINES_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("131072");
            } else {
                this.m_tags.addElement("131072");
                this.m_sections.addElement("Lines");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(PORTS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("262144");
            } else {
                bl = false;
                this.m_tags.addElement("262144");
                this.m_sections.addElement("Ports");
            }
        }
        if (LEAppInfo.getFlag(ETHERS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("720896");
            } else {
                this.m_tags.addElement("720896");
                this.m_sections.addElement("Ethernets");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(SUBS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("2490368");
            } else {
                this.m_tags.addElement("2490368");
                this.m_sections.addElement("Subinterfaces");
                bl = false;
            }
        }
        if (LEAppInfo.getFlag(MAPS_FLAG) != null) {
            if (string != null) {
                this.m_remove.addElement("2686976");
            } else {
                bl = false;
                this.m_sections.addElement("NAT Maps");
                this.m_tags.addElement("2686976");
            }
        }
        if (bl || LEAppInfo.getFlag(EXCEPT_FLAG) != null) {
            if (LEAppInfo.getFlag(EXCEPT_FLAG) != null) {
                this.m_remove = this.m_tags;
                this.m_tags = new LEVector();
            }
            try {
                LEVector lEVector;
                LEDataSpec lEDataSpec = LEDataSpecFactory.GetPortMasterSpec();
                if (lEDataSpec != null && (lEVector = lEDataSpec.getAllSpecs()) != null) {
                    int n = lEVector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
                        String string2 = lEDataSpec2.getDescription();
                        if (string2 != null && !this.m_remove.contains(string2)) {
                            this.m_sections.addElement(string2);
                            this.m_tags.addElement(lEDataSpec2.getTag());
                        }
                        ++n2;
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                LEDebug.getLog().logln(20, iOException);
                return;
            }
        }
    }
}

