/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.async;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.async.LEDialerStatusMessage;
import com.lucent.ra.nms.async.LEDialerUpdateMessage;
import com.lucent.ra.nms.backend.LECmdFailedFactory;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.IOException;

public class LEDialer
extends LEObservable
implements LEAMObserver {
    private static final String IDLE = "IDLE";
    private static final String CONNECTING = "CONNECTING";
    private static final String ESTABLISHED = "ESTABLISHED";
    private static final int SESSION_MONITOR = 65536;
    private static final int MONITOR_TIME = 3000;
    private static final int DIAL_DEBUG = 17;
    LELocation m_location;
    boolean m_locexists;
    LEPortMaster m_pm;
    LEPMConnectionFacade m_facade;
    LEDSSPortMaster m_dss;
    String m_port;
    String m_slot;
    String m_previous_state;
    int m_dial_count;
    long m_monitorID;
    boolean m_debug;
    LEConnectionManager m_cm;
    LEAMRouter_RI m_router;
    LEAMManager_RI m_amm;

    public LEDialer(LEPortMaster lEPortMaster) {
        this.initialize(lEPortMaster);
    }

    public LEDialer(String string, String string2, String string3) throws IOException {
        this.m_amm = LEAMManager_RI.Initialize();
        this.m_router = LEAMRouter_RI.Initialize();
        this.m_cm = LEConnectionManager.Initialize();
        LECmdFailedFactory.Register();
        LEMonitorFactory.Register();
        LEDebugFactory.Register();
        LEStatusFactory.Register();
        try {
            LEPortMaster lEPortMaster = LEPMFactory.GetFromPM(this.m_cm, string, string2, string3);
            this.initialize(lEPortMaster);
            return;
        }
        catch (LEDSSException lEDSSException) {
            IOException iOException = new IOException(lEDSSException.getMessage());
            throw iOException;
        }
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public LEVector setLocation(LELocation lELocation) {
        LEVector lEVector = new LEVector();
        this.m_location = (LELocation)lELocation.clone();
        LELocations lELocations = (LELocations)this.m_pm.get("1703936");
        LEVector lEVector2 = lELocations.getKeys();
        if (lEVector2.contains(this.m_location.getName())) {
            this.m_locexists = true;
        } else {
            lELocations.set(this.m_location.getName(), this.m_location);
            lEVector = lELocations.saveChanges();
        }
        return lEVector;
    }

    public LEVector setLocation(String string, String string2, String string3) throws IOException {
        File file = new File(string, string2);
        if (!file.exists()) {
            IOException iOException = new IOException("Specified file does not exist!");
            throw iOException;
        }
        LEVector lEVector = null;
        LEPortMaster lEPortMaster = LEPMFactory.GetFromFile(this.m_cm, string, string2);
        LELocations lELocations = (LELocations)lEPortMaster.get("1703936");
        if (lELocations != null) {
            LELocation lELocation = (LELocation)lELocations.get(string3);
            if (lELocation != null) {
                lEVector = this.setLocation(lELocation);
            }
        } else {
            lEVector = new LEVector();
        }
        return lEVector;
    }

    public LEVector removeLocation() {
        LEVector lEVector = new LEVector();
        if (!this.m_locexists) {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            lEVector = lELocations.delete(this.m_location.getName());
        }
        return lEVector;
    }

    public void dialLocation() {
        Object object;
        int n = -1;
        String string = "dial " + this.m_location.getName();
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        if (this.m_debug) {
            LEDebugFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
            if (this.m_facade != null) {
                this.m_facade.startDebug(393216, 17, -1);
            }
        }
        LEPMCommand lEPMCommand = this.m_pm.execute(string);
        String string2 = lEPMCommand.getResult();
        if (!lEPMCommand.getStatus()) {
            this.sendFailMessage(string2);
            return;
        }
        int n2 = string2.indexOf("using");
        if (n2 > -1) {
            object = string2.substring(n2 + 6);
            this.m_port = (n2 = ((String)object).indexOf(" ")) > -1 ? ((String)object).substring(0, n2).trim() : ((String)object).trim();
        }
        if ((n2 = string2.indexOf("Slot")) > -1) {
            this.m_slot = string2.substring(n2 + 4).trim();
            n = Integer.parseInt(this.m_slot);
        }
        try {
            if (this.m_facade != null && n > -1) {
                this.m_monitorID = this.m_dss.monitor(65536, 3000, n);
            } else if (this.m_facade != null) {
                this.m_monitorID = this.m_dss.monitor(65536, 3000);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.sendFailMessage(exception.getMessage());
            this.disconnect();
        }
        object = new LEDialerUpdateMessage();
        ((LEDialerUpdateMessage)object).setMessage(string2);
        this.notifyObservers(object);
    }

    public void cancelDial() {
        if (this.m_port != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("reset ");
            stringBuffer.append(this.m_port);
            LEPMCommand lEPMCommand = this.m_pm.execute(stringBuffer.toString());
            if (!lEPMCommand.getStatus()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Could not reset port ");
                stringBuffer2.append(this.m_port);
                this.notifyObservers(stringBuffer2.toString());
                return;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append("Reset port ");
            stringBuffer3.append(this.m_port);
            LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
            lEDialerUpdateMessage.setMessage(stringBuffer3.toString());
            this.notifyObservers(lEDialerUpdateMessage);
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonSessionsMessage) {
            LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
            if (!this.m_slot.equals("") && !lEMonSessionsMessage.getBoard().equals(this.m_slot)) {
                return;
            }
            if (!lEMonSessionsMessage.getPortName().equals(this.m_port)) {
                return;
            }
            String string2 = lEMonSessionsMessage.getStatus();
            if (this.m_dial_count < 10) {
                ++this.m_dial_count;
            } else {
                this.sendFailMessage(null);
                this.disconnect();
            }
            if (string2.equals(IDLE)) {
                if (this.m_previous_state.equals(CONNECTING)) {
                    this.sendFailMessage(null);
                    this.disconnect();
                }
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(CONNECTING)) {
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(ESTABLISHED)) {
                this.sendSuccessMessage();
                this.disconnect();
                return;
            }
        } else if (object instanceof LEDebugMessage) {
            LEDebugMessage lEDebugMessage = (LEDebugMessage)object;
            LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
            lEDialerUpdateMessage.setMessage(lEDebugMessage.getData());
            this.notifyObservers(lEDialerUpdateMessage);
        }
    }

    protected void sendFailMessage(String string) {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(false);
        lEDialerStatusMessage.setPortName(this.m_port);
        lEDialerStatusMessage.setBoard(this.m_slot);
        lEDialerStatusMessage.setLocation(this.m_location.getName());
        lEDialerStatusMessage.setMessage(string);
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void sendSuccessMessage() {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(true);
        lEDialerStatusMessage.setPortName(this.m_port);
        lEDialerStatusMessage.setBoard(this.m_slot);
        lEDialerStatusMessage.setLocation(this.m_location.getName());
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void disconnect() {
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        LEDebugFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        try {
            if (this.m_facade != null) {
                this.m_dss.killMonitor(this.m_monitorID);
                this.m_facade.stopDebug(393216, 17, -1);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    protected void initialize(LEPortMaster lEPortMaster) {
        this.m_locexists = false;
        this.m_previous_state = "";
        this.m_pm = lEPortMaster;
        this.m_dial_count = 0;
        this.m_port = "";
        this.m_slot = "";
        this.m_debug = false;
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            this.m_facade = (LEPMConnectionFacade)lEConnectionFacade;
            this.m_dss = (LEDSSPortMaster)lEConnectionFacade.getDSS();
        }
    }
}

