/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSFlatFile_I;
import com.lucent.ra.nms.backend.LELocationTemplate;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.IOException;
import java.io.PrintWriter;

public class LETemplateDSSFlatFile_I
extends LEDSSFlatFile_I {
    static final String LOCATION_PATTERN = "\\w+\\s+location\\s+";
    LEVector m_templates;
    Perl5Matcher m_matcher;
    Perl5Pattern m_locationPattern;

    public LETemplateDSSFlatFile_I(String string, int n, LEVector lEVector) {
        super(string, n);
        this.m_templates = lEVector;
        this.m_matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.m_locationPattern = (Perl5Pattern)perl5Compiler.compile(LOCATION_PATTERN, 1);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public LEVector getTemplateKeys() {
        return this.m_templates;
    }

    public synchronized void writeSection(String string, LEVector lEVector) {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.m_writer);
        printWriter.println('#');
        printWriter.print("# ");
        printWriter.println(string);
        printWriter.println('#');
        this.writeTemplateCommands(printWriter, lEVector, this.m_templates);
        printWriter.flush();
        printWriter = null;
    }

    public synchronized void writeConfig(LEVector lEVector) {
        if (this.m_writer == null || lEVector == null) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(this.m_writer);
        this.writeTemplateCommands(printWriter, lEVector, this.m_templates);
        printWriter.flush();
        printWriter = null;
    }

    protected LEVector loadCommands() {
        LEVector lEVector = new LEVector();
        boolean bl = false;
        try {
            String string = this.m_reader.readLine();
            while (string != null) {
                if (string.length() > 3) {
                    if (string.startsWith("## TEMPLATE")) {
                        bl = true;
                        string = this.m_reader.readLine();
                        if (string == null) break;
                    }
                    if (string.startsWith("## PASS_ENC ")) {
                        string = this.convertPasswordLine(string);
                    }
                    lEVector.addElement(string);
                    if (bl) {
                        if (this.m_matcher.contains(string, (Pattern)this.m_locationPattern)) {
                            LELocationTemplate.ReadTemplateLine(this.m_templates, string);
                        } else {
                            this.readTemplateLine(string);
                        }
                    }
                    bl = false;
                }
                string = this.m_reader.readLine();
            }
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
        return lEVector;
    }

    protected void readTemplateLine(String string) {
        int n = string.lastIndexOf(32);
        if (n > -1) {
            String string2 = string.substring(n);
            string2 = string2.trim();
            int n2 = string.lastIndexOf(32, n);
            if (n2 > -1) {
                String string3 = string.substring(n2, n);
                string3 = string3.trim();
                this.m_templates.add(string3);
            }
        }
    }

    private void writeTemplateCommands(PrintWriter printWriter, LEVector lEVector, LEVector lEVector2) {
        int n = 0;
        if (lEVector != null) {
            n = lEVector.size();
        }
        int n2 = 0;
        if (lEVector2 != null) {
            n2 = lEVector2.size();
        }
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            String string = (String)lEVector.elementAt(n3);
            while (n4 < n2 && !bl) {
                String string2 = (String)lEVector2.elementAt(n4);
                int n5 = string.lastIndexOf(string2);
                if (n5 > -1) {
                    bl = true;
                }
                ++n4;
            }
            if (bl) {
                printWriter.println("## TEMPLATE");
            }
            this.writeCommand(printWriter, string);
            bl = false;
            ++n3;
        }
    }
}

