/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.async.LEDialer;
import com.lucent.ra.nms.async.LEDialerMessage;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocationFileParser;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEDebugLog;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PMDial
extends PMUtil
implements LEObserver,
Runnable {
    private static final String IDLE_FLAG = "-t";
    private static final String VERBOSE_FLAG = "-x";
    private static final String FILE_FLAG = "-f";
    String m_session_time = null;
    String m_old_time;
    String m_locname;
    LEDebugLog m_log = LEDebug.getLog();
    boolean m_continue = true;
    Thread m_thread = new Thread((Runnable)this, "PMDial");
    boolean m_fail = false;
    boolean m_verbose;

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "40");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmdial");
        LEAppInfo.setAppVersion("4.2");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMDial();
        ((PMDial)object).processArgs(stringArray);
        ((PMDial)object).dial();
    }

    public PMDial() {
        this.initialize();
    }

    public void run() {
        if (!this.m_done) {
            this.m_continue = this.dialLocation(this.m_locname);
            System.out.println("");
            while (this.m_continue) {
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                }
                if (this.m_verbose) continue;
                System.out.print(".");
            }
            if (this.m_fail) {
                this.disconnect(-1);
            }
        }
        this.disconnect();
    }

    public void dial() {
        this.m_thread.start();
    }

    public void processArgs(String[] stringArray) {
        String string;
        super.processArgs(stringArray);
        if (stringArray.length < 3) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        if ((string = LEAppInfo.getFlag(IDLE_FLAG)) != null) {
            this.m_session_time = string;
        }
        this.m_locname = stringArray[stringArray.length - 1];
        if (!this.m_locname.equals("-version")) {
            this.m_done = false;
        }
    }

    public boolean dialLocation(String string) {
        this.m_verbose = false;
        LEDSSFlatFile lEDSSFlatFile = null;
        LELocation lELocation = null;
        if (LEAppInfo.getFlag(VERBOSE_FLAG) != null) {
            this.m_verbose = true;
        }
        this.m_locname = string;
        this.connectToPortMaster();
        String string2 = LEAppInfo.getFlag(FILE_FLAG);
        if (string2 != null) {
            int n = string2.lastIndexOf(File.separatorChar);
            String string3 = "";
            String string4 = null;
            if (n > -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            } else {
                string4 = string2;
            }
            try {
                String string5 = LEAppInfo.createFullPath(string3, string4);
                lEDSSFlatFile = this.m_cm.connectToFile(string5, 0);
                lEDSSFlatFile.connect();
                LELocationFileParser lELocationFileParser = new LELocationFileParser();
                lELocationFileParser.createPatterns();
                LEVector lEVector = lEDSSFlatFile.getCommands();
                if (lEVector != null) {
                    lELocationFileParser.readLocations(lEVector);
                    LELocations lELocations = lELocationFileParser.getLocations();
                    if (lELocations != null) {
                        lELocation = (LELocation)lELocations.get(string);
                    }
                }
                lEDSSFlatFile.disconnect();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        } else {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            lELocation = (LELocation)lELocations.get(string);
        }
        if (lELocation == null) {
            System.out.println("Location " + string + " was not found.");
            return false;
        }
        LEDialer lEDialer = new LEDialer(this.m_pm);
        lEDialer.setDebug(this.m_verbose);
        lEDialer.addObserver(this);
        lEDialer.setLocation(lELocation);
        if (LEAppInfo.getFlag(IDLE_FLAG) != null) {
            this.setLocationTimeout(String.valueOf(this.m_session_time) + " minutes");
        }
        lEDialer.dialLocation();
        if (LEAppInfo.getFlag(IDLE_FLAG) != null) {
            this.setLocationTimeout(this.m_old_time);
        }
        lEDialer.removeLocation();
        return this.m_continue;
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-x] [-t <minutes>] [-f <filename>] <location_name>");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-x] : specifies verbose output.");
        System.out.println("[-t <minutes>] : specifies the number of minutes for idle timeout.");
        System.out.println("[-f <filename>] : specifies a configuration file to read.");
        System.out.println("<location_name> : specifies the location to dial.");
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEDialerMessage) {
            LEDialerMessage lEDialerMessage = (LEDialerMessage)object;
            String string = lEDialerMessage.getMessage();
            System.out.println("");
            System.out.println(string);
            if (string.startsWith("FAIL:")) {
                this.m_fail = true;
                this.m_continue = false;
                return;
            }
            if (string.startsWith("SUCCESS:")) {
                this.m_continue = false;
            }
        }
    }

    private void setLocationTimeout(String string) {
        try {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            LELocation lELocation = (LELocation)lELocations.get(this.m_locname);
            this.m_old_time = (String)lELocation.get("297");
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("set ");
            stringBuffer.append(this.m_locname);
            stringBuffer.append(" idle ");
            stringBuffer.append(string);
            LEPMCommand lEPMCommand = this.m_pm.getFacade().execute(stringBuffer.toString());
            if (!lEPMCommand.getStatus()) {
                System.out.println("Could not set the timeout from " + this.m_old_time + " to " + string);
                System.out.println("Reason: " + lEPMCommand.getResult());
                return;
            }
            this.m_pm.getFacade().execute("save all");
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

