/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;

public abstract class PMUtil {
    static final String HELP_FLAG = "-help";
    static final String BUILD_FLAG = "-version";
    LEPortMaster m_pm;
    LEConnectionManager m_cm;
    LEAMManager_RI m_amm;
    LEAMRouter_RI m_router;
    boolean m_done = false;

    void printAppInfo() {
        System.out.print(LEAppInfo.getAppName());
        System.out.print(" version: " + LEAppInfo.getAppVersion());
        System.out.println("  build date: " + LEAppInfo.GetBuildDate());
        this.m_done = true;
    }

    void printUsage() {
        System.out.println("");
        System.out.print("usage: " + LEAppInfo.getAppName() + " <host> <password> [-u <username>] [-version] [-help] ");
        this.m_done = true;
    }

    void printHelpInfo() {
        this.printUsage();
        System.out.println("");
        System.out.println("<hostname> : specifies the PortMaster.");
        System.out.println("<password> : specifies the administrator password for the PortMaster.");
        System.out.println("[-u <username>] : specifies a username other than !root.");
        System.out.println("[-version] : prints out the version number and build date.");
        System.out.println("[-help] : prints out this help message.");
        this.m_done = true;
    }

    void processArgs(String[] stringArray) {
        if (stringArray.length > 1) {
            String string = LEAppInfo.getFlag("-h");
            String string2 = LEAppInfo.getFlag("-p");
            if (string == null && string2 == null) {
                String string3 = stringArray[0];
                if (!string3.startsWith("-")) {
                    LEAppInfo.setFlag("-h", stringArray[0]);
                    LEAppInfo.setFlag("-p", stringArray[1]);
                    return;
                }
            } else {
                if (string != null && string2 != null) {
                    return;
                }
                System.out.print("The host and password arguments must either ");
                System.out.print("have both the -h and -p flags or not have ");
                System.out.println("either of them.");
                System.exit(0);
            }
        }
    }

    void checkArgs() {
        if (LEAppInfo.getFlag(BUILD_FLAG) != null) {
            this.printAppInfo();
            return;
        }
        if (LEAppInfo.getFlag(HELP_FLAG) != null) {
            this.printHelpInfo();
            return;
        }
        this.printUsage();
    }

    String getHost() {
        return LEAppInfo.getFlag("-h");
    }

    String getPassword() {
        String string = LEAppInfo.getFlag("-p");
        if (string == null) {
            string = "";
        }
        return string;
    }

    String getUsername() {
        String string = LEAppInfo.getFlag("-u");
        if (string == null) {
            string = new String("!root");
        }
        return string;
    }

    void connectToPortMaster() {
        try {
            this.m_pm = LEPMFactory.GetFromPM(this.m_cm, this.getHost(), this.getUsername(), this.getPassword());
        }
        catch (Exception exception) {
            System.out.println("Connect failed: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
        }
        if (this.m_pm == null) {
            System.out.println("Could not connect to " + this.getHost());
            this.disconnect();
        }
    }

    void initialize() {
        this.m_cm = LEConnectionManager.Initialize();
        this.m_amm = LEAMManager_RI.Initialize();
        this.m_router = LEAMRouter_RI.GetAMRouter();
    }

    void disconnect() {
        this.disconnect(0);
    }

    void disconnect(int n) {
        if (this.m_pm != null) {
            this.m_pm.disconnect();
        }
        System.exit(n);
    }
}

