/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.util.LEVector;

public class LEIPPool
extends LEConfig {
    public static final String GATEWAY = "75";
    public static final String RANGES = "ranges";
    public static final int KEY_COUNT = 2;
    public static final String RESET = "reset ippool";
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[2];
            int n = 0;
            LEIPPool.s_keys[n++] = GATEWAY;
            LEIPPool.s_keys[n++] = RANGES;
        }
        return s_keys;
    }

    public LEIPPool(LEConnectionFacade lEConnectionFacade, String string) {
        super(lEConnectionFacade);
        this.m_name = string;
        this.m_tag = "ippool " + string;
    }

    public Object clone() {
        LEIPPool lEIPPool = new LEIPPool(this.m_facade, this.m_name);
        lEIPPool.copy(this);
        return lEIPPool;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean requiresReset(String string) {
        return string.equals(GATEWAY);
    }

    LEConfig createConfig(String string) {
        if (string.equals(RANGES)) {
            return new LEIPRanges(this.m_facade, this.m_name);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = super.getAllCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET);
            this.m_reboot = false;
        }
        return bl;
    }

    boolean getChangedCommands(LEVector lEVector) {
        boolean bl = super.getChangedCommands(lEVector);
        if (bl && this.m_reboot) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET);
            this.m_reboot = false;
        }
        return bl;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        this.m_reboot = false;
        if ((bl || lEVector.contains(GATEWAY)) && (string = (String)this.get(GATEWAY)) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("set ");
            stringBuffer.append("ippool ");
            stringBuffer.append(this.m_name);
            stringBuffer.append(" default-gateway ");
            stringBuffer.append(string);
            lEVector2.addElement(stringBuffer.toString());
            this.m_reboot = true;
        }
        return lEVector2.size() > n;
    }
}

