/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEComOpt;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEDebugLog;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PMBackup
extends PMUtil {
    private static final String BGP_FLAG = "-bgp";
    private static final String CHOICENET_FLAG = "-choicenet";
    private static final String ETHERS_FLAG = "-ethernets";
    private static final String FILTERS_FLAG = "-filters";
    private static final String GLOBAL_FLAG = "-global";
    private static final String HOSTS_FLAG = "-hosts";
    private static final String IMT_FLAG = "-imt";
    private static final String IPPOOL_FLAG = "-ippool";
    private static final String LINES_FLAG = "-lines";
    private static final String LOCALIP_FLAG = "-localip";
    private static final String LOCATIONS_FLAG = "-locations";
    private static final String L2TP_FLAG = "-l2tp";
    private static final String MAPS_FLAG = "-maps";
    private static final String OSPF_FLAG = "-ospf";
    private static final String PORTS_FLAG = "-ports";
    private static final String RADIUS_FLAG = "-radius";
    private static final String SA_FLAG = "-sa";
    private static final String SECPROF_FLAG = "-secprof";
    private static final String SNMP_FLAG = "-snmp";
    private static final String SUBS_FLAG = "-subinterfaces";
    private static final String USERS_FLAG = "-users";
    LEDebugLog m_log = LEDebug.getLog();
    LEVector m_sections = new LEVector();
    LEVector m_tags = new LEVector();

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "40");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmbackup");
        LEAppInfo.setAppVersion("4.4");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        try {
            object = LEAppInfo.getFlag("-g");
            if (object != null) {
                LEDebug.getLog().setLogLevel(Integer.parseInt((String)object));
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMBackup();
        ((PMBackup)object).processArgs(stringArray);
        System.exit(0);
    }

    public PMBackup() {
        this.initialize();
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        if (stringArray.length < 2) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        this.backupPM();
    }

    public void backupPM() {
        String string = LEAppInfo.getFlag("-f");
        this.connectToPortMaster();
        this.getCommands();
        try {
            LEDSSFlatFile lEDSSFlatFile = this.m_cm.connectToFile(string, 1);
            lEDSSFlatFile.connect();
            int n = this.m_sections.size();
            int n2 = 0;
            while (n2 < n) {
                Object object;
                LEVector lEVector = new LEVector();
                String string2 = (String)this.m_tags.elementAt(n2);
                String string3 = (String)this.m_sections.elementAt(n2);
                LEConfig lEConfig = (LEConfig)this.m_pm.get(string2);
                if (!this.m_pm.isConnected()) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Lost connection to ");
                    ((StringBuffer)object).append(this.getHost());
                    ((StringBuffer)object).append(" while retrieving configuration data. ");
                    ((StringBuffer)object).append("Exiting pmbackup. ");
                    System.out.println(((StringBuffer)object).toString());
                    this.disconnect();
                    return;
                }
                if (lEConfig != null) {
                    lEConfig.getCommands(lEVector);
                }
                if ((object = (LEBoards)this.m_pm.get("2555904")) != null) {
                    LEVector lEVector2 = ((LEConfig)object).getKeys();
                    int n3 = lEVector2.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        String string4 = (String)lEVector2.elementAt(n4);
                        LEBoard lEBoard = (LEBoard)((LEConfig)object).get(string4);
                        if (lEBoard != null) {
                            if (string2.equals("2162688")) {
                                lEBoard.getGlobalCommands(lEVector);
                            } else {
                                lEConfig = (LEConfig)lEBoard.get(string2);
                                if (lEConfig != null) {
                                    lEConfig.getCommands(lEVector);
                                }
                            }
                        }
                        ++n4;
                    }
                }
                if (string2.equals("3473408") || string2.equals("720896")) {
                    LEComOpt.RemoveReboots(lEVector, 0);
                }
                if (lEVector.size() > 0) {
                    LEComOpt.RemoveRedundancies(lEVector, 0);
                    lEDSSFlatFile.writeSection(string3, lEVector);
                }
                ++n2;
            }
            lEDSSFlatFile.disconnect();
        }
        catch (Exception exception) {
            System.out.println("Error while backup up: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            this.disconnect();
        }
        this.disconnect();
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <filename>] : specifies a backup file, otherwise stdout.");
        System.out.println("[-bgp] : saves the BGP configurations. Requres ComOS 3.9 or later");
        System.out.println("[-choicenet] : saves ChoiceNet servers.");
        System.out.println("[-ethernets] : saves the ethernets.");
        System.out.println("[-filters] : saves the filter table.");
        System.out.println("[-global] : saves the global information.");
        System.out.println("[-hosts] : saves the host table.");
        System.out.println("[-imt] : saves the IMT information.");
        System.out.println("[-ippool] : saves the IP pool table.");
        System.out.println("[-lines] : saves lines.");
        System.out.println("[-localip] : saves local IP addresses.");
        System.out.println("[-locations] : saves the location table.");
        System.out.println("[-l2tp] : saves the L2TP information.");
        System.out.println("[-maps] : saves NAT maps.");
        System.out.println("[-ospf] : saves OSPF.");
        System.out.println("[-ports] : saves the ports.");
        System.out.println("[-radius] : saves RADIUS servers.");
        System.out.println("[-sa] : saves security associations.");
        System.out.println("[-secprof] : saves security profiles.");
        System.out.println("[-snmp] : saves SNMP.");
        System.out.println("[-subinterfaces] : saves subinterfaces.");
        System.out.println("[-users] : saves the user table.");
    }

    public void printUsage() {
        super.printUsage();
        System.out.print("[-f <filename>] ");
        System.out.print("[-bgp] ");
        System.out.print("[-choicenet] ");
        System.out.print("[-ethernets] ");
        System.out.print("[-filters] ");
        System.out.print("[-global] ");
        System.out.print("[-hosts] ");
        System.out.print("[-imt] ");
        System.out.print("[-ippool] ");
        System.out.print("[-lines] ");
        System.out.print("[-localip] ");
        System.out.print("[-locations] ");
        System.out.print("[-l2tp] ");
        System.out.print("[-maps] ");
        System.out.print("[-ospf] ");
        System.out.print("[-ports] ");
        System.out.print("[-radius] ");
        System.out.print("[-sa] ");
        System.out.print("[-secprof] ");
        System.out.print("[-snmp] ");
        System.out.print("[-subinterfaces] ");
        System.out.println("[-users] ");
    }

    private void getCommands() {
        boolean bl = true;
        if (LEAppInfo.getFlag(GLOBAL_FLAG) != null) {
            this.m_tags.addElement("2162688");
            this.m_sections.addElement("Global");
            bl = false;
        }
        if (LEAppInfo.getFlag(IMT_FLAG) != null) {
            this.m_tags.addElement("3670022");
            this.m_sections.addElement("IMT");
            bl = false;
        }
        if (LEAppInfo.getFlag(L2TP_FLAG) != null) {
            this.m_tags.addElement("3473408");
            this.m_sections.addElement("L2TP");
            bl = false;
        }
        if (LEAppInfo.getFlag(RADIUS_FLAG) != null) {
            this.m_tags.addElement("2228224");
            this.m_sections.addElement("RADIUS");
            bl = false;
        }
        if (LEAppInfo.getFlag(CHOICENET_FLAG) != null) {
            this.m_tags.addElement("1507328");
            this.m_sections.addElement("ChoiceNet");
            bl = false;
        }
        if (LEAppInfo.getFlag(SNMP_FLAG) != null) {
            bl = false;
            this.m_tags.addElement("1376256");
            this.m_sections.addElement("SNMP");
        }
        if (LEAppInfo.getFlag(OSPF_FLAG) != null) {
            this.m_tags.addElement("1048576");
            this.m_tags.addElement("524288");
            this.m_sections.addElement("OSPF");
            this.m_sections.addElement("OSPF Areas");
            bl = false;
        }
        if (LEAppInfo.getFlag(BGP_FLAG) != null) {
            this.m_tags.addElement("589824");
            this.m_tags.addElement("1441792");
            this.m_sections.addElement("BGP");
            this.m_sections.addElement("BGP Peers");
            bl = false;
        }
        if (LEAppInfo.getFlag(FILTERS_FLAG) != null) {
            this.m_tags.addElement("filter");
            this.m_sections.addElement("Filters");
            bl = false;
        }
        if (LEAppInfo.getFlag(MAPS_FLAG) != null) {
            bl = false;
            this.m_sections.addElement("NAT Maps");
            this.m_tags.addElement("2686976");
        }
        if (LEAppInfo.getFlag(SA_FLAG) != null) {
            this.m_tags.addElement("2424832");
            this.m_sections.addElement("Security Associations");
            bl = false;
        }
        if (LEAppInfo.getFlag(SECPROF_FLAG) != null) {
            this.m_tags.addElement("3735552");
            this.m_sections.addElement("Security Profiles");
            bl = false;
        }
        if (LEAppInfo.getFlag(LOCATIONS_FLAG) != null) {
            this.m_tags.addElement("1703936");
            this.m_sections.addElement("Locations");
            bl = false;
        }
        if (LEAppInfo.getFlag(USERS_FLAG) != null) {
            this.m_tags.addElement("1835008");
            this.m_sections.addElement("Users");
            bl = false;
        }
        if (LEAppInfo.getFlag(HOSTS_FLAG) != null) {
            this.m_tags.addElement("1245184");
            this.m_sections.addElement("Hosts");
            bl = false;
        }
        if (LEAppInfo.getFlag(LINES_FLAG) != null) {
            this.m_tags.addElement("131072");
            this.m_sections.addElement("Lines");
            bl = false;
        }
        if (LEAppInfo.getFlag(PORTS_FLAG) != null) {
            bl = false;
            this.m_tags.addElement("262144");
            this.m_sections.addElement("Ports");
        }
        if (LEAppInfo.getFlag(ETHERS_FLAG) != null) {
            this.m_tags.addElement("720896");
            this.m_sections.addElement("Ethernets");
            bl = false;
        }
        if (LEAppInfo.getFlag(SUBS_FLAG) != null) {
            this.m_tags.addElement("2490368");
            this.m_sections.addElement("Subinterfaces");
            bl = false;
        }
        if (LEAppInfo.getFlag(IPPOOL_FLAG) != null) {
            this.m_tags.addElement("3670021");
            this.m_sections.addElement("IP Pool");
            bl = false;
        }
        if (LEAppInfo.getFlag(LOCALIP_FLAG) != null) {
            this.m_tags.addElement("3670023");
            this.m_sections.addElement("Local IP Addresses");
            bl = false;
        }
        if (bl) {
            try {
                LEVector lEVector;
                LEDataSpec lEDataSpec = LEDataSpecFactory.GetPortMasterSpec();
                if (lEDataSpec != null && (lEVector = lEDataSpec.getAllSpecs()) != null) {
                    int n = lEVector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        String string;
                        LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
                        if (lEDataSpec2.getTag().equals("2555904")) {
                            LEVector lEVector2;
                            LEDataSpec lEDataSpec3;
                            LEDataSpec lEDataSpec4 = lEDataSpec.getSpecFor("2555904");
                            if (lEDataSpec4 != null && (lEDataSpec3 = lEDataSpec4.getSpecFor("entry")) != null && (lEVector2 = lEDataSpec3.getAllSpecs()) != null) {
                                int n3 = lEVector2.size();
                                int n4 = 0;
                                while (n4 < n3) {
                                    lEDataSpec2 = (LEDataSpec)lEVector2.elementAt(n4);
                                    String string2 = lEDataSpec2.getType();
                                    if (string2.equals("Config") || string2.equals("Table")) {
                                        string = lEDataSpec2.getDescription();
                                        if (string == null) {
                                            string = lEDataSpec2.getTag();
                                        }
                                        this.m_sections.addElementUnique(string);
                                        this.m_tags.addElementUnique(lEDataSpec2.getTag());
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            string = lEDataSpec2.getDescription();
                            if (string == null) {
                                string = lEDataSpec2.getTag();
                            }
                            this.m_sections.addElementUnique(string);
                            this.m_tags.addElementUnique(lEDataSpec2.getTag());
                        }
                        ++n2;
                    }
                    return;
                }
            }
            catch (IOException iOException) {
                LEDebug.getLog().logln(20, iOException);
                return;
            }
        }
    }
}

