/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.async;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.async.LEDialerStatusMessage;
import com.lucent.ra.nms.async.LEDialerUpdateMessage;
import com.lucent.ra.nms.backend.LEAsyncCmdFactory;
import com.lucent.ra.nms.backend.LEAsyncCmdMessage;
import com.lucent.ra.nms.backend.LECmdFailedFactory;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEPortIOMessage;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocationFileParser;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortIODecoder;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEVector;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class LEDialer
extends LEObservable
implements LEAMObserver {
    public static final String PM4_NOASYNC = "Cannot perform a dial operation on this PortMaster.";
    private static final String IDLE = "IDLE";
    private static final String CONNECTING = "CONNECTING";
    private static final String ESTABLISHED = "ESTABLISHED";
    private static final String DISCONNECTING = "DISCONNECTING";
    private static final String CONN_SUCCESS = "connection succeeded";
    private static final String CONN_FAILED = "connection failed";
    private static final String NO_PORTS = "No available dialout ports";
    private static final int SESSION_MONITOR = 65536;
    private static final int MONITOR_TIME = 3000;
    private static final int PORTIO_TIME = 2000;
    private static final int DIAL_DEBUG = 17;
    String m_location;
    boolean m_locexists;
    LEPortMaster m_pm;
    LEPMConnectionFacade m_facade;
    LEDSSPortMaster m_dss;
    String m_port;
    String m_slot;
    String m_previous_state;
    String m_dialcmd;
    String m_prevState;
    int m_dial_count;
    long m_monitorID;
    boolean m_debug;
    boolean m_async;
    LEConnectionManager m_cm;
    LEAMRouter_RI m_router;
    LEAMManager_RI m_amm;
    Hashtable m_portToLoc;
    Hashtable m_asyncToLoc;

    public LEDialer(LEPortMaster lEPortMaster) {
        this.initialize(lEPortMaster);
    }

    public LEDialer(String string, String string2, String string3) throws IOException {
        this.m_amm = LEAMManager_RI.Initialize();
        this.m_cm = LEConnectionManager.Initialize();
        this.m_router = LEAMRouter_RI.GetAMRouter();
        LECmdFailedFactory.Register();
        LEMonitorFactory.Register();
        LEDebugFactory.Register();
        LEStatusFactory.Register();
        LEAsyncCmdFactory.Register();
        try {
            LEPortMaster lEPortMaster = LEPMFactory.GetFromPM(this.m_cm, string, string2, string3);
            this.initialize(lEPortMaster);
            return;
        }
        catch (LEDSSException lEDSSException) {
            IOException iOException = new IOException(lEDSSException.getMessage());
            throw iOException;
        }
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public LEVector setLocation(LELocation lELocation) {
        LEVector lEVector = new LEVector();
        LELocation lELocation2 = (LELocation)lELocation.clone();
        LELocations lELocations = (LELocations)this.m_pm.get("1703936");
        LEVector lEVector2 = lELocations.getKeys();
        if (lEVector2.contains(lELocation2.getName())) {
            this.m_locexists = true;
        } else {
            lELocations.set(lELocation2.getName(), lELocation2);
            lEVector = lELocations.saveChanges();
        }
        return lEVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LEVector setLocation(String string, String string2, String string3) throws IOException {
        LEDSSFlatFile lEDSSFlatFile = null;
        LELocation lELocation = null;
        File file = new File(string, string2);
        if (!file.exists()) {
            IOException iOException = new IOException("Specified file does not exist!");
            throw iOException;
        }
        LEVector lEVector = null;
        String string4 = LEAppInfo.createFullPath(string, string2);
        try {
            lEDSSFlatFile = this.m_cm.connectToFile(string4, 0);
            lEDSSFlatFile.connect();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            throw iOException;
        }
        LELocationFileParser lELocationFileParser = new LELocationFileParser();
        lELocationFileParser.createPatterns();
        LEVector lEVector2 = lEDSSFlatFile.getCommands();
        if (lEVector2 == null) {
            IOException iOException = new IOException("Specified file was empty!");
            throw iOException;
        }
        lELocationFileParser.readLocations(lEVector2);
        LELocations lELocations = lELocationFileParser.getLocations();
        if (lELocations == null) {
            IOException iOException = new IOException("Specified file did not contain any locations!");
            throw iOException;
        }
        lELocation = (LELocation)lELocations.get(string3);
        if (lELocation != null) {
            lEVector = this.setLocation(lELocation);
            lEDSSFlatFile.disconnect();
            return lEVector;
        }
        IOException iOException = new IOException("Specified location does not exist!");
        throw iOException;
    }

    public LEVector removeLocation(String string) {
        LEVector lEVector = new LEVector();
        if (!this.m_locexists) {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            lEVector = lELocations.delete(string);
        }
        return lEVector;
    }

    public void dialLocation(String string) {
        this.m_dialcmd = this.m_debug ? "dial " + string + " -x" : "dial " + string;
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        LEAsyncCmdFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        String string2 = this.m_pm.getHardwareType();
        try {
            long l = this.m_dss.async(0x400001, -1, this.m_dialcmd);
            if (l > 0L) {
                this.m_asyncToLoc.put(new Long(l), string);
                return;
            }
        }
        catch (LEDSSException lEDSSException) {
            if (!string2.equals("PM-4")) {
                if (this.m_debug) {
                    LEDebugFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
                    if (this.m_facade != null) {
                        this.m_facade.startDebug(393216, 17, -1);
                    }
                }
                LEPMCommand lEPMCommand = this.m_pm.execute(this.m_dialcmd);
                String string3 = lEPMCommand.getResult();
                if (!lEPMCommand.getStatus()) {
                    this.sendFailMessage("", "", "", string3);
                }
                this.parseResult(string3);
                try {
                    if (this.m_facade != null) {
                        this.m_facade.startMonitor(65536, -1, LEPMConnectionFacade.NO_GROUP, 3000);
                    }
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    this.sendFailMessage("", "", "", exception.getMessage());
                    this.shutdown();
                }
                LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
                lEDialerUpdateMessage.setMessage(string3);
                this.notifyObservers(lEDialerUpdateMessage);
            }
            this.sendFailMessage("", "", "", PM4_NOASYNC);
        }
    }

    protected void parseResult(String string) {
        String string2;
        int n = string.indexOf("location");
        this.m_location = n > -1 ? ((n = (string2 = string.substring(n + 9)).indexOf(" ")) > -1 ? string2.substring(0, n).trim() : string2.trim()) : "";
        n = string.indexOf("using");
        this.m_port = n > -1 ? ((n = (string2 = string.substring(n + 6)).indexOf(" ")) > -1 ? string2.substring(0, n).trim() : string2.trim()) : "";
        n = string.indexOf("Slot");
        if (n > -1) {
            this.m_slot = string.substring(n + 4).trim();
            return;
        }
        this.m_slot = "";
    }

    public void cancelDial() {
        if (this.m_port != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("reset ");
            stringBuffer.append(this.m_port);
            LEPMCommand lEPMCommand = this.m_pm.execute(stringBuffer.toString());
            if (!lEPMCommand.getStatus()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Could not reset port ");
                stringBuffer2.append(this.m_port);
                this.notifyObservers(stringBuffer2.toString());
            } else {
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append("Reset port ");
                stringBuffer3.append(this.m_port);
                LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
                lEDialerUpdateMessage.setMessage(stringBuffer3.toString());
                this.notifyObservers(lEDialerUpdateMessage);
            }
        }
        this.shutdown();
    }

    public void disconnect() {
        this.shutdown();
        this.m_facade.disconnect();
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonSessionsMessage) {
            LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
            if (!this.m_slot.equals("") && !lEMonSessionsMessage.getBoard().equals(this.m_slot)) {
                return;
            }
            if (!lEMonSessionsMessage.getPortName().equals(this.m_port)) {
                return;
            }
            String string2 = lEMonSessionsMessage.getStatus();
            if (this.m_dial_count < 10) {
                ++this.m_dial_count;
            } else {
                this.sendFailMessage("", "", "", null);
                this.stopMonitor(65536, -1, "", "", 3000);
            }
            if (string2.equals(IDLE)) {
                if (this.m_previous_state.equals(CONNECTING)) {
                    this.sendFailMessage("", "", "", null);
                    this.stopMonitor(65536, -1, "", "", 3000);
                }
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(CONNECTING)) {
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(ESTABLISHED)) {
                this.sendSuccessMessage("", "", "");
                this.stopMonitor(65536, -1, "", "", 3000);
                return;
            }
        } else {
            if (object instanceof LEDebugMessage) {
                LEDebugMessage lEDebugMessage = (LEDebugMessage)object;
                LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
                lEDialerUpdateMessage.setMessage(lEDebugMessage.getData());
                this.notifyObservers(lEDialerUpdateMessage);
                return;
            }
            if (object instanceof LEPortIOMessage) {
                int n;
                LEPortIOMessage lEPortIOMessage = (LEPortIOMessage)object;
                String string3 = lEPortIOMessage.getBoard();
                String string4 = lEPortIOMessage.getName().substring(1);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                stringBuffer.append(":");
                stringBuffer.append(string4);
                String string5 = (String)this.m_portToLoc.get(stringBuffer.toString());
                String string6 = lEPortIOMessage.getState();
                int n2 = -1;
                if (string3.length() > 0) {
                    n2 = Integer.parseInt(string3);
                }
                if (this.m_dial_count < 60) {
                    ++this.m_dial_count;
                } else {
                    this.sendFailMessage(string3, string4, string5, null);
                    n = Integer.parseInt(string4);
                    this.stopMonitor(262144, n2, string4, Integer.toString(n + 1), 2000);
                }
                if (string6.equals(IDLE)) {
                    if (!this.m_previous_state.equals(IDLE) && !this.m_previous_state.equals("")) {
                        n = (int)lEPortIOMessage.getSessionTermination();
                        this.sendFailMessage(string3, string4, string5, n);
                        int n3 = Integer.parseInt(string4);
                        this.stopMonitor(262144, n2, string4, Integer.toString(n3 + 1), 2000);
                    }
                    this.m_previous_state = string6;
                    return;
                }
                if (string6.equals(CONNECTING)) {
                    this.m_previous_state = string6;
                    return;
                }
                if (string6.equals(ESTABLISHED)) {
                    this.sendSuccessMessage(string3, string4, string5);
                    n = Integer.parseInt(string4);
                    this.stopMonitor(262144, n2, string4, Integer.toString(n + 1), 2000);
                    return;
                }
                this.m_previous_state = string6;
                return;
            }
            if (object instanceof LEAsyncCmdMessage) {
                int n;
                LEAsyncCmdMessage lEAsyncCmdMessage = (LEAsyncCmdMessage)object;
                String string7 = lEAsyncCmdMessage.getMessage();
                if (string7.indexOf("Starting dial to location") > -1) {
                    CharSequence charSequence;
                    int n4 = string7.indexOf("location");
                    String string8 = n4 > -1 ? ((n4 = ((String)(charSequence = string7.substring(n4 + 9))).indexOf(" ")) > -1 ? ((String)charSequence).substring(0, n4).trim() : ((String)charSequence).trim()) : "";
                    n4 = string7.indexOf("using");
                    String string9 = n4 > -1 ? ((n4 = ((String)(charSequence = string7.substring(n4 + 7))).indexOf(" ")) > -1 ? ((String)charSequence).substring(0, n4).trim() : ((String)charSequence).trim()) : "";
                    n4 = string7.indexOf("Slot");
                    String string10 = n4 > -1 ? string7.substring(n4 + 4).trim() : "";
                    if (this.m_facade != null && string10.length() > 0) {
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append(string10);
                        ((StringBuffer)charSequence).append(":");
                        ((StringBuffer)charSequence).append(string9);
                        this.m_portToLoc.put(((StringBuffer)charSequence).toString(), string8);
                        int n5 = Integer.parseInt(string10);
                        int n6 = Integer.parseInt(string9);
                        this.m_facade.startMonitor(262144, n5, LEPMConnectionFacade.NO_GROUP, string9, Integer.toString(n6 + 1), 2000);
                    }
                    this.killAsync(lEAsyncCmdMessage.getRequestID());
                    return;
                }
                int n7 = -1;
                n7 = string7.indexOf(CONN_FAILED);
                if (n7 > -1) {
                    this.sendFailMessage("", "", "", lEAsyncCmdMessage.getMessage());
                    this.killAsync(lEAsyncCmdMessage.getRequestID());
                }
                if ((n = string7.indexOf(NO_PORTS)) > -1) {
                    String string11 = (String)this.m_asyncToLoc.get(new Long(lEAsyncCmdMessage.getRequestID()));
                    this.sendFailMessage("", "", string11, string7);
                    this.killAsync(lEAsyncCmdMessage.getRequestID());
                }
                if (this.m_debug && n7 == -1) {
                    LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
                    lEDialerUpdateMessage.setMessage(lEAsyncCmdMessage.getMessage());
                    this.notifyObservers(lEDialerUpdateMessage);
                }
            }
        }
    }

    protected void sendFailMessage(String string, String string2, String string3, String string4) {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(false);
        lEDialerStatusMessage.setPortName(string2);
        lEDialerStatusMessage.setBoard(string);
        lEDialerStatusMessage.setLocation(string3);
        lEDialerStatusMessage.setMessage(string4);
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void sendFailMessage(String string, String string2, String string3, int n) {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(false);
        lEDialerStatusMessage.setPortName(string2);
        lEDialerStatusMessage.setBoard(string);
        lEDialerStatusMessage.setLocation(string3);
        lEDialerStatusMessage.setMessage(LEPortIODecoder.TranslateTerminationCode(n));
        if (n != 0) {
            lEDialerStatusMessage.setTermination(-n);
        }
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void sendSuccessMessage(String string, String string2, String string3) {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(true);
        lEDialerStatusMessage.setPortName(string2);
        lEDialerStatusMessage.setBoard(string);
        lEDialerStatusMessage.setLocation(string3);
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void shutdown() {
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        LEDebugFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        LEAsyncCmdFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        try {
            if (this.m_facade != null) {
                if (this.m_async) {
                    this.m_facade.stopAsync(0x400001, -1, this.m_dialcmd);
                    int n = Integer.parseInt(this.m_port.substring(1));
                    this.m_facade.stopMonitor(262144, Integer.parseInt(this.m_slot), LEPMConnectionFacade.NO_GROUP, this.m_port.substring(1), Integer.toString(n + 1), 2000);
                    return;
                }
                this.m_facade.stopMonitor(65536, -1, LEPMConnectionFacade.NO_GROUP, 30000);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    protected void killAsync(long l) {
        try {
            this.m_dss.killAsync(l);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected void stopMonitor(int n, int n2, String string, String string2, int n3) {
        this.m_facade.stopMonitor(n, n2, LEPMConnectionFacade.NO_GROUP, string, string2, n3);
    }

    protected void initialize(LEPortMaster lEPortMaster) {
        this.m_locexists = false;
        this.m_previous_state = "";
        this.m_pm = lEPortMaster;
        this.m_dial_count = 0;
        this.m_port = "";
        this.m_slot = "";
        this.m_debug = false;
        this.m_portToLoc = new Hashtable();
        this.m_asyncToLoc = new Hashtable();
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (lEConnectionFacade instanceof LEPMConnectionFacade) {
            this.m_facade = (LEPMConnectionFacade)lEConnectionFacade;
            this.m_dss = (LEDSSPortMaster)lEConnectionFacade.getDSS();
        }
    }
}

