/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.io.Serializable;

public class LEAlarmMessage
extends LEEntityMessage
implements Serializable {
    public static final String CLEARED = "Cleared";
    public static final String CURRENT = "Current";
    public static final String STALE = "Stale";
    public static final String OS_SENDING_TICKS = "4.1b10";
    public static final int TICKS_PER_MINUTE = 1092;
    int m_time;
    String m_ftime;
    String m_state = "Current";
    String m_message;
    String m_severity;
    int m_count;

    public LEAlarmMessage(String id, int request, String name) {
        super(id, request, name);
        this.m_messageType = "ALARM";
    }

    public int getMinutes() {
        return this.m_time;
    }

    public void checkForTicks(String os_version) {
        if (os_version.startsWith(OS_SENDING_TICKS)) {
            this.m_time /= 1092;
        }
    }

    public String getFormatedTime() {
        if (this.m_ftime == null) {
            this.m_ftime = LEUpTimeCompare.FormatTime(this.m_time);
        }
        return this.m_ftime;
    }

    public String getState() {
        return this.m_state;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getSeverity() {
        return this.m_severity;
    }

    public int getCount() {
        return this.m_count;
    }

    public void clear() {
        this.m_state = CLEARED;
    }

    public void setState(String state) {
        this.m_state = state;
    }

    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 58: {
                    this.extractTime(value);
                    break;
                }
                case 59: {
                    this.m_state = value;
                    break;
                }
                case 60: {
                    this.m_message = value;
                    break;
                }
                case 61: {
                    this.m_severity = value;
                    break;
                }
                case 62: {
                    this.m_count = Integer.parseInt(value);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void extractTime(String time) {
        try {
            int ptr = time.indexOf(58);
            if (ptr > -1) {
                int hours = Integer.parseInt(time.substring(0, ptr));
                int minutes = Integer.parseInt(time.substring(ptr + 1));
                this.m_time = hours * 60 + minutes;
            } else {
                ptr = time.indexOf("days");
                if (ptr > -1) {
                    int days = Integer.parseInt(time.substring(0, ptr));
                    this.m_time = days * 1440;
                } else {
                    this.m_time = Integer.parseInt(time);
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

