/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LETokenizer;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public abstract class LEEntityFactory
extends LEAMFactory {
    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        Object obj = msg.getData();
        if (obj instanceof LEEntityMessage) {
            this.notify(observers, msg.getID(), obj);
            return;
        }
        if (!(obj instanceof LETokenizer)) {
            return;
        }
        LETokenizer tok = (LETokenizer)obj;
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return;
        }
        String id = msg.getID();
        long timestamp = msg.getTimestamp();
        LEEntityMessage emsg = null;
        String name = null;
        boolean more = true;
        while (more) {
            try {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp >= 65536) {
                    if (value.equals(name) && value.length() != 0) continue;
                    if (emsg != null) {
                        this.notify(observers, id, emsg);
                    }
                    if ((emsg = this.createMessage(id, request, tmp, value)) != null) {
                        emsg.setTimestamp(timestamp);
                    }
                    name = value;
                    continue;
                }
                if (emsg == null) continue;
                emsg.setAttribute(tmp, value);
            }
            catch (IOException iOException) {
                more = false;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                more = false;
            }
        }
        if (emsg != null) {
            this.notify(observers, id, emsg);
        }
    }

    abstract LEEntityMessage createMessage(String var1, int var2, int var3, String var4);
}

