/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.util.LENumCompare;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;

public class LEMonitorSetting
implements Serializable {
    int m_entity;
    int m_board;
    String m_group;
    String m_start;
    String m_end;
    long m_request;
    String m_key;
    LENumCompare m_comp = new LENumCompare();
    LEVector m_intervals = new LEVector();

    public static String BuildKey(int entity, int board, String group, String start, String end) {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(':');
        if (board > -1) {
            buf.append(board);
        }
        buf.append(':');
        if (group != null) {
            buf.append(group);
        }
        buf.append(':');
        if (start != null) {
            buf.append(start);
        }
        buf.append(':');
        if (end != null) {
            buf.append(end);
        }
        return new String(buf);
    }

    public LEMonitorSetting(int entity, int board, String group, String start, String end, String key) {
        this.m_entity = entity;
        this.m_board = board;
        this.m_group = group;
        this.m_start = start;
        this.m_end = end;
        this.m_key = key == null ? LEMonitorSetting.BuildKey(entity, board, group, start, end) : key;
    }

    public int getEntity() {
        return this.m_entity;
    }

    public int getBoard() {
        return this.m_board;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getStart() {
        return this.m_start;
    }

    public String getEnd() {
        return this.m_end;
    }

    public String getKey() {
        return this.m_key;
    }

    public long getRequest() {
        return this.m_request;
    }

    public void setRequest(long request) {
        this.m_request = request;
    }

    public boolean addInterval(int interval) {
        boolean restart = false;
        int last = this.getSmallestInterval();
        if (interval > 0 && (interval < last || last == 0)) {
            restart = true;
        }
        this.m_intervals.addElement(new Integer(interval));
        this.m_intervals.quickSort(this.m_comp);
        return restart;
    }

    public boolean removeInterval(int interval) {
        boolean restart = false;
        int last = this.getSmallestInterval();
        this.m_intervals.removeElement(new Integer(interval));
        int next = this.getSmallestInterval();
        if (next == 0 || next > last) {
            restart = true;
        }
        return restart;
    }

    public int getSmallestInterval() {
        int interval = 0;
        int len = this.m_intervals.size();
        int i = 0;
        while (i < len && interval == 0) {
            interval = (Integer)this.m_intervals.elementAt(i);
            ++i;
        }
        return interval;
    }

    public int getIntervalCount() {
        return this.m_intervals.size();
    }

    public int getIntervalAt(int index) {
        return (Integer)this.m_intervals.elementAt(index);
    }

    public String toString() {
        return String.valueOf(this.m_key) + " - " + this.m_intervals.toString();
    }
}

